/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx.model;

import com.github.pedrovgs.lynx.exception.IllegalTraceException;
import com.github.pedrovgs.lynx.model.TraceLevel;

public class Trace {
    private static final char TRACE_LEVEL_SEPARATOR = '/';
    private static final int END_OF_DATE_INDEX = 18;
    private static final int START_OF_MESSAGE_INDEX = 21;
    public static final int MIN_TRACE_SIZE = 21;
    public static final int TRACE_LEVEL_INDEX = 19;
    private final TraceLevel level;
    private final String message;

    public Trace(TraceLevel level, String message) {
        this.level = level;
        this.message = message;
    }

    public static Trace fromString(String logcatTrace) throws IllegalTraceException {
        if (logcatTrace == null || logcatTrace.length() < 21 || logcatTrace.charAt(20) != '/') {
            throw new IllegalTraceException("You are trying to create a Trace object from a invalid String. Your trace have to be something like: '02-07 17:45:33.014 D/Any debug trace'.");
        }
        TraceLevel level = TraceLevel.getTraceLevel(logcatTrace.charAt(19));
        String date = logcatTrace.substring(0, 18);
        String message = logcatTrace.substring(21, logcatTrace.length());
        return new Trace(level, date + " " + message);
    }

    public TraceLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trace)) {
            return false;
        }
        Trace trace = (Trace)o;
        return this.level == trace.level && this.message.equals(trace.message);
    }

    public int hashCode() {
        int result = this.level.hashCode();
        result = 31 * result + this.message.hashCode();
        return result;
    }

    public String toString() {
        return "Trace{level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + '}';
    }
}

