/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx.renderer;

import com.github.pedrovgs.lynx.LynxConfig;
import com.github.pedrovgs.lynx.model.Trace;
import com.github.pedrovgs.lynx.model.TraceLevel;
import com.github.pedrovgs.lynx.renderer.AssertTraceRenderer;
import com.github.pedrovgs.lynx.renderer.DebugTraceRenderer;
import com.github.pedrovgs.lynx.renderer.ErrorTraceRenderer;
import com.github.pedrovgs.lynx.renderer.InfoTraceRenderer;
import com.github.pedrovgs.lynx.renderer.TraceRenderer;
import com.github.pedrovgs.lynx.renderer.WarningTraceRenderer;
import com.github.pedrovgs.lynx.renderer.WtfTraceRenderer;
import com.pedrogomez.renderers.RendererBuilder;
import java.util.LinkedList;

public class TraceRendererBuilder
extends RendererBuilder<Trace> {
    public TraceRendererBuilder(LynxConfig lynxConfig) {
        LinkedList<TraceRenderer> prototypes = new LinkedList<TraceRenderer>();
        prototypes.add(new TraceRenderer(lynxConfig));
        prototypes.add(new AssertTraceRenderer(lynxConfig));
        prototypes.add(new DebugTraceRenderer(lynxConfig));
        prototypes.add(new InfoTraceRenderer(lynxConfig));
        prototypes.add(new WarningTraceRenderer(lynxConfig));
        prototypes.add(new ErrorTraceRenderer(lynxConfig));
        prototypes.add(new WtfTraceRenderer(lynxConfig));
        this.setPrototypes(prototypes);
    }

    protected Class getPrototypeClass(Trace content) {
        Class rendererClass = null;
        TraceLevel traceLevel = content.getLevel();
        switch (traceLevel) {
            case ASSERT: {
                rendererClass = AssertTraceRenderer.class;
                break;
            }
            case DEBUG: {
                rendererClass = DebugTraceRenderer.class;
                break;
            }
            case INFO: {
                rendererClass = InfoTraceRenderer.class;
                break;
            }
            case WARNING: {
                rendererClass = WarningTraceRenderer.class;
                break;
            }
            case ERROR: {
                rendererClass = ErrorTraceRenderer.class;
                break;
            }
            case WTF: {
                rendererClass = WtfTraceRenderer.class;
                break;
            }
            default: {
                rendererClass = TraceRenderer.class;
            }
        }
        return rendererClass;
    }
}

