/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import com.plexpt.chatgpt.api.Api;
import com.plexpt.chatgpt.entity.BaseResponse;
import com.plexpt.chatgpt.entity.DeleteResponse;
import com.plexpt.chatgpt.entity.FileResponse;
import com.plexpt.chatgpt.entity.audio.AudioResponse;
import com.plexpt.chatgpt.entity.audio.SpeechRequest;
import com.plexpt.chatgpt.entity.audio.Transcriptions;
import com.plexpt.chatgpt.entity.billing.CreditGrantsResponse;
import com.plexpt.chatgpt.entity.billing.SubscriptionData;
import com.plexpt.chatgpt.entity.billing.UseageResponse;
import com.plexpt.chatgpt.entity.chat.ChatCompletion;
import com.plexpt.chatgpt.entity.chat.ChatCompletionResponse;
import com.plexpt.chatgpt.entity.chat.Message;
import com.plexpt.chatgpt.entity.embedding.EmbeddingRequest;
import com.plexpt.chatgpt.entity.embedding.EmbeddingResult;
import com.plexpt.chatgpt.entity.images.Edits;
import com.plexpt.chatgpt.entity.images.Generations;
import com.plexpt.chatgpt.entity.images.ImagesRensponse;
import com.plexpt.chatgpt.entity.images.Variations;
import com.plexpt.chatgpt.exception.ChatException;
import com.plexpt.chatgpt.util.FormatDateUtil;
import com.plexpt.chatgpt.util.fastjson.JSON;
import io.reactivex.Single;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class ChatGPT {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatGPT.class);
    private String apiKey;
    private List<String> apiKeyList;
    private String apiHost;
    private Api apiClient;
    private OkHttpClient okHttpClient;
    private long timeout;
    private Proxy proxy;

    public ChatGPT init() {
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        client.addInterceptor(chain -> {
            Request original = chain.request();
            String key = this.apiKey;
            if (this.apiKeyList != null && !this.apiKeyList.isEmpty()) {
                key = (String)RandomUtil.randomEle(this.apiKeyList);
            }
            Request request = original.newBuilder().header(Header.AUTHORIZATION.getValue(), "Bearer " + key).header(Header.CONTENT_TYPE.getValue(), ContentType.JSON.getValue()).method(original.method(), original.body()).build();
            return chain.proceed(request);
        }).addInterceptor(chain -> {
            Request original = chain.request();
            Response response = chain.proceed(original);
            if (!response.isSuccessful()) {
                String errorMsg = response.body().string();
                log.error("\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)errorMsg);
                BaseResponse baseResponse = JSON.parseObject(errorMsg, BaseResponse.class);
                if (Objects.nonNull(baseResponse.getError())) {
                    log.error(baseResponse.getError().getMessage());
                    throw new ChatException(baseResponse.getError().getMessage());
                }
                throw new ChatException("ChatGPT init error!");
            }
            return response;
        });
        client.connectTimeout(this.timeout, TimeUnit.SECONDS);
        client.writeTimeout(this.timeout, TimeUnit.SECONDS);
        client.readTimeout(this.timeout, TimeUnit.SECONDS);
        if (Objects.nonNull(this.proxy)) {
            client.proxy(this.proxy);
        }
        this.okHttpClient = client.build();
        this.apiClient = (Api)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(Api.class);
        return this;
    }

    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) {
        Single<ChatCompletionResponse> chatCompletionResponse = this.apiClient.chatCompletion(chatCompletion);
        return (ChatCompletionResponse)chatCompletionResponse.blockingGet();
    }

    public ChatCompletionResponse chatCompletion(List<Message> messages) {
        ChatCompletion chatCompletion = ChatCompletion.builder().messages(messages).build();
        return this.chatCompletion(chatCompletion);
    }

    public String chat(String message) {
        ChatCompletion chatCompletion = ChatCompletion.builder().messages(Arrays.asList(Message.of(message))).build();
        ChatCompletionResponse response = this.chatCompletion(chatCompletion);
        return response.getChoices().get(0).getMessage().getContent();
    }

    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        Single<EmbeddingResult> embeddingResultSingle = this.apiClient.createEmbeddings(request);
        return (EmbeddingResult)embeddingResultSingle.blockingGet();
    }

    public EmbeddingResult createEmbeddings(String input, String user) {
        EmbeddingRequest request = EmbeddingRequest.builder().input(Collections.singletonList(input)).model(EmbeddingRequest.EmbeddingModelEnum.TEXT_EMBEDDING_ADA_002.getModelName()).user(user).build();
        Single<EmbeddingResult> embeddingResultSingle = this.apiClient.createEmbeddings(request);
        return (EmbeddingResult)embeddingResultSingle.blockingGet();
    }

    public ImagesRensponse imageGeneration(Generations generations) {
        Single<ImagesRensponse> imagesRensponse = this.apiClient.imageGenerations(generations);
        return (ImagesRensponse)imagesRensponse.blockingGet();
    }

    public ImagesRensponse imageEdit(File image, File mask, Edits edits) {
        RequestBody i = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data;charset=UTF-8"), (File)image);
        MultipartBody.Part iPart = MultipartBody.Part.createFormData((String)"image", (String)image.getName(), (RequestBody)i);
        RequestBody m = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data;charset=UTF-8"), (File)mask);
        MultipartBody.Part mPart = MultipartBody.Part.createFormData((String)"mask", (String)mask.getName(), (RequestBody)m);
        Single<ImagesRensponse> imagesRensponse = this.apiClient.imageEdits(iPart, mPart, edits);
        return (ImagesRensponse)imagesRensponse.blockingGet();
    }

    public ImagesRensponse imageVariation(File image, Variations variations) {
        RequestBody i = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data;charset=UTF-8"), (File)image);
        MultipartBody.Part iPart = MultipartBody.Part.createFormData((String)"image", (String)image.getName(), (RequestBody)i);
        Single<ImagesRensponse> imagesRensponse = this.apiClient.imageVariations(iPart, variations);
        return (ImagesRensponse)imagesRensponse.blockingGet();
    }

    public AudioResponse audioTranscription(File audio, Transcriptions transcriptions) {
        RequestBody a = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data;charset=UTF-8"), (File)audio);
        MultipartBody.Part aPart = MultipartBody.Part.createFormData((String)"image", (String)audio.getName(), (RequestBody)a);
        Single<AudioResponse> audioResponse = this.apiClient.audioTranscriptions(aPart, transcriptions);
        return (AudioResponse)audioResponse.blockingGet();
    }

    public InputStream audioSpeech(SpeechRequest speechRequest) {
        Single<ResponseBody> audioResponse = this.apiClient.audioSpeech(speechRequest);
        ResponseBody response = (ResponseBody)audioResponse.blockingGet();
        InputStream stream = response.byteStream();
        return stream;
    }

    public AudioResponse audioTranslation(File audio, Transcriptions transcriptions) {
        RequestBody a = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data;charset=UTF-8"), (File)audio);
        MultipartBody.Part aPart = MultipartBody.Part.createFormData((String)"image", (String)audio.getName(), (RequestBody)a);
        Single<AudioResponse> audioResponse = this.apiClient.audioTranslations(aPart, transcriptions);
        return (AudioResponse)audioResponse.blockingGet();
    }

    @Deprecated
    public BigDecimal balance() {
        Single<SubscriptionData> subscription = this.apiClient.subscription();
        SubscriptionData subscriptionData = (SubscriptionData)subscription.blockingGet();
        BigDecimal total = subscriptionData.getHardLimitUsd();
        DateTime start = DateUtil.offsetDay((Date)new Date(), (int)-90);
        DateTime end = DateUtil.offsetDay((Date)new Date(), (int)1);
        Single<UseageResponse> usage = this.apiClient.usage(FormatDateUtil.formatDate((Date)start), FormatDateUtil.formatDate((Date)end));
        UseageResponse useageResponse = (UseageResponse)usage.blockingGet();
        BigDecimal used = useageResponse.getTotalUsage().divide(BigDecimal.valueOf(100L));
        return total.subtract(used);
    }

    @Deprecated
    public static BigDecimal balance(String key) {
        ChatGPT chatGPT = ChatGPT.builder().apiKey(key).build().init();
        return chatGPT.balance();
    }

    @Deprecated
    public CreditGrantsResponse creditGrants() {
        Single<CreditGrantsResponse> creditGrants = this.apiClient.creditGrants();
        return (CreditGrantsResponse)creditGrants.blockingGet();
    }

    public BaseResponse<FileResponse> listFiles() {
        Single<BaseResponse<FileResponse>> files = this.apiClient.listFiles();
        return (BaseResponse)files.blockingGet();
    }

    public FileResponse uploadFile(String purpose, MultipartBody.Part file) {
        RequestBody purposeBody = RequestBody.create((MediaType)MultipartBody.FORM, (String)purpose);
        Single<FileResponse> files = this.apiClient.uploadFile(purposeBody, file);
        return (FileResponse)files.blockingGet();
    }

    public DeleteResponse deleteFile(String fileId) {
        return (DeleteResponse)this.apiClient.deleteFile(fileId).blockingGet();
    }

    public FileResponse retrieveFile(String fileId) {
        return (FileResponse)this.apiClient.retrieveFile(fileId).blockingGet();
    }

    public ResponseBody retrieveFileContent(String fileId) {
        return (ResponseBody)this.apiClient.retrieveFileContent(fileId).blockingGet();
    }

    @Generated
    private static String $default$apiHost() {
        return "https://api.openai.com/";
    }

    @Generated
    private static long $default$timeout() {
        return 300L;
    }

    @Generated
    private static Proxy $default$proxy() {
        return Proxy.NO_PROXY;
    }

    @Generated
    public static ChatGPTBuilder builder() {
        return new ChatGPTBuilder();
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public List<String> getApiKeyList() {
        return this.apiKeyList;
    }

    @Generated
    public String getApiHost() {
        return this.apiHost;
    }

    @Generated
    public Api getApiClient() {
        return this.apiClient;
    }

    @Generated
    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public void setApiKeyList(List<String> apiKeyList) {
        this.apiKeyList = apiKeyList;
    }

    @Generated
    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    @Generated
    public void setApiClient(Api apiClient) {
        this.apiClient = apiClient;
    }

    @Generated
    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Generated
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Generated
    public ChatGPT(String apiKey, List<String> apiKeyList, String apiHost, Api apiClient, OkHttpClient okHttpClient, long timeout, Proxy proxy) {
        this.apiKey = apiKey;
        this.apiKeyList = apiKeyList;
        this.apiHost = apiHost;
        this.apiClient = apiClient;
        this.okHttpClient = okHttpClient;
        this.timeout = timeout;
        this.proxy = proxy;
    }

    @Generated
    public ChatGPT() {
        this.apiHost = ChatGPT.$default$apiHost();
        this.timeout = ChatGPT.$default$timeout();
        this.proxy = ChatGPT.$default$proxy();
    }

    @Generated
    public static class ChatGPTBuilder {
        @Generated
        private String apiKey;
        @Generated
        private List<String> apiKeyList;
        @Generated
        private boolean apiHost$set;
        @Generated
        private String apiHost$value;
        @Generated
        private Api apiClient;
        @Generated
        private OkHttpClient okHttpClient;
        @Generated
        private boolean timeout$set;
        @Generated
        private long timeout$value;
        @Generated
        private boolean proxy$set;
        @Generated
        private Proxy proxy$value;

        @Generated
        ChatGPTBuilder() {
        }

        @Generated
        public ChatGPTBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public ChatGPTBuilder apiKeyList(List<String> apiKeyList) {
            this.apiKeyList = apiKeyList;
            return this;
        }

        @Generated
        public ChatGPTBuilder apiHost(String apiHost) {
            this.apiHost$value = apiHost;
            this.apiHost$set = true;
            return this;
        }

        @Generated
        public ChatGPTBuilder apiClient(Api apiClient) {
            this.apiClient = apiClient;
            return this;
        }

        @Generated
        public ChatGPTBuilder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        @Generated
        public ChatGPTBuilder timeout(long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @Generated
        public ChatGPTBuilder proxy(Proxy proxy) {
            this.proxy$value = proxy;
            this.proxy$set = true;
            return this;
        }

        @Generated
        public ChatGPT build() {
            String apiHost$value = this.apiHost$value;
            if (!this.apiHost$set) {
                apiHost$value = ChatGPT.$default$apiHost();
            }
            long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = ChatGPT.$default$timeout();
            }
            Proxy proxy$value = this.proxy$value;
            if (!this.proxy$set) {
                proxy$value = ChatGPT.$default$proxy();
            }
            return new ChatGPT(this.apiKey, this.apiKeyList, apiHost$value, this.apiClient, this.okHttpClient, timeout$value, proxy$value);
        }

        @Generated
        public String toString() {
            return "ChatGPT.ChatGPTBuilder(apiKey=" + this.apiKey + ", apiKeyList=" + this.apiKeyList + ", apiHost$value=" + this.apiHost$value + ", apiClient=" + this.apiClient + ", okHttpClient=" + this.okHttpClient + ", timeout$value=" + this.timeout$value + ", proxy$value=" + this.proxy$value + ")";
        }
    }
}

