/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt;

import com.plexpt.chatgpt.ChatGPT;
import com.plexpt.chatgpt.ChatGPTStream;
import com.plexpt.chatgpt.entity.chat.Message;
import com.plexpt.chatgpt.listener.ConsoleStreamListener;
import com.plexpt.chatgpt.util.Proxys;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleChatGPT {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsoleChatGPT.class);
    public static Proxy proxy = Proxy.NO_PROXY;

    public static void main(String[] args) {
        System.out.println("ChatGPT - Java command-line interface");
        System.out.println("Press enter twice to submit your question.");
        System.out.println();
        System.out.println("\u6309\u4e24\u6b21\u56de\u8f66\u4ee5\u63d0\u4ea4\u60a8\u7684\u95ee\u9898\uff01\uff01\uff01");
        System.out.println("\u6309\u4e24\u6b21\u56de\u8f66\u4ee5\u63d0\u4ea4\u60a8\u7684\u95ee\u9898\uff01\uff01\uff01");
        System.out.println("\u6309\u4e24\u6b21\u56de\u8f66\u4ee5\u63d0\u4ea4\u60a8\u7684\u95ee\u9898\uff01\uff01\uff01");
        System.out.println();
        System.out.println("Please enter APIKEY, press Enter twice to submit:");
        String key = ConsoleChatGPT.getInput("\u8bf7\u8f93\u5165APIKEY\uff0c\u6309\u4e24\u6b21\u56de\u8f66\u4ee5\u63d0\u4ea4:\n");
        ConsoleChatGPT.check(key);
        System.out.println("\u662f\u5426\u4f7f\u7528\u4ee3\u7406\uff1f(y/n): ");
        System.out.println("use proxy\uff1f(y/n): ");
        String useProxy = ConsoleChatGPT.getInput("\u6309\u4e24\u6b21\u56de\u8f66\u4ee5\u63d0\u4ea4:\n");
        if (useProxy.equalsIgnoreCase("y")) {
            System.out.println("\u8bf7\u8f93\u5165\u4ee3\u7406\u7c7b\u578b(http/socks): ");
            String type = ConsoleChatGPT.getInput("\u6309\u4e24\u6b21\u56de\u8f66\u4ee5\u63d0\u4ea4:\n");
            System.out.println("\u8bf7\u8f93\u5165\u4ee3\u7406IP: ");
            String proxyHost = ConsoleChatGPT.getInput("\u6309\u4e24\u6b21\u56de\u8f66\u4ee5\u63d0\u4ea4:\n");
            System.out.println("\u8bf7\u8f93\u5165\u4ee3\u7406\u7aef\u53e3: ");
            String portStr = ConsoleChatGPT.getInput("\u6309\u4e24\u6b21\u56de\u8f66\u4ee5\u63d0\u4ea4:\n");
            Integer proxyPort = Integer.parseInt(portStr);
            proxy = type.equals("http") ? Proxys.http(proxyHost, proxyPort) : Proxys.socks5(proxyHost, proxyPort);
        }
        while (true) {
            String prompt = ConsoleChatGPT.getInput("\nYou:\n");
            ChatGPTStream chatGPT = ChatGPTStream.builder().apiKey(key).proxy(proxy).build().init();
            System.out.println("AI: ");
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Message message = Message.of(prompt);
            ConsoleStreamListener listener = new ConsoleStreamListener(){

                @Override
                public void onError(Throwable throwable, String response) {
                    throwable.printStackTrace();
                    countDownLatch.countDown();
                }
            };
            listener.setOnComplete(msg -> countDownLatch.countDown());
            chatGPT.streamChatCompletion(Arrays.asList(message), (EventSourceListener)listener);
            try {
                countDownLatch.await();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static BigDecimal getBalance(String key) {
        ChatGPT chatGPT = ChatGPT.builder().apiKey(key).proxy(proxy).build().init();
        return chatGPT.balance();
    }

    private static void check(String key) {
        if (key == null || key.isEmpty()) {
            throw new RuntimeException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684KEY");
        }
    }

    public static String getInput(String prompt) {
        System.out.print(prompt);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null && !line.isEmpty()) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines.stream().collect(Collectors.joining("\n"));
    }
}

