/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt.entity.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.plexpt.chatgpt.entity.chat.ChatTool;
import com.plexpt.chatgpt.entity.chat.Message;
import com.plexpt.chatgpt.entity.chat.ResponseFormat;
import com.plexpt.chatgpt.entity.chat.StreamOption;
import com.plexpt.chatgpt.util.TokensUtil;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ChatCompletion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatCompletion.class);
    @NonNull
    private String model;
    @NonNull
    private List<Message> messages;
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="tool_choice")
    String toolChoice;
    List<ChatTool> tools;
    Integer n;
    Boolean stream;
    List<String> stop;
    @JsonProperty(value="max_tokens")
    Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    Double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    Map logitBias;
    String user;
    @JsonProperty(value="response_format")
    ResponseFormat responseFormat;
    Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    Integer topLogprobs;
    Integer seed;
    @JsonProperty(value="service_tier")
    String serviceTier;
    @JsonProperty(value="stream_options")
    StreamOption streamOptions;
    @JsonProperty(value="parallel_tool_calls")
    Boolean parallelToolCalls;

    public int countTokens() {
        return TokensUtil.tokens(this.model, this.messages);
    }

    @Generated
    private static String $default$model() {
        return "gpt-3.5-turbo";
    }

    @Generated
    private static Integer $default$n() {
        return 1;
    }

    @Generated
    private static Boolean $default$stream() {
        return false;
    }

    @Generated
    public static ChatCompletionBuilder builder() {
        return new ChatCompletionBuilder();
    }

    @NonNull
    @Generated
    public String getModel() {
        return this.model;
    }

    @NonNull
    @Generated
    public List<Message> getMessages() {
        return this.messages;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Double getTopP() {
        return this.topP;
    }

    @Generated
    public String getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public List<ChatTool> getTools() {
        return this.tools;
    }

    @Generated
    public Integer getN() {
        return this.n;
    }

    @Generated
    public Boolean getStream() {
        return this.stream;
    }

    @Generated
    public List<String> getStop() {
        return this.stop;
    }

    @Generated
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    @Generated
    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    @Generated
    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @Generated
    public Map getLogitBias() {
        return this.logitBias;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    @Generated
    public Boolean getLogprobs() {
        return this.logprobs;
    }

    @Generated
    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    @Generated
    public Integer getSeed() {
        return this.seed;
    }

    @Generated
    public String getServiceTier() {
        return this.serviceTier;
    }

    @Generated
    public StreamOption getStreamOptions() {
        return this.streamOptions;
    }

    @Generated
    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    @Generated
    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    @Generated
    public void setMessages(@NonNull List<Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    @Generated
    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    @Generated
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonProperty(value="tool_choice")
    @Generated
    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    @Generated
    public void setTools(List<ChatTool> tools) {
        this.tools = tools;
    }

    @Generated
    public void setN(Integer n) {
        this.n = n;
    }

    @Generated
    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    @Generated
    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    @Generated
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="presence_penalty")
    @Generated
    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    @Generated
    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="logit_bias")
    @Generated
    public void setLogitBias(Map logitBias) {
        this.logitBias = logitBias;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @JsonProperty(value="response_format")
    @Generated
    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @Generated
    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    @JsonProperty(value="top_logprobs")
    @Generated
    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    @Generated
    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    @JsonProperty(value="service_tier")
    @Generated
    public void setServiceTier(String serviceTier) {
        this.serviceTier = serviceTier;
    }

    @JsonProperty(value="stream_options")
    @Generated
    public void setStreamOptions(StreamOption streamOptions) {
        this.streamOptions = streamOptions;
    }

    @JsonProperty(value="parallel_tool_calls")
    @Generated
    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletion)) {
            return false;
        }
        ChatCompletion other = (ChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Double this$presencePenalty = this.getPresencePenalty();
        Double other$presencePenalty = other.getPresencePenalty();
        if (this$presencePenalty == null ? other$presencePenalty != null : !((Object)this$presencePenalty).equals(other$presencePenalty)) {
            return false;
        }
        Double this$frequencyPenalty = this.getFrequencyPenalty();
        Double other$frequencyPenalty = other.getFrequencyPenalty();
        if (this$frequencyPenalty == null ? other$frequencyPenalty != null : !((Object)this$frequencyPenalty).equals(other$frequencyPenalty)) {
            return false;
        }
        Boolean this$logprobs = this.getLogprobs();
        Boolean other$logprobs = other.getLogprobs();
        if (this$logprobs == null ? other$logprobs != null : !((Object)this$logprobs).equals(other$logprobs)) {
            return false;
        }
        Integer this$topLogprobs = this.getTopLogprobs();
        Integer other$topLogprobs = other.getTopLogprobs();
        if (this$topLogprobs == null ? other$topLogprobs != null : !((Object)this$topLogprobs).equals(other$topLogprobs)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Boolean this$parallelToolCalls = this.getParallelToolCalls();
        Boolean other$parallelToolCalls = other.getParallelToolCalls();
        if (this$parallelToolCalls == null ? other$parallelToolCalls != null : !((Object)this$parallelToolCalls).equals(other$parallelToolCalls)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$toolChoice = this.getToolChoice();
        String other$toolChoice = other.getToolChoice();
        if (this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice)) {
            return false;
        }
        List<ChatTool> this$tools = this.getTools();
        List<ChatTool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map this$logitBias = this.getLogitBias();
        Map other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        ResponseFormat this$responseFormat = this.getResponseFormat();
        ResponseFormat other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !((Object)this$responseFormat).equals(other$responseFormat)) {
            return false;
        }
        String this$serviceTier = this.getServiceTier();
        String other$serviceTier = other.getServiceTier();
        if (this$serviceTier == null ? other$serviceTier != null : !this$serviceTier.equals(other$serviceTier)) {
            return false;
        }
        StreamOption this$streamOptions = this.getStreamOptions();
        StreamOption other$streamOptions = other.getStreamOptions();
        return !(this$streamOptions == null ? other$streamOptions != null : !((Object)this$streamOptions).equals(other$streamOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Double $presencePenalty = this.getPresencePenalty();
        result = result * 59 + ($presencePenalty == null ? 43 : ((Object)$presencePenalty).hashCode());
        Double $frequencyPenalty = this.getFrequencyPenalty();
        result = result * 59 + ($frequencyPenalty == null ? 43 : ((Object)$frequencyPenalty).hashCode());
        Boolean $logprobs = this.getLogprobs();
        result = result * 59 + ($logprobs == null ? 43 : ((Object)$logprobs).hashCode());
        Integer $topLogprobs = this.getTopLogprobs();
        result = result * 59 + ($topLogprobs == null ? 43 : ((Object)$topLogprobs).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Boolean $parallelToolCalls = this.getParallelToolCalls();
        result = result * 59 + ($parallelToolCalls == null ? 43 : ((Object)$parallelToolCalls).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        List<ChatTool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        ResponseFormat $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : ((Object)$responseFormat).hashCode());
        String $serviceTier = this.getServiceTier();
        result = result * 59 + ($serviceTier == null ? 43 : $serviceTier.hashCode());
        StreamOption $streamOptions = this.getStreamOptions();
        result = result * 59 + ($streamOptions == null ? 43 : ((Object)$streamOptions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChatCompletion(model=" + this.getModel() + ", messages=" + this.getMessages() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", toolChoice=" + this.getToolChoice() + ", tools=" + this.getTools() + ", n=" + this.getN() + ", stream=" + this.getStream() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ", responseFormat=" + this.getResponseFormat() + ", logprobs=" + this.getLogprobs() + ", topLogprobs=" + this.getTopLogprobs() + ", seed=" + this.getSeed() + ", serviceTier=" + this.getServiceTier() + ", streamOptions=" + this.getStreamOptions() + ", parallelToolCalls=" + this.getParallelToolCalls() + ")";
    }

    @Generated
    public ChatCompletion(@NonNull String model, @NonNull List<Message> messages, Double temperature, Double topP, String toolChoice, List<ChatTool> tools, Integer n, Boolean stream, List<String> stop, Integer maxTokens, Double presencePenalty, Double frequencyPenalty, Map logitBias, String user, ResponseFormat responseFormat, Boolean logprobs, Integer topLogprobs, Integer seed, String serviceTier, StreamOption streamOptions, Boolean parallelToolCalls) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
        this.topP = topP;
        this.toolChoice = toolChoice;
        this.tools = tools;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
        this.responseFormat = responseFormat;
        this.logprobs = logprobs;
        this.topLogprobs = topLogprobs;
        this.seed = seed;
        this.serviceTier = serviceTier;
        this.streamOptions = streamOptions;
        this.parallelToolCalls = parallelToolCalls;
    }

    @Generated
    public ChatCompletion() {
        this.model = ChatCompletion.$default$model();
        this.n = ChatCompletion.$default$n();
        this.stream = ChatCompletion.$default$stream();
    }

    @Generated
    public static class ChatCompletionBuilder {
        @Generated
        private boolean model$set;
        @Generated
        private String model$value;
        @Generated
        private List<Message> messages;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private String toolChoice;
        @Generated
        private List<ChatTool> tools;
        @Generated
        private boolean n$set;
        @Generated
        private Integer n$value;
        @Generated
        private boolean stream$set;
        @Generated
        private Boolean stream$value;
        @Generated
        private List<String> stop;
        @Generated
        private Integer maxTokens;
        @Generated
        private Double presencePenalty;
        @Generated
        private Double frequencyPenalty;
        @Generated
        private Map logitBias;
        @Generated
        private String user;
        @Generated
        private ResponseFormat responseFormat;
        @Generated
        private Boolean logprobs;
        @Generated
        private Integer topLogprobs;
        @Generated
        private Integer seed;
        @Generated
        private String serviceTier;
        @Generated
        private StreamOption streamOptions;
        @Generated
        private Boolean parallelToolCalls;

        @Generated
        ChatCompletionBuilder() {
        }

        @Generated
        public ChatCompletionBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        @Generated
        public ChatCompletionBuilder messages(@NonNull List<Message> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        @Generated
        public ChatCompletionBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        @Generated
        public ChatCompletionBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @JsonProperty(value="tool_choice")
        @Generated
        public ChatCompletionBuilder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @Generated
        public ChatCompletionBuilder tools(List<ChatTool> tools) {
            this.tools = tools;
            return this;
        }

        @Generated
        public ChatCompletionBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        @Generated
        public ChatCompletionBuilder stream(Boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this;
        }

        @Generated
        public ChatCompletionBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        @Generated
        public ChatCompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        @Generated
        public ChatCompletionBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        @Generated
        public ChatCompletionBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="logit_bias")
        @Generated
        public ChatCompletionBuilder logitBias(Map logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        @Generated
        public ChatCompletionBuilder user(String user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="response_format")
        @Generated
        public ChatCompletionBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public ChatCompletionBuilder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        @JsonProperty(value="top_logprobs")
        @Generated
        public ChatCompletionBuilder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        @Generated
        public ChatCompletionBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        @JsonProperty(value="service_tier")
        @Generated
        public ChatCompletionBuilder serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        @JsonProperty(value="stream_options")
        @Generated
        public ChatCompletionBuilder streamOptions(StreamOption streamOptions) {
            this.streamOptions = streamOptions;
            return this;
        }

        @JsonProperty(value="parallel_tool_calls")
        @Generated
        public ChatCompletionBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        @Generated
        public ChatCompletion build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = ChatCompletion.$default$model();
            }
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = ChatCompletion.$default$n();
            }
            Boolean stream$value = this.stream$value;
            if (!this.stream$set) {
                stream$value = ChatCompletion.$default$stream();
            }
            return new ChatCompletion(model$value, this.messages, this.temperature, this.topP, this.toolChoice, this.tools, n$value, stream$value, this.stop, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user, this.responseFormat, this.logprobs, this.topLogprobs, this.seed, this.serviceTier, this.streamOptions, this.parallelToolCalls);
        }

        @Generated
        public String toString() {
            return "ChatCompletion.ChatCompletionBuilder(model$value=" + this.model$value + ", messages=" + this.messages + ", temperature=" + this.temperature + ", topP=" + this.topP + ", toolChoice=" + this.toolChoice + ", tools=" + this.tools + ", n$value=" + this.n$value + ", stream$value=" + this.stream$value + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + ", responseFormat=" + this.responseFormat + ", logprobs=" + this.logprobs + ", topLogprobs=" + this.topLogprobs + ", seed=" + this.seed + ", serviceTier=" + this.serviceTier + ", streamOptions=" + this.streamOptions + ", parallelToolCalls=" + this.parallelToolCalls + ")";
        }
    }

    public static interface Model {
        public static final String GPT_3_5_TURBO = "gpt-3.5-turbo";
        public static final String GPT4 = "gpt-4";
        public static final String GPT4o = "gpt-4o";
        public static final String GPT4oMini = "gpt-4o-mini";
    }
}

