/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt.entity.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.plexpt.chatgpt.entity.chat.ToolCallResult;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Message {
    private String role;
    private String content;
    private String name;
    @JsonProperty(value="tool_calls")
    private List<ToolCallResult> toolCalls;

    public Message(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public static Message of(String content) {
        return new Message(Role.USER.getValue(), content);
    }

    public static Message ofSystem(String content) {
        return new Message(Role.SYSTEM.getValue(), content);
    }

    public static Message ofAssistant(String content) {
        return new Message(Role.ASSISTANT.getValue(), content);
    }

    public static Message ofFunction(String function) {
        return new Message(Role.FUNCTION.getValue(), function);
    }

    @Generated
    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<ToolCallResult> getToolCalls() {
        return this.toolCalls;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="tool_calls")
    @Generated
    public void setToolCalls(List<ToolCallResult> toolCalls) {
        this.toolCalls = toolCalls;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ToolCallResult> this$toolCalls = this.getToolCalls();
        List<ToolCallResult> other$toolCalls = other.getToolCalls();
        return !(this$toolCalls == null ? other$toolCalls != null : !((Object)this$toolCalls).equals(other$toolCalls));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ToolCallResult> $toolCalls = this.getToolCalls();
        result = result * 59 + ($toolCalls == null ? 43 : ((Object)$toolCalls).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Message(role=" + this.getRole() + ", content=" + this.getContent() + ", name=" + this.getName() + ", toolCalls=" + this.getToolCalls() + ")";
    }

    @Generated
    public Message(String role, String content, String name, List<ToolCallResult> toolCalls) {
        this.role = role;
        this.content = content;
        this.name = name;
        this.toolCalls = toolCalls;
    }

    @Generated
    public Message() {
    }

    @Generated
    public static class MessageBuilder {
        @Generated
        private String role;
        @Generated
        private String content;
        @Generated
        private String name;
        @Generated
        private List<ToolCallResult> toolCalls;

        @Generated
        MessageBuilder() {
        }

        @Generated
        public MessageBuilder role(String role) {
            this.role = role;
            return this;
        }

        @Generated
        public MessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public MessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="tool_calls")
        @Generated
        public MessageBuilder toolCalls(List<ToolCallResult> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        @Generated
        public Message build() {
            return new Message(this.role, this.content, this.name, this.toolCalls);
        }

        @Generated
        public String toString() {
            return "Message.MessageBuilder(role=" + this.role + ", content=" + this.content + ", name=" + this.name + ", toolCalls=" + this.toolCalls + ")";
        }
    }

    public static enum Role {
        SYSTEM("system"),
        USER("user"),
        ASSISTANT("assistant"),
        FUNCTION("function");

        private String value;

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        private Role(String value) {
            this.value = value;
        }
    }
}

