/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt.listener;

import com.plexpt.chatgpt.entity.chat.ChatCompletionResponse;
import com.plexpt.chatgpt.util.fastjson.JSON;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractStreamListener
extends EventSourceListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractStreamListener.class);
    protected String lastMessage = "";
    protected Consumer<String> onComplete = s -> {};

    public abstract void onMsg(String var1);

    public abstract void onError(Throwable var1, String var2);

    public void onOpen(EventSource eventSource, Response response) {
    }

    public void onClosed(EventSource eventSource) {
    }

    public void onEvent(EventSource eventSource, String id, String type, String data) {
        if (data.equals("[DONE]")) {
            this.onComplete.accept(this.lastMessage);
            return;
        }
        ChatCompletionResponse response = JSON.parseObject(data, ChatCompletionResponse.class);
        String text = response.toPlainStringStream();
        if (!StringUtils.isEmpty((Object)text)) {
            this.lastMessage = this.lastMessage + text;
            this.onMsg(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(EventSource eventSource, Throwable throwable, Response response) {
        try {
            log.error("Stream connection error: {}", throwable);
            String responseText = "";
            if (Objects.nonNull(response)) {
                responseText = response.body().string();
            }
            log.error("response\uff1a{}", (Object)responseText);
            this.onError(throwable, responseText);
        }
        catch (Exception e) {
            log.warn("onFailure error:{}", (Throwable)e);
        }
        finally {
            eventSource.cancel();
        }
    }

    @Generated
    public void setOnComplete(Consumer<String> onComplete) {
        this.onComplete = onComplete;
    }

    @Generated
    public Consumer<String> getOnComplete() {
        return this.onComplete;
    }
}

