/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt.util.fastjson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.plexpt.chatgpt.util.fastjson.JSONArray;
import com.plexpt.chatgpt.util.fastjson.JSONObject;
import com.plexpt.chatgpt.util.fastjson.exception.ParseException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSON {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JSON.class);
    private static final String STANDARD_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static String toJSONString(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static String toJSONString(Object obj, boolean pretty) {
        if (!pretty) {
            return JSON.toJSONString(obj);
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> String obj2StringPretty(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.warn("Parse Object to String error : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static Object parse(String jsonString) {
        if (JSON.isJsonObj(jsonString)) {
            return JSON.parseObject(jsonString);
        }
        if (JSON.isJsonArray(jsonString)) {
            return JSON.parseArray(jsonString);
        }
        try {
            return objectMapper.readValue(jsonString, JsonNode.class);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static JSONObject parseObject(String jsonString) {
        try {
            Map map = (Map)objectMapper.readValue(jsonString, Map.class);
            return JSON.mapToJsonObject(map);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T parseObject(String jsonString, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(jsonString, clazz);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static JSONArray parseArray(String jsonString) {
        try {
            List list = (List)objectMapper.readValue(jsonString, List.class);
            return JSON.listConvertToJsonArray(list);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> List<T> parseArray(String jsonString, Class<T> clazz) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
            return (List)objectMapper.readValue(jsonString, javaType);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T parseJSONArray(String jsonArray, TypeReference<T> reference) {
        Object t = null;
        try {
            t = objectMapper.readValue(jsonArray, reference);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        return (T)t;
    }

    public static JsonNode parseJSONObject(String jsonString) {
        JsonNode jsonNode = null;
        try {
            jsonNode = objectMapper.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            log.error("JSONString\u8f6c\u4e3aJsonNode\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return jsonNode;
    }

    public static JsonNode parseJSONObject(Object object) {
        JsonNode jsonNode = objectMapper.valueToTree(object);
        return jsonNode;
    }

    public static String toJSONString(JsonNode jsonNode) {
        String jsonString = null;
        try {
            jsonString = objectMapper.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            log.error("JsonNode\u8f6cJSONString\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return jsonString;
    }

    public static boolean isJson(String str) {
        return JSON.isJsonObj(str) || JSON.isJsonArray(str);
    }

    public static boolean isJsonObj(String str) {
        if (JSON.isBlank(str)) {
            return false;
        }
        return JSON.isWrap(str.trim(), '{', '}');
    }

    public static boolean isJsonArray(String str) {
        if (JSON.isBlank(str)) {
            return false;
        }
        return JSON.isWrap(str.trim(), '[', ']');
    }

    private static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static boolean isWrap(String str, char start, char end) {
        if (JSON.isBlank(str)) {
            return false;
        }
        return str.charAt(0) == start && str.charAt(str.length() - 1) == end;
    }

    private static JSONArray listConvertToJsonArray(List list) {
        ArrayList<Object> jsonObjects = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            jsonObjects.add(JSON.mapToJsonObject((Map)obj));
        }
        return new JSONArray(jsonObjects);
    }

    private static JSONObject mapToJsonObject(Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                jsonObject.put(entry.getKey(), (Object)JSON.mapToJsonObject((Map)value));
                continue;
            }
            if (value instanceof List) {
                List listVal = (List)value;
                JSONArray objects = new JSONArray(listVal.size());
                for (Object o : listVal) {
                    if (o instanceof Map) {
                        objects.add(JSON.mapToJsonObject((Map)o));
                        continue;
                    }
                    if (!(o instanceof List)) continue;
                    objects.add(JSON.listConvertToJsonArray((List)o));
                }
                jsonObject.put(entry.getKey(), (Object)objects);
                continue;
            }
            jsonObject.put(entry.getKey(), value);
        }
        return jsonObject;
    }

    public static void main(String[] args) {
        String str = "[{\"id\":\"czpv7jeb08baq8\",\"name\":\"{\\\"ja\\\":\\\"\u4e00\u884c\u4e8c\u5217\\\",\\\"en\\\":\\\"1 Row/2 Columns\\\",\\\"zh\\\":\\\"\u4e00\u884c\u4e24\u5217\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"twoColumns\",\"controlType\":\"grid\",\"name\":{\"ja\":\"\u4e00\u884c\u4e8c\u5217\",\"en\":\"1 Row/2 Columns\",\"zh\":\"\u4e00\u884c\u4e24\u5217\"},\"icon\":\"&#xe610;\",\"isChooseDefault\":false,\"caption\":{\"ja\":\"\u4e00\u884c\u4e8c\u5217\",\"en\":\"1 Row/2 Columns\",\"zh\":\"\u4e00\u884c\u4e24\u5217\"},\"pid\":0,\"id\":\"czpv7jeb08baq8\",\"required\":false,\"actived\":false,\"vModel\":\"twoColumns_czpv7jeb08baq8\"}},{\"id\":\"cqv0lb6zv3w19n\",\"name\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u4e00\u884c\u4e24\u5217\u5de6\u4fa7\\\"}\",\"required\":true,\"tempAttr\":{\"xtype\":\"div\",\"name\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u4e00\u884c\u4e24\u5217\u5de6\u4fa7\"},\"isChooseDefault\":false,\"pid\":\"czpv7jeb08baq8\",\"id\":\"cqv0lb6zv3w19n\",\"required\":true,\"actived\":false}},{\"id\":\"c6ps5bwq4f6x1o\",\"name\":\"{\\\"ja\\\":\\\"\u5358\u6570\u884c\u5165\u529b\u30dc\u30c3\u30af\u30b9\\\",\\\"en\\\":\\\"Single-line Box\\\",\\\"zh\\\":\\\"\u5355\u884c\u8f93\u5165\u6846\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"input\",\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"icon\":\"icondanhang\",\"caption\":{\"ja\":\"\",\"en\":\"Single line input field\",\"zh\":\"\u5355\u884c\u8f93\u5165\u6846\"},\"captionMaxLength\":100,\"pid\":\"cqv0lb6zv3w19n\",\"captionMinLength\":10,\"visibleState\":\"default\",\"required\":false,\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"name\":{\"ja\":\"\u5358\u6570\u884c\u5165\u529b\u30dc\u30c3\u30af\u30b9\",\"en\":\"Single-line Box\",\"zh\":\"\u5355\u884c\u8f93\u5165\u6846\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\"},\"id\":\"c6ps5bwq4f6x1o\",\"maxLength\":400,\"actived\":false,\"vModel\":\"input_c6ps5bwq4f6x1o\"}},{\"id\":\"c8wrg7tlxpopdd\",\"name\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u4e00\u884c\u4e24\u5217\u53f3\u4fa7\\\"}\",\"required\":true,\"tempAttr\":{\"xtype\":\"div\",\"name\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u4e00\u884c\u4e24\u5217\u53f3\u4fa7\"},\"isChooseDefault\":false,\"pid\":\"czpv7jeb08baq8\",\"id\":\"c8wrg7tlxpopdd\",\"required\":true,\"actived\":false}},{\"caption\":{\"en\":\"number\",\"ja\":\"\",\"zh\":\"\u6570\u5b57\u8f93\u5165\u6846\"},\"id\":\"cgrck7x66l5fxq\",\"name\":\"{\\\"ja\\\":\\\"\u6570\u5b57\u5165\u529b\u30dc\u30c3\u30af\u30b9\\\",\\\"en\\\":\\\"Number Box\\\",\\\"zh\\\":\\\"\u6570\u5b57\u8f93\u5165\u6846\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"number\",\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"rangeMin\":\"\",\"icon\":\"iconnum\",\"caption\":{\"ja\":\"\",\"en\":\"number\",\"zh\":\"\u6570\u5b57\u8f93\u5165\u6846\"},\"captionMaxLength\":100,\"pid\":\"c8wrg7tlxpopdd\",\"float\":0,\"required\":false,\"unit\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\"},\"labelPosition\":\"top\",\"rangeMax\":\"\",\"placeholderMaxLength\":100,\"unitMaxLength\":10,\"valueType\":0,\"isEncrypted\":false,\"name\":{\"ja\":\"\u6570\u5b57\u5165\u529b\u30dc\u30c3\u30af\u30b9\",\"en\":\"Number Box\",\"zh\":\"\u6570\u5b57\u8f93\u5165\u6846\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\"},\"id\":\"cgrck7x66l5fxq\",\"actived\":false,\"vModel\":\"number_cgrck7x66l5fxq\"},\"unit\":{\"en\":\"\",\"ja\":\"\",\"zh\":\"\"}},{\"caption\":{\"en\":\"Multiple lines of input field\",\"ja\":\"\",\"zh\":\"\u591a\u884c\u8f93\u5165\u6846\"},\"id\":\"cwx5dyzrbtns6z\",\"maxLength\":30000,\"name\":\"{\\\"ja\\\":\\\"\u8907\u6570\u884c\u5165\u529b\u30dc\u30c3\u30af\u30b9\\\",\\\"en\\\":\\\"Multi-line Box\\\",\\\"zh\\\":\\\"\u591a\u884c\u8f93\u5165\u6846\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"textarea\",\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"icon\":\"iconduohang\",\"caption\":{\"ja\":\"\",\"en\":\"Multiple lines of input field\",\"zh\":\"\u591a\u884c\u8f93\u5165\u6846\"},\"captionMaxLength\":100,\"pid\":0,\"captionMinLength\":10,\"visibleState\":\"default\",\"rows\":2,\"required\":false,\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"name\":{\"ja\":\"\u8907\u6570\u884c\u5165\u529b\u30dc\u30c3\u30af\u30b9\",\"en\":\"Multi-line Box\",\"zh\":\"\u591a\u884c\u8f93\u5165\u6846\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\"},\"id\":\"cwx5dyzrbtns6z\",\"maxLength\":30000,\"actived\":false,\"vModel\":\"textarea_cwx5dyzrbtns6z\"}},{\"caption\":{\"en\":\"amount\",\"ja\":\"\",\"zh\":\"\u91d1\u989d\"},\"id\":\"c2w6rckildjrpe\",\"isCapital\":\"true\",\"name\":\"{\\\"ja\\\":\\\"\u91d1\u984d\\\",\\\"en\\\":\\\"Amount\\\",\\\"zh\\\":\\\"\u91d1\u989d\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"currency\",\"is_capital\":true,\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"rangeMin\":\"\",\"icon\":\"iconYUAN1\",\"caption\":{\"ja\":\"\",\"en\":\"amount\",\"zh\":\"\u91d1\u989d\"},\"captionMaxLength\":100,\"pid\":0,\"float\":0,\"isChooseCurrency\":true,\"required\":false,\"unit\":\"0\",\"labelPosition\":\"top\",\"rangeMax\":\"\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"name\":{\"ja\":\"\u91d1\u984d\",\"en\":\"Amount\",\"zh\":\"\u91d1\u989d\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\u91d1\u989d\"},\"id\":\"c2w6rckildjrpe\",\"actived\":false,\"vModel\":\"currency_c2w6rckildjrpe\"},\"unit\":{\"en\":\"\",\"ja\":\"\",\"zh\":\"0\"}},{\"id\":\"c8ob6ogo2amfbw\",\"name\":\"{\\\"ja\\\":\\\"\u5206\u5272\u7dda\\\",\\\"en\\\":\\\"Split Line\\\",\\\"zh\\\":\\\"\u5206\u5272\u7ebf\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"divider\",\"color\":\"#d9d9d9\",\"icon\":\"iconDividingline\",\"caption\":{\"ja\":\"\u5206\u5272\u7dda\",\"en\":\"Split Line\",\"zh\":\"\u5206\u5272\u7ebf\"},\"dividerClassName\":\"solid-line\",\"pid\":0,\"required\":false,\"labelPosition\":\"top\",\"name\":{\"ja\":\"\u5206\u5272\u7dda\",\"en\":\"Split Line\",\"zh\":\"\u5206\u5272\u7ebf\"},\"isChooseDefault\":false,\"id\":\"c8ob6ogo2amfbw\",\"actived\":false,\"vModel\":\"divider_c8ob6ogo2amfbw\"}},{\"caption\":{\"en\":\"pull-down\",\"ja\":\"\",\"zh\":\"\u4e0b\u62c9\u83dc\u5355\"},\"id\":\"ckfr0w61nxpa4k\",\"name\":\"{\\\"ja\\\":\\\"\u30c9\u30ed\u30c3\u30d7\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\\\",\\\"en\\\":\\\"Drop-down Menu\\\",\\\"zh\\\":\\\"\u4e0b\u62c9\u83dc\u5355\\\"}\",\"options\":[{\"optionId\":\"ckfr0w61nxpa4kc6v2e634v9f9eo\",\"text\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u9009\u98791\\\"}\",\"value\":\"ckfr0w61nxpa4kc6v2e634v9f9eo\"},{\"optionId\":\"ckfr0w61nxpa4kc79zwi1yqs0uot\",\"text\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u9009\u98792\\\"}\",\"value\":\"ckfr0w61nxpa4kc79zwi1yqs0uot\"},{\"optionId\":\"ckfr0w61nxpa4kc5kqk06xnfcj9d\",\"text\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u9009\u98793\\\"}\",\"value\":\"ckfr0w61nxpa4kc5kqk06xnfcj9d\"}],\"required\":false,\"tempAttr\":{\"xtype\":\"select\",\"chainData\":{},\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"icon\":\"iconpullup\",\"caption\":{\"ja\":\"\",\"en\":\"pull-down\",\"zh\":\"\u4e0b\u62c9\u83dc\u5355\"},\"captionMaxLength\":100,\"pid\":0,\"required\":false,\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"showSearch\":true,\"name\":{\"ja\":\"\u30c9\u30ed\u30c3\u30d7\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\",\"en\":\"Drop-down Menu\",\"zh\":\"\u4e0b\u62c9\u83dc\u5355\"},\"options\":[{\"hasManyShow\":[],\"hasManyHide\":[],\"option_id\":\"ckfr0w61nxpa4kc6v2e634v9f9eo\",\"text\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u98791\"},\"value\":\"ckfr0w61nxpa4kc6v2e634v9f9eo\"},{\"hasManyShow\":[],\"hasManyHide\":[],\"option_id\":\"ckfr0w61nxpa4kc79zwi1yqs0uot\",\"text\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u98792\"},\"value\":\"ckfr0w61nxpa4kc79zwi1yqs0uot\"},{\"hasManyShow\":[],\"hasManyHide\":[],\"option_id\":\"ckfr0w61nxpa4kc5kqk06xnfcj9d\",\"text\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u98793\"},\"value\":\"ckfr0w61nxpa4kc5kqk06xnfcj9d\"}],\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u9009\u62e9\"},\"id\":\"ckfr0w61nxpa4k\",\"actived\":false,\"vModel\":\"select_ckfr0w61nxpa4k\"}},{\"id\":\"cij9uj19quo7p2\",\"name\":\"{\\\"ja\\\":\\\"\u30ab\u30fc\u30c9\u30b0\u30eb\u30fc\u30d7\u5206\u3051\\\",\\\"en\\\":\\\"Card Group\\\",\\\"zh\\\":\\\"\u5361\u7247\u5206\u7ec4\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"cardGroup\",\"controlType\":\"grid\",\"name\":{\"ja\":\"\u30ab\u30fc\u30c9\u30b0\u30eb\u30fc\u30d7\u5206\u3051\",\"en\":\"Card Group\",\"zh\":\"\u5361\u7247\u5206\u7ec4\"},\"icon\":\"&#xe610;\",\"isChooseDefault\":false,\"caption\":{\"ja\":\"\u30ab\u30fc\u30c9\u30b0\u30eb\u30fc\u30d7\u5206\u3051\",\"en\":\"Card Group\",\"zh\":\"\u5361\u7247\u5206\u7ec4\"},\"pid\":0,\"id\":\"cij9uj19quo7p2\",\"required\":false,\"actived\":false,\"vModel\":\"cardGroup_cij9uj19quo7p2\"}},{\"caption\":{\"en\":\"radio button\",\"ja\":\"\",\"zh\":\"\u5355\u9009\u6846\"},\"id\":\"cof6ezra2lizdr\",\"name\":\"{\\\"ja\\\":\\\"\u30e9\u30b8\u30aa\u30dc\u30c3\u30af\u30b9\\\",\\\"en\\\":\\\"Radio Button\\\",\\\"zh\\\":\\\"\u5355\u9009\u6846\\\"}\",\"options\":[{\"optionId\":\"cof6ezra2lizdrcm4i6c1hqpma0g\",\"text\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u9009\u98791\\\"}\",\"value\":\"cof6ezra2lizdrcm4i6c1hqpma0g\"},{\"optionId\":\"cof6ezra2lizdrc814hlvykcb0q3\",\"text\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u9009\u98792\\\"}\",\"value\":\"cof6ezra2lizdrc814hlvykcb0q3\"},{\"optionId\":\"cof6ezra2lizdrcho1eavxds1ujq\",\"text\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u9009\u98793\\\"}\",\"value\":\"cof6ezra2lizdrcho1eavxds1ujq\"}],\"required\":false,\"tempAttr\":{\"xtype\":\"radio\",\"chainData\":{},\"checkboxValue\":\"1\",\"defaultValue\":\"\",\"icon\":\"iconradio\",\"caption\":{\"ja\":\"\",\"en\":\"radio button\",\"zh\":\"\u5355\u9009\u6846\"},\"captionMaxLength\":100,\"pid\":\"cij9uj19quo7p2\",\"type\":1,\"required\":false,\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"name\":{\"ja\":\"\u30e9\u30b8\u30aa\u30dc\u30c3\u30af\u30b9\",\"en\":\"Radio Button\",\"zh\":\"\u5355\u9009\u6846\"},\"options\":[{\"hasManyShow\":[],\"hasManyHide\":[],\"option_id\":\"cof6ezra2lizdrcm4i6c1hqpma0g\",\"text\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u98791\"},\"value\":\"cof6ezra2lizdrcm4i6c1hqpma0g\"},{\"hasManyShow\":[],\"hasManyHide\":[],\"option_id\":\"cof6ezra2lizdrc814hlvykcb0q3\",\"text\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u98792\"},\"value\":\"cof6ezra2lizdrc814hlvykcb0q3\"},{\"hasManyShow\":[],\"hasManyHide\":[],\"option_id\":\"cof6ezra2lizdrcho1eavxds1ujq\",\"text\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u98793\"},\"value\":\"cof6ezra2lizdrcho1eavxds1ujq\"}],\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u52fe\u9009\"},\"id\":\"cof6ezra2lizdr\",\"actived\":false,\"vModel\":\"radio_cof6ezra2lizdr\"}},{\"caption\":{\"en\":\"check box\",\"ja\":\"\",\"zh\":\"\u591a\u9009\u6846\"},\"id\":\"ctac6cut8gkpc1\",\"name\":\"{\\\"ja\\\":\\\"\u8907\u6570\u9078\u629e\u30ea\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\\\",\\\"en\\\":\\\"Checkbox\\\",\\\"zh\\\":\\\"\u591a\u9009\u6846\\\"}\",\"options\":[{\"optionId\":\"ctac6cut8gkpc1cicy4dcqi7ej4x\",\"text\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u9009\u98791\\\"}\",\"value\":\"ctac6cut8gkpc1cicy4dcqi7ej4x\"},{\"optionId\":\"ctac6cut8gkpc1c34wh8qndhzlj6\",\"text\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u9009\u98792\\\"}\",\"value\":\"ctac6cut8gkpc1c34wh8qndhzlj6\"},{\"optionId\":\"ctac6cut8gkpc1c1k0ng96ro7xtw\",\"text\":\"{\\\"ja\\\":\\\"\\\",\\\"en\\\":\\\"\\\",\\\"zh\\\":\\\"\u9009\u98793\\\"}\",\"value\":\"ctac6cut8gkpc1c1k0ng96ro7xtw\"}],\"required\":false,\"tempAttr\":{\"xtype\":\"checkbox\",\"chainData\":{},\"max\":\"\",\"defaultValue\":[],\"checkboxValue\":\"1\",\"icon\":\"iconcheck-square\",\"caption\":{\"ja\":\"\",\"en\":\"check box\",\"zh\":\"\u591a\u9009\u6846\"},\"captionMaxLength\":100,\"pid\":\"cij9uj19quo7p2\",\"type\":1,\"required\":false,\"min\":\"\",\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"name\":{\"ja\":\"\u8907\u6570\u9078\u629e\u30ea\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\",\"en\":\"Checkbox\",\"zh\":\"\u591a\u9009\u6846\"},\"options\":[{\"hasManyShow\":[],\"hasManyHide\":[],\"option_id\":\"ctac6cut8gkpc1cicy4dcqi7ej4x\",\"text\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u98791\"},\"value\":\"ctac6cut8gkpc1cicy4dcqi7ej4x\"},{\"hasManyShow\":[],\"hasManyHide\":[],\"option_id\":\"ctac6cut8gkpc1c34wh8qndhzlj6\",\"text\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u98792\"},\"value\":\"ctac6cut8gkpc1c34wh8qndhzlj6\"},{\"hasManyShow\":[],\"hasManyHide\":[],\"option_id\":\"ctac6cut8gkpc1c1k0ng96ro7xtw\",\"text\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u98793\"},\"value\":\"ctac6cut8gkpc1c1k0ng96ro7xtw\"}],\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u52fe\u9009\"},\"id\":\"ctac6cut8gkpc1\",\"value\":[],\"actived\":false,\"vModel\":\"checkbox_ctac6cut8gkpc1\"}},{\"caption\":{\"en\":\"personnel\",\"ja\":\"\",\"zh\":\"\u4eba\u5458\"},\"id\":\"cyk8p1c0uetxe1\",\"name\":\"{\\\"ja\\\":\\\"\u30e1\u30f3\u30d0\u30fc\\\",\\\"en\\\":\\\"Personnel\\\",\\\"zh\\\":\\\"\u4eba\u5458\\\"}\",\"range\":\"all\",\"required\":false,\"tempAttr\":{\"xtype\":\"linkMan\",\"defaultValueUserList\":[],\"checkboxValue\":\"1\",\"defaultValue\":[],\"checkedValue\":false,\"multiple\":true,\"icon\":\"iconpeople\",\"caption\":{\"ja\":\"\",\"en\":\"personnel\",\"zh\":\"\u4eba\u5458\"},\"range\":\"all\",\"defaultValueAsign\":\"designated\",\"captionMaxLength\":100,\"pid\":0,\"required\":false,\"listId\":[],\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"name\":{\"ja\":\"\u30e1\u30f3\u30d0\u30fc\",\"en\":\"Personnel\",\"zh\":\"\u4eba\u5458\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\u59d3\u540d\u3001\u90ae\u7bb1\u524d\u7f00\"},\"id\":\"cyk8p1c0uetxe1\",\"actived\":false,\"vModel\":\"linkMan_cyk8p1c0uetxe1\"}},{\"caption\":{\"en\":\"department\",\"ja\":\"\",\"zh\":\"\u90e8\u95e8\"},\"id\":\"cze76ccvnaltku\",\"name\":\"{\\\"ja\\\":\\\"\u90e8\u9580\\\",\\\"en\\\":\\\"Department\\\",\\\"zh\\\":\\\"\u90e8\u95e8\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"department\",\"defaultValueDepartmentList\":[],\"checkboxValue\":\"1\",\"defaultValue\":[],\"multiple\":true,\"icon\":\"iconvisitor_tenant\",\"caption\":{\"ja\":\"\",\"en\":\"department\",\"zh\":\"\u90e8\u95e8\"},\"defaultValueAsign\":\"designated\",\"captionMaxLength\":100,\"pid\":0,\"rows\":2,\"required\":false,\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"name\":{\"ja\":\"\u90e8\u9580\",\"en\":\"Department\",\"zh\":\"\u90e8\u95e8\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\u90e8\u95e8\"},\"id\":\"cze76ccvnaltku\",\"departments\":[],\"actived\":true,\"vModel\":\"department_cze76ccvnaltku\"}},{\"id\":\"c62ezbfftcxzvq\",\"name\":\"{\\\"ja\\\":\\\"\u30ab\u30fc\u30c9\u30b0\u30eb\u30fc\u30d7\u5206\u3051\\\",\\\"en\\\":\\\"Card Group\\\",\\\"zh\\\":\\\"\u5361\u7247\u5206\u7ec4\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"cardGroup\",\"controlType\":\"grid\",\"name\":{\"ja\":\"\u30ab\u30fc\u30c9\u30b0\u30eb\u30fc\u30d7\u5206\u3051\",\"en\":\"Card Group\",\"zh\":\"\u5361\u7247\u5206\u7ec4\"},\"icon\":\"&#xe610;\",\"isChooseDefault\":false,\"caption\":{\"ja\":\"\u30ab\u30fc\u30c9\u30b0\u30eb\u30fc\u30d7\u5206\u3051\",\"en\":\"Card Group\",\"zh\":\"\u5361\u7247\u5206\u7ec4\"},\"pid\":0,\"id\":\"c62ezbfftcxzvq\",\"required\":false,\"actived\":false,\"vModel\":\"cardGroup_c62ezbfftcxzvq\"}},{\"caption\":{\"en\":\"date\",\"ja\":\"\",\"zh\":\"\u65e5\u671f\"},\"id\":\"cqd2fejebws7tl\",\"name\":\"{\\\"ja\\\":\\\"\u65e5\u4ed8\\\",\\\"en\\\":\\\"Date\\\",\\\"zh\\\":\\\"\u65e5\u671f\\\"}\",\"required\":false,\"tempAttr\":{\"timeZoneConfiguration\":\"absoluteTime\",\"defaultValue\":\"\",\"isShowTimeZone\":false,\"icon\":\"iconcalendar\",\"caption\":{\"ja\":\"\",\"en\":\"date\",\"zh\":\"\u65e5\u671f\"},\"pid\":\"c62ezbfftcxzvq\",\"systemTime\":\"\",\"required\":false,\"dateType\":\"date\",\"limitDateSavedList\":[],\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"isChooseDefault\":false,\"disabled\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u62e9\u65e5\u671f\"},\"id\":\"cqd2fejebws7tl\",\"actived\":false,\"vModel\":\"date_cqd2fejebws7tl\",\"defaultDate\":false,\"xtype\":\"date\",\"checkboxValue\":\"1\",\"captionMaxLength\":100,\"defaultType\":\"\",\"name\":{\"ja\":\"\u65e5\u4ed8\",\"en\":\"Date\",\"zh\":\"\u65e5\u671f\"},\"defaultValueTimeZone\":{\"zh_name\":\"(GMT+8:00)\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4 - \u4e0a\u6d77\",\"code\":\"Asia/Shanghai\",\"en_name\":\"(GMT+8:00)China Standard Time - Shanghai\",\"id\":\"Asia/Shanghai\",\"ja_name\":\"(GMT+8:00)\u4e2d\u56fd\u6a19\u6e96\u6642 - \u4e0a\u6d77\"}}},{\"id\":\"cpe1hovktz9dzx\",\"name\":\"{\\\"ja\\\":\\\"\u65e5\u4ed8\u533a\u9593\\\",\\\"en\\\":\\\"Date Range\\\",\\\"zh\\\":\\\"\u65e5\u671f\u533a\u95f4\\\"}\",\"required\":false,\"tempAttr\":{\"dateDiff\":true,\"timeZoneConfiguration\":\"absoluteTime\",\"defaultValue\":[],\"isShowTimeZone\":false,\"icon\":\"iconDateinterval\",\"caption\":{\"ja\":\"\",\"en\":\"date interval\",\"zh\":\"\u65e5\u671f\u533a\u95f4\"},\"pid\":\"c62ezbfftcxzvq\",\"required\":false,\"dateType\":\"daterange\",\"limitDateSavedList\":[],\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"isChooseDefault\":false,\"disabled\":false,\"end\":\"\",\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u9009\u62e9\u65e5\u671f\"},\"id\":\"cpe1hovktz9dzx\",\"actived\":false,\"vModel\":\"daterange_cpe1hovktz9dzx\",\"xtype\":\"daterange\",\"checkboxValue\":\"1\",\"start\":\"\",\"captionMaxLength\":100,\"name\":{\"ja\":\"\u65e5\u4ed8\u533a\u9593\",\"en\":\"Date Range\",\"zh\":\"\u65e5\u671f\u533a\u95f4\"},\"defaultValueTimeZone\":{\"zh_name\":\"(GMT+8:00)\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4 - \u4e0a\u6d77\",\"code\":\"Asia/Shanghai\",\"en_name\":\"(GMT+8:00)China Standard Time - Shanghai\",\"id\":\"Asia/Shanghai\",\"ja_name\":\"(GMT+8:00)\u4e2d\u56fd\u6a19\u6e96\u6642 - \u4e0a\u6d77\"}}},{\"caption\":{\"en\":\"photo\",\"ja\":\"\",\"zh\":\"\u56fe\u7247\"},\"id\":\"c23t346jet3152\",\"name\":\"{\\\"ja\\\":\\\"\u753b\u50cf\\\",\\\"en\\\":\\\"Image\\\",\\\"zh\\\":\\\"\u56fe\u7247\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"pic\",\"checkboxValue\":\"1\",\"defaultValue\":[],\"icon\":\"iconpic1\",\"caption\":{\"ja\":\"\",\"en\":\"photo\",\"zh\":\"\u56fe\u7247\"},\"captionMaxLength\":100,\"pid\":0,\"required\":false,\"dateType\":\"pic\",\"defaultValuePicList\":[],\"labelPosition\":\"top\",\"isEncrypted\":false,\"name\":{\"ja\":\"\u753b\u50cf\",\"en\":\"Image\",\"zh\":\"\u56fe\u7247\"},\"placeholder\":\"\",\"id\":\"c23t346jet3152\",\"actived\":false,\"vModel\":\"pic_c23t346jet3152\"}},{\"caption\":{\"en\":\"file\",\"ja\":\"\",\"zh\":\"\u9644\u4ef6\"},\"id\":\"czwy03e4xteml2\",\"name\":\"{\\\"ja\\\":\\\"\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\\\",\\\"en\\\":\\\"Attachment\\\",\\\"zh\\\":\\\"\u9644\u4ef6\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"attachment\",\"checkboxValue\":\"1\",\"defaultValue\":[],\"multiple\":true,\"icon\":\"iconEnclosure\",\"caption\":{\"ja\":\"\",\"en\":\"file\",\"zh\":\"\u9644\u4ef6\"},\"captionMaxLength\":100,\"pid\":0,\"required\":false,\"labelPosition\":\"top\",\"isEncrypted\":false,\"name\":{\"ja\":\"\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\",\"en\":\"Attachment\",\"zh\":\"\u9644\u4ef6\"},\"isChooseDefault\":false,\"id\":\"czwy03e4xteml2\",\"actived\":false,\"vModel\":\"attachment_czwy03e4xteml2\"}},{\"caption\":{\"en\":\"The rich text box\",\"ja\":\"\",\"zh\":\"\u5bcc\u6587\u672c\u6846\"},\"id\":\"cmfym7k5hwngoo\",\"maxLength\":30000,\"name\":\"{\\\"ja\\\":\\\"\u30ea\u30c3\u30c1\u30c6\u30ad\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\\\",\\\"en\\\":\\\"Rich Textbox\\\",\\\"zh\\\":\\\"\u5bcc\u6587\u672c\u6846\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"richText\",\"checkboxValue\":\"1\",\"icon\":\"icondanju1\",\"caption\":{\"ja\":\"\",\"en\":\"The rich text box\",\"zh\":\"\u5bcc\u6587\u672c\u6846\"},\"captionMaxLength\":100,\"pid\":0,\"captionMinLength\":10,\"rows\":2,\"required\":false,\"labelPosition\":\"top\",\"placeholderMaxLength\":20,\"name\":{\"ja\":\"\u30ea\u30c3\u30c1\u30c6\u30ad\u30b9\u30c8\u30dc\u30c3\u30af\u30b9\",\"en\":\"Rich Textbox\",\"zh\":\"\u5bcc\u6587\u672c\u6846\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\"},\"id\":\"cmfym7k5hwngoo\",\"maxLength\":30000,\"actived\":false,\"vModel\":\"richText_cmfym7k5hwngoo\"}},{\"caption\":{\"en\":\"design formulas\",\"ja\":\"\",\"zh\":\"\u8ba1\u7b97\u516c\u5f0f\"},\"id\":\"c0dbn6mvyvd7a7\",\"name\":\"{\\\"ja\\\":\\\"\u8a08\u7b97\u5f0f\\\",\\\"en\\\":\\\"Formula\\\",\\\"zh\\\":\\\"\u8ba1\u7b97\u516c\u5f0f\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"calculator\",\"edit\":true,\"checkboxValue\":\"2\",\"icon\":\"iconjisuan\",\"caption\":{\"ja\":\"\",\"en\":\"design formulas\",\"zh\":\"\u8ba1\u7b97\u516c\u5f0f\"},\"captionMaxLength\":40,\"pid\":0,\"required\":false,\"unit\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\"},\"decimalPlaces\":2,\"labelPosition\":\"top\",\"unitMaxLength\":20,\"name\":{\"ja\":\"\u8a08\u7b97\u5f0f\",\"en\":\"Formula\",\"zh\":\"\u8ba1\u7b97\u516c\u5f0f\"},\"isChooseDefault\":false,\"formula\":[{\"xtype\":\"number\",\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"rangeMin\":\"\",\"icon\":\"iconnum\",\"caption\":\"\u6570\u5b57\u8f93\u5165\u6846\",\"captionMaxLength\":100,\"pid\":\"c8wrg7tlxpopdd\",\"type\":\"ControlVariable\",\"float\":0,\"required\":false,\"unit\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\"},\"labelPosition\":\"top\",\"rangeMax\":\"\",\"placeholderMaxLength\":100,\"unitMaxLength\":10,\"valueType\":0,\"isEncrypted\":false,\"name\":{\"ja\":\"\u6570\u5b57\u5165\u529b\u30dc\u30c3\u30af\u30b9\",\"en\":\"Number Box\",\"zh\":\"\u6570\u5b57\u8f93\u5165\u6846\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\"},\"id\":\"cgrck7x66l5fxq\",\"actived\":false,\"vModel\":\"number_cgrck7x66l5fxq\"},{\"caption\":\"+\",\"type\":\"Operator\"},{\"xtype\":\"currency\",\"is_capital\":true,\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"rangeMin\":\"\",\"icon\":\"iconYUAN1\",\"caption\":\"\u91d1\u989d\",\"captionMaxLength\":100,\"pid\":0,\"type\":\"ControlVariable\",\"float\":0,\"isChooseCurrency\":true,\"required\":false,\"unit\":\"0\",\"labelPosition\":\"top\",\"rangeMax\":\"\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"name\":{\"ja\":\"\u91d1\u984d\",\"en\":\"Amount\",\"zh\":\"\u91d1\u989d\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\u91d1\u989d\"},\"id\":\"c2w6rckildjrpe\",\"actived\":false,\"vModel\":\"currency_c2w6rckildjrpe\"}],\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8ba1\u7b97\u516c\u5f0f\"},\"id\":\"c0dbn6mvyvd7a7\",\"actived\":false,\"vModel\":\"calculator_c0dbn6mvyvd7a7\"}},{\"caption\":{\"en\":\"association form\",\"ja\":\"\",\"zh\":\"\u5173\u8054\u8868\u5355\"},\"id\":\"cxs430hjxewxx3\",\"isMultiSelect\":false,\"linkFbKey\":\"1b243704fbb44e869d644be0d771bae3\",\"name\":\"{\\\"ja\\\":\\\"\u95a2\u9023\u30d5\u30a9\u30fc\u30e0\\\",\\\"en\\\":\\\"Associated Form\\\",\\\"zh\\\":\\\"\u5173\u8054\u8868\u5355\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"linkForm\",\"formNameJSON\":\"{\\\"zh\\\":\\\"yy\u56de\u5f52\u9a8c\u8bc1\u7684\u8868\u5355\\\",\\\"en\\\":\\\"yy\u56de\u5f52\u9a8c\u8bc1\u7684\u8868\u5355\\\",\\\"ja\\\":\\\"yy\u56de\u5f52\u9a8c\u8bc1\u7684\u8868\u5355\\\"}\",\"checkboxValue\":\"1\",\"icon\":\"iconpreviewlist\",\"caption\":{\"ja\":\"\",\"en\":\"association form\",\"zh\":\"\u5173\u8054\u8868\u5355\"},\"captionMaxLength\":100,\"isMultiple\":true,\"pid\":0,\"required\":false,\"link_fb_key\":\"1b243704fbb44e869d644be0d771bae3\",\"labelPosition\":\"top\",\"link_form_name\":\"{\\\"en\\\":\\\"\\\",\\\"ja\\\":\\\"\\\",\\\"zh\\\":\\\"yy\u56de\u5f52\u9a8c\u8bc1\u7684\u8868\u5355\\\"}\",\"name\":{\"ja\":\"\u95a2\u9023\u30d5\u30a9\u30fc\u30e0\",\"en\":\"Associated Form\",\"zh\":\"\u5173\u8054\u8868\u5355\"},\"isChooseDefault\":false,\"id\":\"cxs430hjxewxx3\",\"actived\":false,\"vModel\":\"linkForm_cxs430hjxewxx3\"}},{\"id\":\"ctjjv0p6ncflwy\",\"name\":\"{\\\"ja\\\":\\\"\u8aac\u660e\u30c6\u30ad\u30b9\u30c8\\\",\\\"en\\\":\\\"Caption\\\",\\\"zh\\\":\\\"\u8bf4\u660e\u6587\u5b57\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"text\",\"hidden\":false,\"checkboxValue\":\"1\",\"icon\":\"iconhint\",\"caption\":{\"ja\":\"\",\"en\":\"Explanatory text Explanatory text Explanatory text\",\"zh\":\"\u8bf4\u660e\u6587\u5b57\u8bf4\u660e\u6587\u5b57\u8bf4\u660e\u6587\u5b57\u8bf4\u660e\u6587\u5b57\"},\"pid\":0,\"url\":\"\",\"required\":false,\"labelPosition\":\"top\",\"name\":{\"ja\":\"\u8aac\u660e\u30c6\u30ad\u30b9\u30c8\",\"en\":\"Caption\",\"zh\":\"\u8bf4\u660e\u6587\u5b57\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\u8bf4\u660e\u6587\u5b57\"},\"id\":\"ctjjv0p6ncflwy\",\"actived\":false,\"vModel\":\"text_ctjjv0p6ncflwy\"}},{\"id\":\"c54t2z1vvg43g8\",\"name\":\"{\\\"ja\\\":\\\"\u660e\u7ec6\u30b5\u30d6\u30c6\u30fc\u30d6\u30eb\\\",\\\"en\\\":\\\"Detailed Sub-Form\\\",\\\"zh\\\":\\\"\u660e\u7ec6\u5b50\u8868\\\"}\",\"required\":false,\"tempAttr\":{\"col\":2,\"xtype\":\"table\",\"checkboxValue\":\"1\",\"icon\":\"&#xe610;\",\"caption\":{\"ja\":\"\u660e\u7ec6\u30b5\u30d6\u30c6\u30fc\u30d6\u30eb\",\"en\":\"Detailed Sub-Form\",\"zh\":\"\u660e\u7ec6\u5b50\u8868\"},\"pid\":0,\"isSupportImport\":false,\"required\":false,\"head\":[{\"id\":\"ctap8wfw183ks1\",\"name\":\"{\\\"ja\\\":\\\"\u5358\u6570\u884c\u5165\u529b\u30dc\u30c3\u30af\u30b9\\\",\\\"en\\\":\\\"Single-line Box\\\",\\\"zh\\\":\\\"\u5355\u884c\u8f93\u5165\u6846\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"input\",\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"fromDetailDetailTable\":true,\"icon\":\"icondanhang\",\"caption\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u5355\u884c\u8f93\u5165\u6846\"},\"captionMaxLength\":100,\"captionMinLength\":10,\"visibleState\":\"default\",\"required\":false,\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"name\":{\"ja\":\"\u5358\u6570\u884c\u5165\u529b\u30dc\u30c3\u30af\u30b9\",\"en\":\"Single-line Box\",\"zh\":\"\u5355\u884c\u8f93\u5165\u6846\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\"},\"id\":\"ctap8wfw183ks1\",\"maxLength\":400,\"actived\":false,\"vModel\":\"input_ctap8wfw183ks1\"}},{\"caption\":{\"en\":\"\",\"ja\":\"\",\"zh\":\"\u91d1\u989d\"},\"id\":\"cvz4d9sbvbqgsm\",\"isCapital\":\"true\",\"name\":\"{\\\"ja\\\":\\\"\u91d1\u984d\\\",\\\"en\\\":\\\"Amount\\\",\\\"zh\\\":\\\"\u91d1\u989d\\\"}\",\"required\":false,\"tempAttr\":{\"xtype\":\"currency\",\"is_capital\":true,\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"rangeMin\":\"\",\"fromDetailDetailTable\":true,\"icon\":\"iconYUAN1\",\"caption\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u91d1\u989d\"},\"captionMaxLength\":100,\"float\":0,\"isChooseCurrency\":true,\"required\":false,\"unit\":\"0\",\"labelPosition\":\"top\",\"rangeMax\":\"\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"name\":{\"ja\":\"\u91d1\u984d\",\"en\":\"Amount\",\"zh\":\"\u91d1\u989d\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\u91d1\u989d\"},\"id\":\"cvz4d9sbvbqgsm\",\"actived\":false,\"vModel\":\"currency_cvz4d9sbvbqgsm\"},\"unit\":{\"en\":\"\",\"ja\":\"\",\"zh\":\"0\"}}],\"controlType\":\"grid\",\"children\":[[{\"xtype\":\"input\",\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"fromDetailDetailTable\":true,\"icon\":\"icondanhang\",\"caption\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u5355\u884c\u8f93\u5165\u6846\"},\"captionMaxLength\":100,\"captionMinLength\":10,\"visibleState\":\"default\",\"required\":false,\"labelPosition\":\"top\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"name\":{\"ja\":\"\u5358\u6570\u884c\u5165\u529b\u30dc\u30c3\u30af\u30b9\",\"en\":\"Single-line Box\",\"zh\":\"\u5355\u884c\u8f93\u5165\u6846\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\"},\"id\":\"ctap8wfw183ks1\",\"maxLength\":400,\"actived\":false,\"vModel\":\"input_ctap8wfw183ks1\"}],[{\"xtype\":\"currency\",\"is_capital\":true,\"defaultValue\":\"\",\"checkboxValue\":\"1\",\"rangeMin\":\"\",\"fromDetailDetailTable\":true,\"icon\":\"iconYUAN1\",\"caption\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u91d1\u989d\"},\"captionMaxLength\":100,\"float\":0,\"isChooseCurrency\":true,\"required\":false,\"unit\":\"0\",\"labelPosition\":\"top\",\"rangeMax\":\"\",\"placeholderMaxLength\":100,\"isEncrypted\":false,\"name\":{\"ja\":\"\u91d1\u984d\",\"en\":\"Amount\",\"zh\":\"\u91d1\u989d\"},\"isChooseDefault\":false,\"placeholder\":{\"ja\":\"\",\"en\":\"\",\"zh\":\"\u8bf7\u8f93\u5165\u91d1\u989d\"},\"id\":\"cvz4d9sbvbqgsm\",\"actived\":false,\"vModel\":\"currency_cvz4d9sbvbqgsm\"}]],\"name\":{\"ja\":\"\u660e\u7ec6\u30b5\u30d6\u30c6\u30fc\u30d6\u30eb\",\"en\":\"Detailed Sub-Form\",\"zh\":\"\u660e\u7ec6\u5b50\u8868\"},\"width\":\"100%\",\"isChooseDefault\":false,\"row\":1,\"id\":\"c54t2z1vvg43g8\",\"actived\":false,\"vModel\":\"table_c54t2z1vvg43g8\"}}]";
        JSONArray parse = JSON.parseArray(str);
        System.out.println();
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(STANDARD_FORMAT));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

