/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.core.JsonToken;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JsonDeserializer;
import wiremock.com.fasterxml.jackson.databind.PropertyName;
import wiremock.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import wiremock.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import wiremock.com.fasterxml.jackson.databind.util.ClassUtil;

public final class InnerClassProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final SettableBeanProperty _delegate;
    protected final Constructor<?> _creator;

    public InnerClassProperty(SettableBeanProperty delegate, Constructor<?> ctor) {
        super(delegate);
        this._delegate = delegate;
        this._creator = ctor;
    }

    protected InnerClassProperty(InnerClassProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._delegate = src._delegate.withValueDeserializer(deser);
        this._creator = src._creator;
    }

    protected InnerClassProperty(InnerClassProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._delegate = src._delegate.withName(newName);
        this._creator = src._creator;
    }

    @Override
    public InnerClassProperty withName(PropertyName newName) {
        return new InnerClassProperty(this, newName);
    }

    @Override
    public InnerClassProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new InnerClassProperty(this, deser);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._delegate.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._delegate.getMember();
    }

    @Override
    public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        Object value;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            value = this._nullProvider == null ? null : this._nullProvider.nullValue(ctxt);
        } else if (this._valueTypeDeserializer != null) {
            value = this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        } else {
            try {
                value = this._creator.newInstance(bean);
            }
            catch (Exception e) {
                ClassUtil.unwrapAndThrowAsIAE(e, "Failed to instantiate class " + this._creator.getDeclaringClass().getName() + ", problem: " + e.getMessage());
                value = null;
            }
            this._valueDeserializer.deserialize(jp, ctxt, value);
        }
        this.set(bean, value);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        return this.setAndReturn(instance, this.deserialize(jp, ctxt));
    }

    @Override
    public final void set(Object instance, Object value) throws IOException {
        this._delegate.set(instance, value);
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this._delegate.setAndReturn(instance, value);
    }
}

