/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.skyscreamer.jsonassert;

import wiremock.org.skyscreamer.jsonassert.JSONCompareResult;
import wiremock.org.skyscreamer.jsonassert.LocationAwareValueMatcher;
import wiremock.org.skyscreamer.jsonassert.ValueMatcher;
import wiremock.org.skyscreamer.jsonassert.ValueMatcherException;

public final class Customization {
    private final String path;
    private final ValueMatcher<Object> comparator;

    public Customization(String path, ValueMatcher<Object> comparator) {
        assert (path != null);
        assert (comparator != null);
        this.path = path;
        this.comparator = comparator;
    }

    public static Customization customization(String path, ValueMatcher<Object> comparator) {
        return new Customization(path, comparator);
    }

    public boolean appliesToPath(String path) {
        return this.path.equals(path);
    }

    @Deprecated
    public boolean matches(Object actual, Object expected) {
        return this.comparator.equal(actual, expected);
    }

    public boolean matches(String prefix, Object actual, Object expected, JSONCompareResult result) throws ValueMatcherException {
        if (this.comparator instanceof LocationAwareValueMatcher) {
            return ((LocationAwareValueMatcher)this.comparator).equal(prefix, actual, expected, result);
        }
        return this.comparator.equal(actual, expected);
    }
}

