/*
 * Decompiled with CFR 0.152.
 */
package com.github.tuupertunut.powershelllibjava;

import com.github.tuupertunut.powershelllibjava.AsyncReaderRecorder;
import com.github.tuupertunut.powershelllibjava.PowerShellExecutionException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PowerShell
implements Closeable {
    private static final String DEFAULT_WIN_EXECUTABLE = "powershell";
    private static final String DEFAULT_CORE_EXECUTABLE = "pwsh";
    private static final String END_OF_COMMAND = "end-of-command-8Nb77LFv";
    private final Process psSession;
    private final BufferedReader commandOutput;
    private final BufferedReader commandErrorOutput;
    private final AsyncReaderRecorder outputRecorder;
    private final AsyncReaderRecorder errorOutputRecorder;
    private final ExecutorService executor;
    private final PrintWriter commandInput;
    private boolean closed;

    private PowerShell(String psExecutable) throws IOException {
        this.psSession = PowerShell.createProcessBuilder(psExecutable).start();
        this.commandOutput = new BufferedReader(new InputStreamReader(this.psSession.getInputStream(), StandardCharsets.UTF_8));
        this.commandErrorOutput = new BufferedReader(new InputStreamReader(this.psSession.getErrorStream(), StandardCharsets.UTF_8));
        this.outputRecorder = new AsyncReaderRecorder(this.commandOutput);
        this.errorOutputRecorder = new AsyncReaderRecorder(this.commandErrorOutput);
        this.executor = Executors.newFixedThreadPool(2, r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.executor.execute(this.outputRecorder);
        this.executor.execute(this.errorOutputRecorder);
        this.commandInput = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.psSession.getOutputStream(), StandardCharsets.UTF_8)), true);
        this.closed = false;
    }

    private static ProcessBuilder createProcessBuilder(String psExecutable) {
        if (PowerShell.isWindows()) {
            return new ProcessBuilder("cmd", "/c", "chcp 65001 > NUL", "&", psExecutable, "-ExecutionPolicy", "Bypass", "-NoExit", "-Command", "-");
        }
        return new ProcessBuilder(psExecutable, "-ExecutionPolicy", "Bypass", "-NoExit", "-Command", "-");
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static String getDefaultExecutable() {
        if (PowerShell.isWindows()) {
            return DEFAULT_WIN_EXECUTABLE;
        }
        return DEFAULT_CORE_EXECUTABLE;
    }

    public static PowerShell open() throws IOException {
        return new PowerShell(PowerShell.getDefaultExecutable());
    }

    public static PowerShell open(String customExecutable) throws IOException {
        return new PowerShell(customExecutable);
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.commandInput != null) {
            this.commandInput.println("exit");
            this.commandInput.close();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.commandErrorOutput != null) {
            try {
                this.commandErrorOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.commandOutput != null) {
            try {
                this.commandOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String executeCommands(String ... commands) throws PowerShellExecutionException, IOException {
        if (this.closed) {
            throw new IllegalStateException("This PowerShell session has been closed.");
        }
        if (!this.psSession.isAlive()) {
            this.close();
            throw new IllegalStateException("The PowerShell process has terminated before it should.");
        }
        StringBuilder commandChainBuilder = new StringBuilder();
        for (String command : commands) {
            commandChainBuilder.append(command);
            commandChainBuilder.append(";");
        }
        String commandChain = commandChainBuilder.toString();
        String wrappedCommandChain = "try{Invoke-Expression " + PowerShell.escapePowerShellString(commandChain) + "}catch{Write-Error $_};" + PowerShell.escapePowerShellString(END_OF_COMMAND);
        this.commandInput.println(wrappedCommandChain);
        try {
            Optional<String> optionalOutput = this.outputRecorder.consumeToNextDelimiter(END_OF_COMMAND + System.lineSeparator());
            if (!optionalOutput.isPresent()) {
                this.close();
                throw new IllegalStateException("PowerShell output stream ended too early.");
            }
            String output = optionalOutput.get().replace(END_OF_COMMAND + System.lineSeparator(), "");
            String errorOutput = this.errorOutputRecorder.consumeAllAfterCurrentInput();
            if (!errorOutput.isEmpty()) {
                throw new PowerShellExecutionException("Error while executing PowerShell commands:" + System.lineSeparator() + errorOutput);
            }
            return output;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }

    public static String escapePowerShellString(String s) {
        return "'" + s.replace("'", "''") + "'";
    }
}

