/*
 * Decompiled with CFR 0.152.
 */
package com.globo.globodns.client;

import com.globo.globodns.client.GloboDns;
import com.globo.globodns.client.GloboDnsException;
import com.globo.globodns.client.exception.GloboDnsHttpException;
import com.globo.globodns.client.exception.GloboDnsIOException;
import com.globo.globodns.client.exception.GloboDnsParseException;
import com.globo.globodns.client.http.HttpUtil;
import com.globo.globodns.client.http.ResponseWrapper;
import com.globo.globodns.client.model.ErrorMessage;
import com.globo.globodns.client.model.GloboDnsRoot;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAPI<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractAPI.class);
    static final JsonFactory JSON_FACTORY = new JacksonFactory();
    static final JsonObjectParser parser = new JsonObjectParser(JSON_FACTORY);
    private final GloboDns globoDns;
    private HttpRequestFactory requestFactory;

    protected AbstractAPI(GloboDns globoDns) {
        if (globoDns == null) {
            throw new IllegalArgumentException("No GloboDNS configured");
        }
        this.globoDns = globoDns;
        this.requestFactory = this.buildHttpRequestFactory();
    }

    protected GloboDns getGloboDns() {
        return this.globoDns;
    }

    protected abstract Type getType();

    protected abstract Type getListType();

    protected HttpRequestFactory buildHttpRequestFactory() {
        HttpRequestFactory request = this.getGloboDns().getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.setNumberOfRetries(AbstractAPI.this.globoDns.getNumberOfRetries());
                request.setConnectTimeout(AbstractAPI.this.globoDns.getConnectionTimeout());
                request.setReadTimeout(AbstractAPI.this.globoDns.getReadTimeout());
                request.setThrowExceptionOnExecuteError(false);
                request.setParser((ObjectParser)parser);
                request.setLoggingEnabled(true);
                request.getHeaders().setUserAgent("GloboDNS-Client");
                request.setCurlLoggingEnabled(true);
                request.setUnsuccessfulResponseHandler(new HttpUnsuccessfulResponseHandler(){

                    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                        if (response.getStatusCode() == 401) {
                            AbstractAPI.this.getGloboDns().clearToken();
                            if (supportsRetry) {
                                AbstractAPI.this.insertAuthenticationHeaders(request);
                                return true;
                            }
                        }
                        return false;
                    }
                });
                request.setResponseInterceptor(new HttpResponseInterceptor(){

                    public void interceptResponse(HttpResponse response) throws IOException {
                        AbstractAPI.this.interceptResponse(response);
                    }
                });
                AbstractAPI.this.interceptRequest(request);
            }
        });
        return request;
    }

    protected void interceptRequest(HttpRequest request) {
        this.insertAuthenticationHeaders(request);
    }

    protected void insertAuthenticationHeaders(HttpRequest request) {
        request.getHeaders().set("X-Auth-Token", (Object)this.getGloboDns().requestToken());
    }

    protected void interceptResponse(HttpResponse response) throws GloboDnsException, IOException {
        this.handleExceptionIfNeeded(response);
    }

    protected void handleExceptionIfNeeded(HttpResponse response) throws GloboDnsException, IOException {
        int statusCode = response.getStatusCode();
        if (statusCode / 100 == 2) {
            return;
        }
        if (statusCode / 100 == 4 || statusCode / 100 == 5) {
            String responseAsString = response.parseAsString();
            if (responseAsString == null || !responseAsString.startsWith("{")) {
                throw new GloboDnsHttpException("Unknown error in GloboDNS: " + responseAsString, statusCode);
            }
            GloboDnsRoot responseObj = this.parse(responseAsString, (Type)((Object)ErrorMessage.class));
            ErrorMessage errorMsg = (ErrorMessage)responseObj.getFirstObject();
            if (errorMsg != null && errorMsg.getMsg() != null) {
                throw new GloboDnsHttpException(errorMsg.getMsg(), statusCode);
            }
            throw new GloboDnsHttpException(responseAsString, statusCode);
        }
        throw new GloboDnsHttpException(response.parseAsString(), statusCode);
    }

    protected <E> GloboDnsRoot<E> parse(String responseAsString, Type type) throws GloboDnsException {
        try {
            GloboDnsRoot globoDnsRoot = new GloboDnsRoot();
            if ("".equalsIgnoreCase(responseAsString)) {
                return globoDnsRoot;
            }
            boolean isList = false;
            if (responseAsString.startsWith("[") && responseAsString.endsWith("]")) {
                isList = true;
            }
            StringReader in = new StringReader(responseAsString);
            if (isList) {
                List retList = (List)parser.parseAndClose((Reader)in, type);
                globoDnsRoot.setObjectList(retList);
            } else {
                Object retObj = parser.parseAndClose((Reader)in, type);
                globoDnsRoot.getObjectList().add(retObj);
            }
            return globoDnsRoot;
        }
        catch (IOException e) {
            throw new GloboDnsParseException("IOError Parse: " + e.getMessage(), e);
        }
    }

    protected <E> GloboDnsRoot<E> parse(HttpResponse response, Type type) throws GloboDnsException {
        try {
            return this.parse(response.parseAsString(), type);
        }
        catch (IOException e) {
            throw new GloboDnsParseException("IOError: " + e.getMessage(), e);
        }
    }

    protected GenericUrl buildUrl(String suffixUrl) {
        return new GenericUrl(this.globoDns.getBaseUrl() + suffixUrl);
    }

    protected GloboDnsRoot<T> get(String suffixUrl, boolean returnsList) throws GloboDnsException {
        ResponseWrapper response = this.performRequest(this.buildUrl(suffixUrl), "GET", null);
        Type type = returnsList ? this.getListType() : this.getType();
        return this.parse(response.getContent(), type);
    }

    protected GloboDnsRoot<T> post(String suffixUrl, Object payload, boolean returnsList) throws GloboDnsException {
        ResponseWrapper response = this.performRequest(this.buildUrl(suffixUrl), "POST", payload);
        Type type = returnsList ? this.getListType() : this.getType();
        return this.parse(response.getContent(), type);
    }

    protected GloboDnsRoot<T> put(String suffixUrl, Object payload, boolean returnsList) throws GloboDnsException {
        ResponseWrapper response = this.performRequest(this.buildUrl(suffixUrl), "PUT", payload);
        Type type = returnsList ? this.getListType() : this.getType();
        return this.parse(response.getContent(), type);
    }

    protected GloboDnsRoot<T> delete(String suffixUrl, boolean returnsList) throws GloboDnsException {
        ResponseWrapper response = this.performRequest(this.buildUrl(suffixUrl), "DELETE", null);
        Type type = returnsList ? this.getListType() : this.getType();
        return this.parse(response.getContent(), type);
    }

    protected ResponseWrapper performRequest(GenericUrl url, String method, Object payload) throws GloboDnsException {
        Long startTime = new Date().getTime();
        try {
            HttpRequest request = this.buildRequest(method, url, payload);
            HttpUtil.loggingRequest(request);
            HttpResponse response = request.execute();
            ResponseWrapper helper = new ResponseWrapper(response);
            HttpUtil.loggingResponse(startTime, request, helper);
            return helper;
        }
        catch (IOException e) {
            LOGGER.error("IOException trying request: " + url.toString() + " method: " + method + " error: " + e.toString(), (Throwable)e);
            throw new GloboDnsIOException("IOException: " + e.getMessage(), e);
        }
    }

    protected HttpRequest buildRequest(String method, GenericUrl url, Object payload) throws IOException {
        JsonHttpContent content = null;
        if (payload != null) {
            content = new JsonHttpContent((JsonFactory)new JacksonFactory(), payload);
        }
        HttpRequest request = this.requestFactory.buildRequest(method, url, content);
        request.setLoggingEnabled(true);
        return request;
    }
}

