/*
 * Decompiled with CFR 0.152.
 */
package com.globo.globodns.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.globo.globodns.client.AbstractAPI;
import com.globo.globodns.client.GloboDns;
import com.globo.globodns.client.GloboDnsException;
import com.globo.globodns.client.model.GloboDnsRoot;
import com.globo.globodns.client.model.Record;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.Trace;
import java.lang.reflect.Type;
import java.util.List;

public class RecordAPI
extends AbstractAPI<Record> {
    public RecordAPI(GloboDns transport) {
        super(transport);
    }

    @Override
    protected Type getType() {
        return new TypeReference<Record>(){}.getType();
    }

    @Override
    protected Type getListType() {
        return new TypeReference<List<Record>>(){}.getType();
    }

    @Trace(dispatcher=true)
    public Record createRecord(Long domainId, String name, String content, String type) throws GloboDnsException {
        NewRelic.setTransactionName(null, (String)"/globodns/createRecord");
        if (domainId == null) {
            throw new GloboDnsException("Domain id cannot be null");
        }
        Record record = new Record();
        record.getGenericRecordAttributes().setDomainId(domainId);
        record.getGenericRecordAttributes().setName(name);
        record.getGenericRecordAttributes().setContent(content);
        record.getGenericRecordAttributes().setType(type.toUpperCase());
        GloboDnsRoot globoDnsRoot = this.post("/domains/" + domainId + "/records.json", record, false);
        if (globoDnsRoot == null) {
            throw new GloboDnsException("Invalid response");
        }
        return (Record)globoDnsRoot.getFirstObject();
    }

    @Trace(dispatcher=true)
    public List<Record> listAll(Long domainId) throws GloboDnsException {
        NewRelic.setTransactionName(null, (String)"/globodns/listRecords");
        if (domainId == null) {
            throw new GloboDnsException("Domain id cannot be null");
        }
        GloboDnsRoot globoDnsRoot = this.get("/domains/" + domainId + "/records.json", true);
        if (globoDnsRoot == null) {
            throw new GloboDnsException("Invalid response");
        }
        return globoDnsRoot.getObjectList();
    }

    @Trace(dispatcher=true)
    public List<Record> listByQuery(Long domainId, String query) throws GloboDnsException {
        NewRelic.setTransactionName(null, (String)"/globodns/listRecordsByQuery");
        if (domainId == null) {
            throw new GloboDnsException("Domain id cannot be null");
        }
        if (query == null) {
            throw new GloboDnsException("Query cannot be null");
        }
        GloboDnsRoot globoDnsRoot = this.get("/domains/" + domainId + "/records.json?query=" + query, true);
        if (globoDnsRoot == null) {
            throw new GloboDnsException("Invalid response");
        }
        return globoDnsRoot.getObjectList();
    }

    @Trace(dispatcher=true)
    public Record getById(Long recordId) throws GloboDnsException {
        NewRelic.setTransactionName(null, (String)"/globodns/getRecordById");
        if (recordId == null) {
            throw new GloboDnsException("Record id cannot be null");
        }
        GloboDnsRoot globoDnsRoot = this.get("/records/" + recordId + ".json", false);
        if (globoDnsRoot == null) {
            throw new GloboDnsException("Invalid response");
        }
        return (Record)globoDnsRoot.getFirstObject();
    }

    @Trace(dispatcher=true)
    public void updateRecord(Long recordId, Long domainId, String name, String content) throws GloboDnsException {
        GloboDnsRoot globoDnsRoot;
        NewRelic.setTransactionName(null, (String)"/globodns/updateRecord");
        if (recordId == null) {
            throw new GloboDnsException("Record id cannot be null");
        }
        Record record = new Record();
        if (domainId != null) {
            record.getGenericRecordAttributes().setDomainId(domainId);
        }
        if (name != null) {
            record.getGenericRecordAttributes().setName(name);
        }
        if (content != null) {
            record.getGenericRecordAttributes().setContent(content);
        }
        if ((globoDnsRoot = this.put("/records/" + recordId + ".json", record, false)) == null) {
            throw new GloboDnsException("Invalid response");
        }
    }

    @Trace(dispatcher=true)
    public void removeRecord(Long recordId) throws GloboDnsException {
        NewRelic.setTransactionName(null, (String)"/globodns/removeRecord");
        if (recordId == null) {
            throw new GloboDnsException("Record id cannot be null");
        }
        GloboDnsRoot globoDnsRoot = this.delete("/records/" + recordId + ".json", false);
        if (globoDnsRoot == null) {
            throw new GloboDnsException("Invalid response");
        }
    }
}

