/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.ImmutableDoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseDoubleIterable;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleEmptyList
implements ImmutableDoubleList,
Serializable {
    static final ImmutableDoubleList INSTANCE = new ImmutableDoubleEmptyList();
    private static final long serialVersionUID = 1L;

    ImmutableDoubleEmptyList() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public double get(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    public double getFirst() {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public double getLast() {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public int indexOf(double value) {
        return -1;
    }

    public int lastIndexOf(double value) {
        return -1;
    }

    public DoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public void forEach(DoubleProcedure procedure) {
    }

    public void forEachWithIndex(DoubleIntProcedure procedure) {
    }

    public int count(DoublePredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    public ImmutableDoubleList select(DoublePredicate predicate) {
        return this;
    }

    public ImmutableDoubleList reject(DoublePredicate predicate) {
        return this;
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    public <V> ImmutableList<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Lists.immutable.of();
    }

    public double sum() {
        return 0.0;
    }

    public double max() {
        throw new NoSuchElementException();
    }

    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double min() {
        throw new NoSuchElementException();
    }

    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public double[] toSortedArray() {
        return new double[0];
    }

    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    public double dotProduct(DoubleList list) {
        if (!list.isEmpty()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return 0.0;
    }

    public double[] toArray() {
        return new double[0];
    }

    public boolean contains(double value) {
        return false;
    }

    public boolean containsAll(double ... source) {
        return source.length == 0;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    public LazyDoubleIterable asReversed() {
        return ReverseDoubleIterable.adapt((DoubleList)this);
    }

    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableDoubleList toImmutable() {
        return this;
    }

    public ImmutableDoubleEmptyList toReversed() {
        return this;
    }

    public ImmutableDoubleList newWith(double element) {
        return DoubleLists.immutable.with(element);
    }

    public ImmutableDoubleList newWithout(double element) {
        return this;
    }

    public ImmutableDoubleList newWithAll(DoubleIterable elements) {
        return DoubleLists.immutable.withAll(elements);
    }

    public ImmutableDoubleList newWithoutAll(DoubleIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof DoubleList)) {
            return false;
        }
        DoubleList list = (DoubleList)otherList;
        return list.isEmpty();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableDoubleList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    private static class InternalDoubleIterator
    implements DoubleIterator {
        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public double next() {
            throw new NoSuchElementException();
        }
    }
}

