/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.CharBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.CharByteProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.CharByteMap;
import com.gs.collections.api.map.primitive.ImmutableCharByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.CharBytePair;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharByteMaps;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.map.mutable.primitive.CharByteHashMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharByteSingletonMap
implements ImmutableCharByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;
    private final char key1;
    private final byte value1;

    ImmutableCharByteSingletonMap(char key1, byte value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public byte get(char key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getIfAbsent(char key, byte ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public byte getOrThrow(char key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        return this.key1 == key;
    }

    public boolean containsValue(byte value) {
        return this.value1 == value;
    }

    public void forEachValue(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(CharProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(CharByteProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyCharIterable keysView() {
        return CharLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<CharBytePair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableCharByteMap select(CharBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? CharByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new CharByteHashMap().toImmutable();
    }

    public ImmutableCharByteMap reject(CharBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new CharByteHashMap().toImmutable() : CharByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableCharByteMap toImmutable() {
        return this;
    }

    public ByteIterator byteIterator() {
        return CharByteHashMap.newWithKeysValues(this.key1, this.value1).byteIterator();
    }

    public void forEach(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(BytePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public byte min() {
        return this.value1;
    }

    public byte max() {
        return this.value1;
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public byte[] toSortedArray() {
        return new byte[]{this.value1};
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableByteCollection select(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteArrayList.newListWith(this.value1).toImmutable() : new ByteArrayList().toImmutable();
    }

    public ImmutableByteCollection reject(BytePredicate predicate) {
        return predicate.accept(this.value1) ? new ByteArrayList().toImmutable() : ByteArrayList.newListWith(this.value1).toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public byte[] toArray() {
        return new byte[]{this.value1};
    }

    public boolean contains(byte value) {
        return this.value1 == value;
    }

    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.value1);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.value1);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableCharByteMap newWithKeyValue(char key, byte value) {
        return CharByteMaps.immutable.withAll((CharByteMap)CharByteHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableCharByteMap newWithoutKey(char key) {
        return this.key1 == key ? CharByteMaps.immutable.with() : this;
    }

    public ImmutableCharByteMap newWithoutAllKeys(CharIterable keys) {
        return keys.contains(this.key1) ? CharByteMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(CharHashSet.newSetWith(this.key1));
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of((MutableByteCollection)ByteArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharByteMap)) {
            return false;
        }
        CharByteMap map = (CharByteMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

