/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.LongFloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.LongFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ImmutableLongFloatMap;
import com.gs.collections.api.map.primitive.LongFloatMap;
import com.gs.collections.api.map.primitive.MutableLongFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.LongFloatPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedLongFloatProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.map.mutable.primitive.LongFloatHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableLongFloatHashMap
implements ImmutableLongFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongFloatMap delegate;

    ImmutableLongFloatHashMap(LongFloatMap delegate) {
        this.delegate = new LongFloatHashMap(delegate);
    }

    public float get(long key) {
        return this.delegate.get(key);
    }

    public float getIfAbsent(long key, float ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(long key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(float value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongFloatProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<LongFloatPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableLongFloatMap select(LongFloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongFloatMap reject(LongFloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return ((LongFloatHashMap)this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableLongFloatMap toImmutable() {
        return this;
    }

    public FloatIterator floatIterator() {
        return this.delegate.floatIterator();
    }

    public void forEach(FloatProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum() {
        return this.delegate.sum();
    }

    public float max() {
        return this.delegate.max();
    }

    public float maxIfEmpty(float defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public float min() {
        return this.delegate.min();
    }

    public float minIfEmpty(float defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public float[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableFloatList toSortedList() {
        return this.delegate.toSortedList();
    }

    public float[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(float value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableFloatList toList() {
        return this.delegate.toList();
    }

    public MutableFloatSet toSet() {
        return this.delegate.toSet();
    }

    public MutableFloatBag toBag() {
        return this.delegate.toBag();
    }

    public LazyFloatIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableLongFloatMap newWithKeyValue(long key, float value) {
        LongFloatHashMap map = new LongFloatHashMap(this.size() + 1);
        map.putAll((LongFloatMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongFloatMap newWithoutKey(long key) {
        LongFloatHashMap map = new LongFloatHashMap(this.size());
        map.putAll((LongFloatMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongFloatMap newWithoutAllKeys(LongIterable keys) {
        LongFloatHashMap map = new LongFloatHashMap(this.size());
        map.putAll((LongFloatMap)this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableLongFloatMapSerializationProxy((LongFloatMap)this);
    }

    protected static class ImmutableLongFloatMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongFloatMap map;

        public ImmutableLongFloatMapSerializationProxy() {
        }

        protected ImmutableLongFloatMapSerializationProxy(LongFloatMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((LongFloatProcedure)new CheckedLongFloatProcedure(){

                    public void safeValue(long key, float value) throws IOException {
                        out.writeLong(key);
                        out.writeFloat(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongFloatHashMap deserializedMap = new LongFloatHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readLong(), in.readFloat());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

