/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.CharToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.CharDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.CharDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableCharDoubleMap;
import com.gs.collections.api.map.primitive.MutableCharDoubleMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.CharDoublePair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.primitive.CharDoubleMaps;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedCharDoubleMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableCharDoubleMap
implements MutableCharDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharDoubleMap map;

    UnmodifiableCharDoubleMap(MutableCharDoubleMap map) {
        this.map = map;
    }

    private boolean isAbsent(double result, char key) {
        return result == 0.0 && !this.containsKey(key);
    }

    private double getIfAbsentThrow(char key) {
        double result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(char key, double value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(CharDoubleMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(char key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(char key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public double removeKeyIfAbsent(char key, double value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public double getIfAbsentPut(char key, double value) {
        return this.getIfAbsentThrow(key);
    }

    public double getIfAbsentPut(char key, DoubleFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public double getIfAbsentPutWithKey(char key, CharToDoubleFunction function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> double getIfAbsentPutWith(char key, DoubleFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public double updateValue(char key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public double get(char key) {
        return this.map.get(key);
    }

    public double getIfAbsent(char key, double ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public double getOrThrow(char key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(char key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(double value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(CharDoubleProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<CharDoublePair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableCharDoubleMap select(CharDoublePredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableCharDoubleMap reject(CharDoublePredicate predicate) {
        return this.map.reject(predicate);
    }

    public DoubleIterator doubleIterator() {
        return this.map.doubleIterator();
    }

    public void forEach(DoubleProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(DoublePredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableDoubleCollection select(DoublePredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableDoubleCollection reject(DoublePredicate predicate) {
        return this.map.reject(predicate);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public double sum() {
        return this.map.sum();
    }

    public double max() {
        return this.map.max();
    }

    public double maxIfEmpty(double defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public double min() {
        return this.map.min();
    }

    public double minIfEmpty(double defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public double addToValue(char key, double toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public double[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableDoubleList toSortedList() {
        return this.map.toSortedList();
    }

    public double[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(double value) {
        return this.map.contains(value);
    }

    public boolean containsAll(double ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.map.containsAll(source);
    }

    public MutableDoubleList toList() {
        return this.map.toList();
    }

    public MutableDoubleSet toSet() {
        return this.map.toSet();
    }

    public MutableDoubleBag toBag() {
        return this.map.toBag();
    }

    public LazyDoubleIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableCharDoubleMap withKeyValue(char key, double value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableCharDoubleMap withoutKey(char key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableCharDoubleMap withoutAllKeys(CharIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableCharDoubleMap asUnmodifiable() {
        return this;
    }

    public MutableCharDoubleMap asSynchronized() {
        return new SynchronizedCharDoubleMap(this);
    }

    public ImmutableCharDoubleMap toImmutable() {
        return CharDoubleMaps.immutable.withAll((CharDoubleMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(this.map.keySet());
    }

    public MutableDoubleCollection values() {
        return UnmodifiableDoubleCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

