/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.internal;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.impl.factory.Lists;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutableCollectionIterate {
    private MutableCollectionIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> RichIterable<RichIterable<T>> chunk(MutableCollection<T> collection, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        Iterator iterator = collection.iterator();
        MutableList result = Lists.mutable.of();
        while (iterator.hasNext()) {
            MutableCollection batch = collection.newEmpty();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add((Object)batch);
        }
        return result;
    }
}

