/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.ImmutableLongBag;
import com.gs.collections.api.factory.bag.primitive.ImmutableLongBagFactory;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableLongEmptyBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableLongHashBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableLongSingletonBag;

public class ImmutableLongBagFactoryImpl
implements ImmutableLongBagFactory {
    public ImmutableLongBag empty() {
        return ImmutableLongEmptyBag.INSTANCE;
    }

    public ImmutableLongBag of() {
        return this.empty();
    }

    public ImmutableLongBag with() {
        return this.empty();
    }

    public ImmutableLongBag of(long one) {
        return this.with(one);
    }

    public ImmutableLongBag with(long one) {
        return new ImmutableLongSingletonBag(one);
    }

    public ImmutableLongBag of(long ... items) {
        return this.with(items);
    }

    public ImmutableLongBag with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableLongHashBag.newBagWith(items);
    }

    public ImmutableLongBag ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public ImmutableLongBag withAll(LongIterable items) {
        if (items instanceof ImmutableLongBag) {
            return (ImmutableLongBag)items;
        }
        return this.with(items.toArray());
    }
}

