/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.ImmutableShortBag;
import com.gs.collections.api.factory.bag.primitive.ImmutableShortBagFactory;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableShortEmptyBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableShortHashBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableShortSingletonBag;

public class ImmutableShortBagFactoryImpl
implements ImmutableShortBagFactory {
    public ImmutableShortBag empty() {
        return ImmutableShortEmptyBag.INSTANCE;
    }

    public ImmutableShortBag of() {
        return this.empty();
    }

    public ImmutableShortBag with() {
        return this.empty();
    }

    public ImmutableShortBag of(short one) {
        return this.with(one);
    }

    public ImmutableShortBag with(short one) {
        return new ImmutableShortSingletonBag(one);
    }

    public ImmutableShortBag of(short ... items) {
        return this.with(items);
    }

    public ImmutableShortBag with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableShortHashBag.newBagWith(items);
    }

    public ImmutableShortBag ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public ImmutableShortBag withAll(ShortIterable items) {
        if (items instanceof ImmutableShortBag) {
            return (ImmutableShortBag)items;
        }
        return this.with(items.toArray());
    }
}

