/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.sorted.MutableSortedBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.ByteObjectPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ByteObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.ByteObjectMap;
import com.gs.collections.api.map.primitive.ImmutableByteObjectMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.PartitionIterable;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.primitive.ByteObjectPair;
import com.gs.collections.impl.UnmodifiableIteratorAdapter;
import com.gs.collections.impl.bag.sorted.mutable.TreeBag;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.PartitionPredicate2Procedure;
import com.gs.collections.impl.block.procedure.PartitionProcedure;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.SortedMaps;
import com.gs.collections.impl.factory.SortedSets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.LazyIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.immutable.primitive.AbstractImmutableByteObjectMap;
import com.gs.collections.impl.map.immutable.primitive.ImmutableByteObjectEmptyMap;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import com.gs.collections.impl.tuple.Tuples;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.internal.IterableIterate;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableByteObjectSingletonMap<V>
extends AbstractImmutableByteObjectMap<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte key1;
    private final V value1;

    ImmutableByteObjectSingletonMap(byte key1, V value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public V get(byte key) {
        return this.key1 == key ? (V)this.value1 : null;
    }

    public V getIfAbsent(byte key, Function0<? extends V> ifAbsent) {
        return (V)(this.key1 == key ? this.value1 : ifAbsent.value());
    }

    public boolean containsKey(byte key) {
        return this.key1 == key;
    }

    public boolean containsValue(Object value) {
        return ImmutableByteObjectSingletonMap.nullSafeEquals(this.value1, value);
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public ImmutableByteObjectMap<V> tap(Procedure<? super V> procedure) {
        procedure.value(this.value1);
        return this;
    }

    public void forEachValue(Procedure<? super V> procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ByteProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ByteObjectProcedure<? super V> procedure) {
        procedure.value(this.key1, this.value1);
    }

    public ImmutableByteObjectMap<V> select(ByteObjectPredicate<? super V> predicate) {
        return predicate.accept(this.key1, this.value1) ? ByteObjectHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableByteObjectEmptyMap.INSTANCE;
    }

    public ImmutableByteObjectMap<V> reject(ByteObjectPredicate<? super V> predicate) {
        return predicate.accept(this.key1, this.value1) ? ImmutableByteObjectEmptyMap.INSTANCE : ByteObjectHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableByteObjectMap<V> toImmutable() {
        return this;
    }

    public int size() {
        return 1;
    }

    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(ByteHashSet.newSetWith(this.key1));
    }

    public Collection<V> values() {
        return Lists.immutable.of(this.value1).castToList();
    }

    public LazyByteIterable keysView() {
        return ByteLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ByteObjectPair<V>> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteObjectMap)) {
            return false;
        }
        ByteObjectMap map = (ByteObjectMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && ImmutableByteObjectSingletonMap.nullSafeEquals(this.value1, map.get(this.key1));
    }

    public int hashCode() {
        return this.key1 ^ (this.value1 == null ? 0 : this.value1.hashCode());
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public V getFirst() {
        return this.value1;
    }

    public V getLast() {
        return this.value1;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        Iterator<?> iterator = source.iterator();
        while (iterator.hasNext()) {
            if (ImmutableByteObjectSingletonMap.nullSafeEquals(this.value1, iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<?> source) {
        return this.containsAllIterable(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        for (Object item : elements) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public ImmutableCollection<V> select(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? Lists.immutable.with(this.value1) : Lists.immutable.with();
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        if (predicate.accept(this.value1)) {
            target.add(this.value1);
        }
        return target;
    }

    public <P> ImmutableCollection<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter) ? Lists.immutable.with(this.value1) : Lists.immutable.with();
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (predicate.accept(this.value1, parameter)) {
            targetCollection.add(this.value1);
        }
        return targetCollection;
    }

    public ImmutableCollection<V> reject(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? Lists.immutable.with() : Lists.immutable.with(this.value1);
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        if (!predicate.accept(this.value1)) {
            target.add(this.value1);
        }
        return target;
    }

    public <P> ImmutableCollection<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter) ? Lists.immutable.with() : Lists.immutable.with(this.value1);
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (!predicate.accept(this.value1, parameter)) {
            targetCollection.add(this.value1);
        }
        return targetCollection;
    }

    public PartitionIterable<V> partition(Predicate<? super V> predicate) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableList));
        return partitionMutableList;
    }

    public <P> PartitionIterable<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionPredicate2Procedure<V, P>(predicate, parameter, partitionMutableList));
        return partitionMutableList;
    }

    public <S> RichIterable<S> selectInstancesOf(Class<S> clazz) {
        return clazz.isInstance(this.value1) ? Lists.immutable.with(clazz.cast(this.value1)) : Lists.immutable.with();
    }

    public <VV> ImmutableCollection<VV> collect(Function<? super V, ? extends VV> function) {
        return Lists.immutable.with(function.valueOf(this.value1));
    }

    public ImmutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return BooleanLists.immutable.with(booleanFunction.booleanValueOf(this.value1));
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        target.add(booleanFunction.booleanValueOf(this.value1));
        return target;
    }

    public ImmutableByteCollection collectByte(ByteFunction<? super V> byteFunction) {
        return ByteLists.immutable.with(byteFunction.byteValueOf(this.value1));
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        target.add(byteFunction.byteValueOf(this.value1));
        return target;
    }

    public ImmutableCharCollection collectChar(CharFunction<? super V> charFunction) {
        return CharLists.immutable.with(charFunction.charValueOf(this.value1));
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        target.add(charFunction.charValueOf(this.value1));
        return target;
    }

    public ImmutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction) {
        return DoubleLists.immutable.with(doubleFunction.doubleValueOf(this.value1));
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        target.add(doubleFunction.doubleValueOf(this.value1));
        return target;
    }

    public ImmutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction) {
        return FloatLists.immutable.with(floatFunction.floatValueOf(this.value1));
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        target.add(floatFunction.floatValueOf(this.value1));
        return target;
    }

    public ImmutableIntCollection collectInt(IntFunction<? super V> intFunction) {
        return IntLists.immutable.with(intFunction.intValueOf(this.value1));
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        target.add(intFunction.intValueOf(this.value1));
        return target;
    }

    public ImmutableLongCollection collectLong(LongFunction<? super V> longFunction) {
        return LongLists.immutable.with(longFunction.longValueOf(this.value1));
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        target.add(longFunction.longValueOf(this.value1));
        return target;
    }

    public ImmutableShortCollection collectShort(ShortFunction<? super V> shortFunction) {
        return ShortLists.immutable.with(shortFunction.shortValueOf(this.value1));
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        target.add(shortFunction.shortValueOf(this.value1));
        return target;
    }

    public <VV> RichIterable<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return predicate.accept(this.value1) ? Lists.immutable.with(function.valueOf(this.value1)) : Lists.immutable.with();
    }

    public <VV> RichIterable<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return Lists.immutable.withAll((Iterable)function.valueOf(this.value1));
    }

    public V detect(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? (V)this.value1 : null;
    }

    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter) ? (V)this.value1 : null;
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return (V)(predicate.accept(this.value1) ? this.value1 : function.value());
    }

    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        return (V)(predicate.accept(this.value1, parameter) ? this.value1 : function.value());
    }

    public int count(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter) ? 1 : 0;
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return predicate.accept(this.value1);
    }

    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter);
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return predicate.accept(this.value1);
    }

    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return predicate.accept(this.value1, parameter);
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return !predicate.accept(this.value1);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return !predicate.accept(this.value1, parameter);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return (IV)function.value(injectedValue, this.value1);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return function.intValueOf(injectedValue, this.value1);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return function.longValueOf(injectedValue, this.value1);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return function.floatValueOf(injectedValue, this.value1);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return function.doubleValueOf(injectedValue, this.value1);
    }

    public MutableList<V> toList() {
        return Lists.mutable.with(new Object[]{this.value1});
    }

    public MutableList<V> toSortedList() {
        return Lists.mutable.with(new Object[]{this.value1});
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return Lists.mutable.with(new Object[]{this.value1});
    }

    public MutableSet<V> toSet() {
        return Sets.mutable.with(new Object[]{this.value1});
    }

    public MutableSortedSet<V> toSortedSet() {
        return SortedSets.mutable.with(new Object[]{this.value1});
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return SortedSets.mutable.with(new Object[]{this.value1});
    }

    public MutableBag<V> toBag() {
        return Bags.mutable.with(new Object[]{this.value1});
    }

    public MutableSortedBag<V> toSortedBag() {
        return TreeBag.newBagWith(this.value1);
    }

    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        return TreeBag.newBagWith(comparator, this.value1);
    }

    public <VV extends Comparable<? super VV>> MutableSortedBag<V> toSortedBagBy(Function<? super V, ? extends VV> function) {
        return TreeBag.newBagWith(Comparators.byFunction(function), new Object[]{this.value1});
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return Maps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return SortedMaps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return SortedMaps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public LazyIterable<V> asLazy() {
        return new LazyIterableAdapter<Object>((Iterable<Object>)((Object)FastList.newListWith(this.value1)));
    }

    public Object[] toArray() {
        return new Object[]{this.value1};
    }

    public <T> T[] toArray(T[] a) {
        return new Object[]{this.value1};
    }

    public V min(Comparator<? super V> comparator) {
        return this.value1;
    }

    public V max(Comparator<? super V> comparator) {
        return this.value1;
    }

    public V min() {
        return this.value1;
    }

    public V max() {
        return this.value1;
    }

    public long sumOfInt(IntFunction<? super V> function) {
        return function.intValueOf(this.value1);
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        return function.floatValueOf(this.value1);
    }

    public long sumOfLong(LongFunction<? super V> function) {
        return function.longValueOf(this.value1);
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        return function.doubleValueOf(this.value1);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <VV> Multimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return new FastListMultimap(Tuples.pair(function.valueOf(this.value1), this.value1));
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        target.put(function.valueOf(this.value1), this.value1);
        return target;
    }

    public <VV> Multimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap());
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        Iterable iterable = (Iterable)function.valueOf(this.value1);
        for (Object key : iterable) {
            target.put(key, this.value1);
        }
        return target;
    }

    public <VV> MapIterable<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return new UnifiedMap(Tuples.pair(function.valueOf(this.value1), this.value1));
    }

    public <VV, R extends MutableMap<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        if (target.put(function.valueOf(this.value1), this.value1) != null) {
            throw new IllegalStateException("Key " + function.valueOf(this.value1) + " already exists in map!");
        }
        return target;
    }

    public <S> RichIterable<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, (Collection)((Object)FastList.newList()));
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    public RichIterable<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex((Collection)((Object)FastList.newList()));
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return IterableIterate.zipWithIndex(this, target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.of();
        result.add(FastList.newListWith(this.value1));
        return result;
    }

    public <K, VV> MapIterable<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<V, K, VV>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <K, VV> MapIterable<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<V, K, VV>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        return this.value1;
    }

    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        return this.value1;
    }

    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        return SortedSets.mutable.with(new Object[]{this.value1});
    }

    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return Lists.mutable.of(new Object[]{this.value1});
    }

    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        Iterate.addAllTo((Iterable)function.valueOf(this.value1), target);
        return target;
    }

    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        if (predicate.accept(this.value1)) {
            target.add((Object)function.valueOf(this.value1));
        }
        return target;
    }

    public <P, VV> ImmutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return Lists.immutable.with(function.value(this.value1, parameter));
    }

    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        targetCollection.add((Object)function.value(this.value1, parameter));
        return targetCollection;
    }

    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        target.add((Object)function.valueOf(this.value1));
        return target;
    }

    public ImmutableByteObjectMap<V> newWithKeyValue(byte key, V value) {
        return ByteObjectHashMap.newWithKeysValues(this.key1, this.value1, key, value).toImmutable();
    }

    public ImmutableByteObjectMap<V> newWithoutKey(byte key) {
        return this.key1 == key ? ImmutableByteObjectEmptyMap.INSTANCE : this;
    }

    public ImmutableByteObjectMap<V> newWithoutAllKeys(ByteIterable keys) {
        return keys.contains(this.key1) ? ImmutableByteObjectEmptyMap.INSTANCE : this;
    }

    public void forEach(Procedure<? super V> procedure) {
        this.each(procedure);
    }

    public void each(Procedure<? super V> procedure) {
        procedure.value(this.value1);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        objectIntProcedure.value(this.value1, 0);
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        procedure.value(this.value1, parameter);
    }

    public Iterator<V> iterator() {
        return new UnmodifiableIteratorAdapter<V>(ByteObjectHashMap.newWithKeysValues(this.key1, this.value1).iterator());
    }

    private Object writeReplace() {
        return new AbstractImmutableByteObjectMap.ImmutableByteObjectMapSerializationProxy(this);
    }
}

