// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.api.ads.common.lib.soap.axis.testing.mocks.v201511;

import org.apache.axis.client.Stub;

/**
 * Mock Stub that implements MockAxisServiceInterface. Mirrors the structure of SoapBindingStub
 * types generated by WSDL2Java.
 */
public class MockAxisServiceSoapBindingStub extends Stub implements MockAxisServiceInterface {

  /**
   * @param service ignored - here only for consistency with WSDL2Java-generated stubs
   */
  public MockAxisServiceSoapBindingStub(javax.xml.rpc.Service service) {
  }

  @Override
  public String getTestMessage() {
    return MockAxisServiceInterface.TEST_MESSAGE;
  }
  
  @Override
  public String getTestMessageWithPrefix(String prefix) {
    return prefix + MockAxisServiceInterface.TEST_MESSAGE;
  }
}
