/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.axis;

import com.google.api.ads.common.lib.client.RemoteCallReturn;
import com.google.api.ads.common.lib.client.RequestInfo;
import com.google.api.ads.common.lib.client.ResponseInfo;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.RequestInfoXPathSet;
import com.google.api.ads.common.lib.soap.ResponseInfoXPathSet;
import com.google.api.ads.common.lib.soap.SoapCall;
import com.google.api.ads.common.lib.soap.SoapClientHandler;
import com.google.api.ads.common.lib.soap.SoapServiceDescriptor;
import com.google.api.ads.common.lib.soap.compatability.AxisCompatible;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.beanutils.BeanUtils;

public class AxisHandler
extends SoapClientHandler<Stub> {
    private final EngineConfigurationFactory engineConfigurationFactory;
    private final RequestInfoXPathSet requestInfoXPathSet;
    private final ResponseInfoXPathSet responseInfoXPathSet;

    @Inject
    public AxisHandler(EngineConfigurationFactory engineConfigurationFactory, RequestInfoXPathSet requestInfoXPathSet, ResponseInfoXPathSet responseInfoXPathSet) {
        this.engineConfigurationFactory = engineConfigurationFactory;
        this.requestInfoXPathSet = requestInfoXPathSet;
        this.responseInfoXPathSet = responseInfoXPathSet;
    }

    public void setEndpointAddress(Stub soapClient, String endpointAddress) {
        soapClient._setProperty("javax.xml.rpc.service.endpoint.address", (Object)endpointAddress);
    }

    public void setRequestTimeout(Stub soapClient, int timeout) {
        soapClient.setTimeout(timeout);
    }

    public Object getHeader(Stub soapClient, String headerName) {
        SOAPHeaderElement[] soapHeaders;
        for (SOAPHeaderElement soapHeader : soapHeaders = soapClient.getHeaders()) {
            if (!soapHeader.getName().equals(headerName)) continue;
            return soapHeader;
        }
        return null;
    }

    public void clearHeaders(Stub soapClient) {
        soapClient._setProperty("HTTP-Request-Headers", new Hashtable());
        soapClient.clearHeaders();
    }

    public void setHeader(Stub soapClient, String namespace, String headerName, Object headerValue) {
        try {
            QName qName = new QName(namespace, headerName);
            SOAPHeaderElement soapHeaderElement = new SOAPHeaderElement(qName);
            soapHeaderElement.setObjectValue(headerValue);
            soapHeaderElement.setActor(null);
            soapClient.setHeader(soapHeaderElement);
        }
        catch (SOAPException e) {
            throw new ServiceException("Could not set header.", (Throwable)e);
        }
    }

    public void setHeaderChild(Stub soapClient, String parentHeaderName, String childName, Object childValue) {
        SOAPHeaderElement headerElement = (SOAPHeaderElement)this.getHeader(soapClient, parentHeaderName);
        Object headerObject = ((SOAPHeaderElement)Preconditions.checkNotNull((Object)headerElement, (String)"Parent header named %s does not exist", (Object)parentHeaderName)).getObjectValue();
        try {
            BeanUtils.setProperty((Object)headerObject, (String)childName, (Object)childValue);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Failed to set header child " + childName, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Failed to set header child " + childName, (Throwable)e);
        }
    }

    public void putAllHttpHeaders(Stub soapClient, Map<String, String> headersMap) {
        Hashtable<String, String> headers = (Hashtable<String, String>)soapClient._getProperty("HTTP-Request-Headers");
        if (headers == null) {
            headers = new Hashtable<String, String>();
        }
        headers.putAll(headersMap);
        soapClient._setProperty("HTTP-Request-Headers", headers);
    }

    public void setCompression(Stub soapClient, boolean compress) {
        soapClient._setProperty("transport.http.acceptGzip", (Object)compress);
        soapClient._setProperty("transport.http.gzipRequest", (Object)compress);
    }

    public Stub createSoapClient(SoapServiceDescriptor soapServiceDescriptor) throws ServiceException {
        try {
            if (soapServiceDescriptor instanceof AxisCompatible) {
                AxisCompatible axisCompatibleService = (AxisCompatible)soapServiceDescriptor;
                EngineConfiguration engineConfiguration = this.engineConfigurationFactory.getClientEngineConfig();
                Service locator = (Service)axisCompatibleService.getLocatorClass().getConstructor(EngineConfiguration.class).newInstance(engineConfiguration);
                return (Stub)locator.getClass().getMethod("getPort", Class.class).invoke((Object)locator, soapServiceDescriptor.getInterfaceClass());
            }
            throw new ServiceException("Service [" + soapServiceDescriptor + "] not compatible with Axis", null);
        }
        catch (SecurityException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected Exception.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCallReturn invokeSoapCall(SoapCall<Stub> soapCall) {
        Stub stub = (Stub)soapCall.getSoapClient();
        RemoteCallReturn.Builder builder = new RemoteCallReturn.Builder();
        Stub stub2 = stub;
        synchronized (stub2) {
            Object result = null;
            try {
                result = this.invoke(soapCall);
            }
            catch (InvocationTargetException e) {
                builder.withException(e.getTargetException());
            }
            catch (Exception e) {
                builder.withException((Throwable)e);
            }
            finally {
                MessageContext messageContext = stub._getCall().getMessageContext();
                RequestInfo.Builder requestInfoBuilder = new RequestInfo.Builder().withMethodName(stub._getCall().getOperationName().getLocalPart()).withServiceName(stub._getService().getServiceName().getLocalPart()).withUrl(stub._getCall().getTargetEndpointAddress());
                this.requestInfoXPathSet.parseMessage(requestInfoBuilder, (SOAPMessage)messageContext.getRequestMessage());
                builder.withRequestInfo(requestInfoBuilder.build());
                ResponseInfo.Builder responseInfoBuilder = new ResponseInfo.Builder();
                this.responseInfoXPathSet.parseMessage(responseInfoBuilder, (SOAPMessage)messageContext.getResponseMessage());
                builder.withResponseInfo(responseInfoBuilder.build());
            }
            return builder.withReturnValue(result).build();
        }
    }

    public String getEndpointAddress(Stub soapClient) {
        return (String)soapClient._getProperty("javax.xml.rpc.service.endpoint.address");
    }

    public javax.xml.soap.SOAPHeaderElement createSoapHeaderElement(QName qName) {
        return new SOAPHeaderElement(qName);
    }
}

