/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlFieldExtractor {
    private final Logger logger;
    private final Supplier<DocumentBuilder> documentBuilderSupplier;
    private final Supplier<XPath> xpathSupplier;

    @Inject
    public XmlFieldExtractor(@Named(value="soapXmlLogger") Logger soapXmlLogger, Supplier<DocumentBuilder> documentBuilderSupplier, Supplier<XPath> xpathSupplier) {
        this.documentBuilderSupplier = documentBuilderSupplier;
        this.xpathSupplier = xpathSupplier;
        this.logger = soapXmlLogger;
    }

    public Map<String, String> extract(InputStream xml, String[] fields) {
        HashMap parsedFields = Maps.newHashMap();
        try {
            Document doc = ((DocumentBuilder)this.documentBuilderSupplier.get()).parse(xml);
            for (String field : fields) {
                try {
                    String value = this.extract(doc, field);
                    if (value == null) continue;
                    parsedFields.put(field, value);
                }
                catch (XPathExpressionException e) {
                    this.logger.warn("While processing xml, XPath invalid.", (Throwable)e);
                }
            }
        }
        catch (SAXException e) {
            this.logger.error("Couldn't process XML into a Document", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Problem reading input stream", (Throwable)e);
        }
        return parsedFields;
    }

    @Nullable
    private String extract(Document doc, String field) throws XPathExpressionException {
        XPathExpression expr = ((XPath)this.xpathSupplier.get()).compile("//" + field);
        NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        if (nl.getLength() > 0) {
            return nl.item(0).getTextContent();
        }
        return null;
    }
}

