/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils.logging;

import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.api.ads.common.lib.utils.logging.PrettyPrinterInterface;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.EmptyStackException;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PrettyPrinter
implements PrettyPrinterInterface {
    private final Logger libLogger;
    private final ImmutableList<String> sensitiveXPathStrings;
    private final Supplier<XPath> xpathSupplier;
    private final Supplier<Transformer> transformerSupplier;
    private final Supplier<DocumentBuilder> documentBuilderSupplier;

    @Inject
    public PrettyPrinter(AdsApiConfiguration adsApiConfiguration, @Named(value="libLogger") Logger libLogger, Supplier<XPath> xpathSupplier, Supplier<Transformer> transformerSupplier, Supplier<DocumentBuilder> documentBuilderSupplier) {
        Object[] sensitiveXPathsArray = adsApiConfiguration.getSensitiveXPaths();
        this.sensitiveXPathStrings = sensitiveXPathsArray == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])sensitiveXPathsArray);
        this.libLogger = libLogger;
        this.xpathSupplier = xpathSupplier;
        this.transformerSupplier = transformerSupplier;
        this.documentBuilderSupplier = documentBuilderSupplier;
    }

    @Override
    public String prettyPrint(String xml) {
        String formattedXml;
        if (xml == null) {
            return xml;
        }
        Source xmlSource = this.sanitizeXml(xml);
        if (xmlSource == null) {
            xmlSource = new StreamSource(new StringReader(xml));
        }
        return (formattedXml = this.formatXml(xmlSource)) != null ? formattedXml : xml;
    }

    private String formatXml(@Nullable Source xmlSource) {
        Transformer transformer = (Transformer)this.transformerSupplier.get();
        if (xmlSource != null && transformer != null) {
            try {
                StreamResult result = new StreamResult(new StringWriter());
                transformer.transform(xmlSource, result);
                return result.getWriter().toString();
            }
            catch (TransformerException e) {
                this.libLogger.warn("Unable to pretty print XML: {}", (Throwable)e);
            }
            catch (NullPointerException e) {
                this.libLogger.warn("Unable to pretty print XML: {}", (Throwable)e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.libLogger.warn("Unable to pretty print XML: {}", (Throwable)e);
            }
            catch (EmptyStackException e) {
                this.libLogger.warn("Unable to pretty print XML: {}", (Throwable)e);
            }
        }
        return null;
    }

    private Source sanitizeXml(@Nullable String xml) {
        if (xml != null && !this.sensitiveXPathStrings.isEmpty()) {
            try {
                DocumentBuilder documentBuilder = (DocumentBuilder)this.documentBuilderSupplier.get();
                XPath xpath = (XPath)this.xpathSupplier.get();
                if (documentBuilder != null && xpath != null) {
                    Document doc = documentBuilder.parse(new InputSource(new StringReader(xml)));
                    for (String xpathString : this.sensitiveXPathStrings) {
                        XPathExpression expr = xpath.compile(xpathString);
                        Node node = (Node)expr.evaluate(doc, XPathConstants.NODE);
                        if (node == null || node.getTextContent() == null) continue;
                        node.setTextContent("REDACTED");
                    }
                    return new DOMSource(doc);
                }
            }
            catch (SAXException e) {
                this.libLogger.warn("Unable to parse XML: {}", (Throwable)e);
            }
            catch (IOException e) {
                this.libLogger.warn("Unable to parse XML: {}", (Throwable)e);
            }
            catch (XPathExpressionException e) {
                this.libLogger.warn("Unable to parse XML: {}", (Throwable)e);
            }
        }
        return null;
    }
}

