/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201409.shopping;

import com.google.api.ads.adwords.axis.v201409.cm.ProductBiddingCategory;
import com.google.api.ads.adwords.axis.v201409.cm.ProductBrand;
import com.google.api.ads.adwords.axis.v201409.cm.ProductCanonicalCondition;
import com.google.api.ads.adwords.axis.v201409.cm.ProductCanonicalConditionCondition;
import com.google.api.ads.adwords.axis.v201409.cm.ProductCustomAttribute;
import com.google.api.ads.adwords.axis.v201409.cm.ProductDimension;
import com.google.api.ads.adwords.axis.v201409.cm.ProductDimensionType;
import com.google.api.ads.adwords.axis.v201409.cm.ProductOfferId;
import com.google.api.ads.adwords.axis.v201409.cm.ProductType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProductDimensionComparator
implements Comparator<ProductDimension> {
    private final ImmutableMap<Class<? extends ProductDimension>, Comparator<? extends ProductDimension>> comparatorMap;
    private static final Ordering<Comparable<?>> NULLS_LAST_NATURAL_ORDERING = Ordering.natural().nullsLast();
    private static final Ordering<Object> NULLS_LAST_OBJECT_ORDERING = Ordering.allEqual().nullsLast();
    private static final Ordering<ProductDimensionType> NULLS_LAST_DIMENSION_TYPE_ORDERING = new Ordering<ProductDimensionType>(){

        public int compare(ProductDimensionType left, ProductDimensionType right) {
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)left.getValue(), (Object)right.getValue());
        }
    }.nullsLast();
    private static final Ordering<String> NULLS_LAST_CASE_INSENSITIVE_ORDERING = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast();

    ProductDimensionComparator() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put(ProductBiddingCategory.class, (Object)new ProductBiddingCategoryComparator());
        mapBuilder.put(ProductBrand.class, (Object)new ProductBrandComparator());
        mapBuilder.put(ProductCanonicalCondition.class, (Object)new ProductCanonicalConditionComparator());
        mapBuilder.put(ProductCustomAttribute.class, (Object)new ProductCustomAttributeComparator());
        mapBuilder.put(ProductOfferId.class, (Object)new ProductOfferIdComparator());
        mapBuilder.put(ProductType.class, (Object)new ProductTypeComparator());
        this.comparatorMap = mapBuilder.build();
    }

    @Override
    public int compare(@Nullable ProductDimension d1, @Nullable ProductDimension d2) {
        Preconditions.checkArgument((d1 == null || this.comparatorMap.containsKey(d1.getClass()) ? 1 : 0) != 0, (String)"Unsupported dimension type %s", (Object[])new Object[]{d1});
        Preconditions.checkArgument((d2 == null || this.comparatorMap.containsKey(d2.getClass()) ? 1 : 0) != 0, (String)"Unsupported dimension type %s", (Object[])new Object[]{d2});
        if (d1 == d2) {
            return 0;
        }
        int result = NULLS_LAST_OBJECT_ORDERING.compare((Object)d1, (Object)d2);
        if (result != 0) {
            return result;
        }
        result = d1.getClass().getName().compareTo(d2.getClass().getName());
        if (result != 0) {
            return result;
        }
        Preconditions.checkArgument((boolean)d1.getClass().equals(d2.getClass()), (String)"Assumption failed - class of %s and %s are not equal", (Object[])new Object[]{d1, d2});
        return this.getDeepComparator(d1).compare(d1, d2);
    }

    private <D extends ProductDimension> Comparator<D> getDeepComparator(D dimension) {
        Comparator comparator = (Comparator)this.comparatorMap.get(dimension.getClass());
        Preconditions.checkArgument((comparator != null ? 1 : 0) != 0, (String)"No comparator exists for %s. This comparator only supports comparisons of ProductDimension subclasses supported by Shopping campaigns.", (Object[])new Object[]{dimension});
        return comparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductBiddingCategoryComparator
    implements Comparator<ProductBiddingCategory> {
        private ProductBiddingCategoryComparator() {
        }

        @Override
        public int compare(ProductBiddingCategory o1, ProductBiddingCategory o2) {
            int result = NULLS_LAST_DIMENSION_TYPE_ORDERING.compare((Object)o1.getType(), (Object)o2.getType());
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_NATURAL_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductBrandComparator
    implements Comparator<ProductBrand> {
        private ProductBrandComparator() {
        }

        @Override
        public int compare(ProductBrand o1, ProductBrand o2) {
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductCanonicalConditionComparator
    implements Comparator<ProductCanonicalCondition> {
        private ProductCanonicalConditionComparator() {
        }

        @Override
        public int compare(ProductCanonicalCondition o1, ProductCanonicalCondition o2) {
            ProductCanonicalConditionCondition condition2;
            ProductCanonicalConditionCondition condition1 = o1.getCondition();
            if (condition1 == (condition2 = o2.getCondition())) {
                return 0;
            }
            int result = NULLS_LAST_OBJECT_ORDERING.compare((Object)condition1, (Object)condition2);
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_NATURAL_ORDERING.compare((Object)condition1.getValue(), (Object)condition2.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductCustomAttributeComparator
    implements Comparator<ProductCustomAttribute> {
        private ProductCustomAttributeComparator() {
        }

        @Override
        public int compare(ProductCustomAttribute o1, ProductCustomAttribute o2) {
            int result = NULLS_LAST_DIMENSION_TYPE_ORDERING.compare((Object)o1.getType(), (Object)o2.getType());
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductOfferIdComparator
    implements Comparator<ProductOfferId> {
        private ProductOfferIdComparator() {
        }

        @Override
        public int compare(ProductOfferId o1, ProductOfferId o2) {
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductTypeComparator
    implements Comparator<ProductType> {
        private ProductTypeComparator() {
        }

        @Override
        public int compare(ProductType o1, ProductType o2) {
            int result = NULLS_LAST_DIMENSION_TYPE_ORDERING.compare((Object)o1.getType(), (Object)o2.getType());
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }
}

