/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis;

import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.common.lib.soap.axis.AxisSoapHeaderFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class AdWordsAxisSoapHeaderFactory
implements AxisSoapHeaderFactory<AdWordsServiceDescriptor> {
    private final String headerPartialName;

    @Inject
    AdWordsAxisSoapHeaderFactory() {
        this("cm.SoapHeader");
    }

    @VisibleForTesting
    AdWordsAxisSoapHeaderFactory(String headerPartialName) {
        this.headerPartialName = headerPartialName;
    }

    public Object createSoapHeader(AdWordsServiceDescriptor adWordsServiceDescriptor) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        Class interfaceClass = adWordsServiceDescriptor.getInterfaceClass();
        String packageName = interfaceClass.getPackage().getName();
        ArrayList packageParts = Lists.newArrayList((Object[])packageName.split("\\."));
        String parentPackage = Joiner.on((String)".").join(packageParts.subList(0, packageParts.size() - 1));
        Constructor<?> constructor = Class.forName(parentPackage + "." + this.headerPartialName).getDeclaredConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }
}

