/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UptimeCheckConfigName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/uptimeCheckConfigs/{uptime_check_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String uptimeCheckConfig;

    public String getProject() {
        return this.project;
    }

    public String getUptimeCheckConfig() {
        return this.uptimeCheckConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private UptimeCheckConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.uptimeCheckConfig = (String)Preconditions.checkNotNull((Object)builder.getUptimeCheckConfig());
    }

    public static UptimeCheckConfigName of(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build();
    }

    public static String format(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build().toString();
    }

    public static UptimeCheckConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "UptimeCheckConfigName.parse: formattedString not in valid format");
        return UptimeCheckConfigName.of((String)matchMap.get("project"), (String)matchMap.get("uptime_check_config"));
    }

    public static List<UptimeCheckConfigName> parseList(List<String> formattedStrings) {
        ArrayList<UptimeCheckConfigName> list = new ArrayList<UptimeCheckConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UptimeCheckConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UptimeCheckConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UptimeCheckConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UptimeCheckConfigName uptimeCheckConfigName = this;
            synchronized (uptimeCheckConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"uptimeCheckConfig", (Object)this.uptimeCheckConfig);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("UptimeCheckConfigName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "uptime_check_config", this.uptimeCheckConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UptimeCheckConfigName) {
            UptimeCheckConfigName that = (UptimeCheckConfigName)o;
            return this.project.equals(that.project) && this.uptimeCheckConfig.equals(that.uptimeCheckConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.uptimeCheckConfig.hashCode();
    }

    public static class Builder {
        private String project;
        private String uptimeCheckConfig;

        public String getProject() {
            return this.project;
        }

        public String getUptimeCheckConfig() {
            return this.uptimeCheckConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setUptimeCheckConfig(String uptimeCheckConfig) {
            this.uptimeCheckConfig = uptimeCheckConfig;
            return this;
        }

        private Builder() {
        }

        private Builder(UptimeCheckConfigName uptimeCheckConfigName) {
            this.project = uptimeCheckConfigName.project;
            this.uptimeCheckConfig = uptimeCheckConfigName.uptimeCheckConfig;
        }

        public UptimeCheckConfigName build() {
            return new UptimeCheckConfigName(this);
        }
    }
}

