/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 04:09:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * The request sent to the ClearOrgPolicy method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClearOrgPolicyRequest extends com.google.api.client.json.GenericJson {

  /**
   * Name of the `Constraint` of the `Policy` to clear.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String constraint;

  /**
   * The current version, for concurrency control. Not sending an `etag` will cause the `Policy` to
   * be cleared blindly.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Name of the `Constraint` of the `Policy` to clear.
   * @return value or {@code null} for none
   */
  public java.lang.String getConstraint() {
    return constraint;
  }

  /**
   * Name of the `Constraint` of the `Policy` to clear.
   * @param constraint constraint or {@code null} for none
   */
  public ClearOrgPolicyRequest setConstraint(java.lang.String constraint) {
    this.constraint = constraint;
    return this;
  }

  /**
   * The current version, for concurrency control. Not sending an `etag` will cause the `Policy` to
   * be cleared blindly.
   * @see #decodeEtag()
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The current version, for concurrency control. Not sending an `etag` will cause the `Policy` to
   * be cleared blindly.
   * @see #getEtag()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeEtag() {
    return com.google.api.client.util.Base64.decodeBase64(etag);
  }

  /**
   * The current version, for concurrency control. Not sending an `etag` will cause the `Policy` to
   * be cleared blindly.
   * @see #encodeEtag()
   * @param etag etag or {@code null} for none
   */
  public ClearOrgPolicyRequest setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The current version, for concurrency control. Not sending an `etag` will cause the `Policy` to
   * be cleared blindly.
   * @see #setEtag()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public ClearOrgPolicyRequest encodeEtag(byte[] etag) {
    this.etag = com.google.api.client.util.Base64.encodeBase64URLSafeString(etag);
    return this;
  }

  @Override
  public ClearOrgPolicyRequest set(String fieldName, Object value) {
    return (ClearOrgPolicyRequest) super.set(fieldName, value);
  }

  @Override
  public ClearOrgPolicyRequest clone() {
    return (ClearOrgPolicyRequest) super.clone();
  }

}
