/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 04:09:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * A `Constraint` describes a way in which a resource's configuration can be restricted. For
 * example, it controls which cloud services can be activated across an organization, or whether a
 * Compute Engine instance can have serial port connections established. `Constraints` can be
 * configured by the organization's policy adminstrator to fit the needs of the organzation by
 * setting Policies for `Constraints` at different locations in the organization's resource
 * hierarchy. Policies are inherited down the resource hierarchy from higher levels, but can also be
 * overridden. For details about the inheritance rules please read about Policies.
 *
 * `Constraints` have a default behavior determined by the `constraint_default` field, which is the
 * enforcement behavior that is used in the absence of a `Policy` being defined or inherited for the
 * resource in question.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Constraint extends com.google.api.client.json.GenericJson {

  /**
   * Defines this constraint as being a BooleanConstraint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BooleanConstraint booleanConstraint;

  /**
   * The evaluation behavior of this constraint in the absense of 'Policy'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String constraintDefault;

  /**
   * Detailed description of what this `Constraint` controls as well as how and where it is
   * enforced.
   *
   * Mutable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The human readable name.
   *
   * Mutable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Defines this constraint as being a ListConstraint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ListConstraint listConstraint;

  /**
   * Immutable value, required to globally be unique. For example,
   * `constraints/serviceuser.services`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Version of the `Constraint`. Default version is 0;
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer version;

  /**
   * Defines this constraint as being a BooleanConstraint.
   * @return value or {@code null} for none
   */
  public BooleanConstraint getBooleanConstraint() {
    return booleanConstraint;
  }

  /**
   * Defines this constraint as being a BooleanConstraint.
   * @param booleanConstraint booleanConstraint or {@code null} for none
   */
  public Constraint setBooleanConstraint(BooleanConstraint booleanConstraint) {
    this.booleanConstraint = booleanConstraint;
    return this;
  }

  /**
   * The evaluation behavior of this constraint in the absense of 'Policy'.
   * @return value or {@code null} for none
   */
  public java.lang.String getConstraintDefault() {
    return constraintDefault;
  }

  /**
   * The evaluation behavior of this constraint in the absense of 'Policy'.
   * @param constraintDefault constraintDefault or {@code null} for none
   */
  public Constraint setConstraintDefault(java.lang.String constraintDefault) {
    this.constraintDefault = constraintDefault;
    return this;
  }

  /**
   * Detailed description of what this `Constraint` controls as well as how and where it is
   * enforced.
   *
   * Mutable.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Detailed description of what this `Constraint` controls as well as how and where it is
   * enforced.
   *
   * Mutable.
   * @param description description or {@code null} for none
   */
  public Constraint setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The human readable name.
   *
   * Mutable.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The human readable name.
   *
   * Mutable.
   * @param displayName displayName or {@code null} for none
   */
  public Constraint setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Defines this constraint as being a ListConstraint.
   * @return value or {@code null} for none
   */
  public ListConstraint getListConstraint() {
    return listConstraint;
  }

  /**
   * Defines this constraint as being a ListConstraint.
   * @param listConstraint listConstraint or {@code null} for none
   */
  public Constraint setListConstraint(ListConstraint listConstraint) {
    this.listConstraint = listConstraint;
    return this;
  }

  /**
   * Immutable value, required to globally be unique. For example,
   * `constraints/serviceuser.services`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Immutable value, required to globally be unique. For example,
   * `constraints/serviceuser.services`
   * @param name name or {@code null} for none
   */
  public Constraint setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Version of the `Constraint`. Default version is 0;
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVersion() {
    return version;
  }

  /**
   * Version of the `Constraint`. Default version is 0;
   * @param version version or {@code null} for none
   */
  public Constraint setVersion(java.lang.Integer version) {
    this.version = version;
    return this;
  }

  @Override
  public Constraint set(String fieldName, Object value) {
    return (Constraint) super.set(fieldName, value);
  }

  @Override
  public Constraint clone() {
    return (Constraint) super.clone();
  }

}
