/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 04:09:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * Used in `policy_type` to specify how `list_policy` behaves at this resource.
 *
 * A `ListPolicy` can define specific values that are allowed or denied by setting either the
 * `allowed_values` or `denied_values` fields. It can also be used to allow or deny all values, by
 * setting the `all_values` field. If `all_values` is `ALL_VALUES_UNSPECIFIED`, exactly one of
 * `allowed_values` or `denied_values` must be set (attempting to set both or neither will result in
 * a failed request). If `all_values` is set to either `ALLOW` or `DENY`, `allowed_values` and
 * `denied_values` must be unset.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The policy all_values state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allValues;

  /**
   * List of values allowed  at this resource. Can only be set if no values are set for
   * `denied_values` and `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allowedValues;

  /**
   * List of values denied at this resource. Can only be set if no values are set for
   * `allowed_values` and `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> deniedValues;

  /**
   * Determines the inheritance behavior for this `Policy`.
   *
   * By default, a `ListPolicy` set at a resource supercedes any `Policy` set anywhere up the
   * resource hierarchy. However, if `inherit_from_parent` is set to `true`, then the values from
   * the effective `Policy` of the parent resource are inherited, meaning the values set in this
   * `Policy` are added to the values inherited up the hierarchy.
   *
   * Setting `Policy` hierarchies that inherit both allowed values and denied values isn't
   * recommended in most circumstances to keep the configuration simple and understandable. However,
   * it is possible to set a `Policy` with `allowed_values` set that inherits a `Policy` with
   * `denied_values` set. In this case, the values that are allowed must be in `allowed_values` and
   * not present in `denied_values`.
   *
   * For example, suppose you have a `Constraint` `constraints/serviceuser.services`, which has a
   * `constraint_type` of `list_constraint`, and with `constraint_default` set to `ALLOW`. Suppose
   * that at the Organization level, a `Policy` is applied that restricts the allowed API
   * activations to {`E1`, `E2`}. Then, if a `Policy` is applied to a project below the Organization
   * that has `inherit_from_parent` set to `false` and field all_values set to DENY, then an attempt
   * to activate any API will be denied.
   *
   * The following examples demonstrate different possible layerings:
   *
   * Example 1 (no inherited values):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values:”E2”}   ``projects/bar`` has `inherit_from_parent` `false`
   * and values:     {allowed_values: "E3" allowed_values: "E4"} The accepted values at
   * `organizations/foo` are `E1`, `E2`. The accepted values at `projects/bar` are `E3`, and `E4`.
   *
   * Example 2 (inherited values):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values:”E2”}   `projects/bar` has a `Policy` with values:
   * {value: “E3” value: ”E4” inherit_from_parent: true} The accepted values at `organizations/foo`
   * are `E1`, `E2`. The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
   *
   * Example 3 (inheriting both allowed and denied values):   `organizations/foo` has a `Policy`
   * with values:     {allowed_values: "E1" allowed_values: "E2"}   `projects/bar` has a `Policy`
   * with:     {denied_values: "E1"} The accepted values at `organizations/foo` are `E1`, `E2`. The
   * value accepted at `projects/bar` is `E2`.
   *
   * Example 4 (RestoreDefault):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values:”E2”}   `projects/bar` has a `Policy` with values:
   * {RestoreDefault: {}} The accepted values at `organizations/foo` are `E1`, `E2`. The accepted
   * values at `projects/bar` are either all or none depending on the value of `constraint_default`
   * (if `ALLOW`, all; if `DENY`, none).
   *
   * Example 5 (no policy inherits parent policy):   `organizations/foo` has no `Policy` set.
   * `projects/bar` has no `Policy` set. The accepted values at both levels are either all or none
   * depending on the value of `constraint_default` (if `ALLOW`, all; if `DENY`, none).
   *
   * Example 6 (ListConstraint allowing all):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values: ”E2”}   `projects/bar` has a `Policy` with:     {all:
   * ALLOW} The accepted values at `organizations/foo` are `E1`, E2`. Any value is accepted at
   * `projects/bar`.
   *
   * Example 7 (ListConstraint allowing none):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values: ”E2”}   `projects/bar` has a `Policy` with:     {all:
   * DENY} The accepted values at `organizations/foo` are `E1`, E2`. No value is accepted at
   * `projects/bar`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean inheritFromParent;

  /**
   * Optional. The Google Cloud Console will try to default to a configuration that matches the
   * value specified in this `Policy`. If `suggested_value` is not set, it will inherit the value
   * specified higher in the hierarchy, unless `inherit_from_parent` is `false`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String suggestedValue;

  /**
   * The policy all_values state.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllValues() {
    return allValues;
  }

  /**
   * The policy all_values state.
   * @param allValues allValues or {@code null} for none
   */
  public ListPolicy setAllValues(java.lang.String allValues) {
    this.allValues = allValues;
    return this;
  }

  /**
   * List of values allowed  at this resource. Can only be set if no values are set for
   * `denied_values` and `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllowedValues() {
    return allowedValues;
  }

  /**
   * List of values allowed  at this resource. Can only be set if no values are set for
   * `denied_values` and `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
   * @param allowedValues allowedValues or {@code null} for none
   */
  public ListPolicy setAllowedValues(java.util.List<java.lang.String> allowedValues) {
    this.allowedValues = allowedValues;
    return this;
  }

  /**
   * List of values denied at this resource. Can only be set if no values are set for
   * `allowed_values` and `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDeniedValues() {
    return deniedValues;
  }

  /**
   * List of values denied at this resource. Can only be set if no values are set for
   * `allowed_values` and `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
   * @param deniedValues deniedValues or {@code null} for none
   */
  public ListPolicy setDeniedValues(java.util.List<java.lang.String> deniedValues) {
    this.deniedValues = deniedValues;
    return this;
  }

  /**
   * Determines the inheritance behavior for this `Policy`.
   *
   * By default, a `ListPolicy` set at a resource supercedes any `Policy` set anywhere up the
   * resource hierarchy. However, if `inherit_from_parent` is set to `true`, then the values from
   * the effective `Policy` of the parent resource are inherited, meaning the values set in this
   * `Policy` are added to the values inherited up the hierarchy.
   *
   * Setting `Policy` hierarchies that inherit both allowed values and denied values isn't
   * recommended in most circumstances to keep the configuration simple and understandable. However,
   * it is possible to set a `Policy` with `allowed_values` set that inherits a `Policy` with
   * `denied_values` set. In this case, the values that are allowed must be in `allowed_values` and
   * not present in `denied_values`.
   *
   * For example, suppose you have a `Constraint` `constraints/serviceuser.services`, which has a
   * `constraint_type` of `list_constraint`, and with `constraint_default` set to `ALLOW`. Suppose
   * that at the Organization level, a `Policy` is applied that restricts the allowed API
   * activations to {`E1`, `E2`}. Then, if a `Policy` is applied to a project below the Organization
   * that has `inherit_from_parent` set to `false` and field all_values set to DENY, then an attempt
   * to activate any API will be denied.
   *
   * The following examples demonstrate different possible layerings:
   *
   * Example 1 (no inherited values):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values:”E2”}   ``projects/bar`` has `inherit_from_parent` `false`
   * and values:     {allowed_values: "E3" allowed_values: "E4"} The accepted values at
   * `organizations/foo` are `E1`, `E2`. The accepted values at `projects/bar` are `E3`, and `E4`.
   *
   * Example 2 (inherited values):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values:”E2”}   `projects/bar` has a `Policy` with values:
   * {value: “E3” value: ”E4” inherit_from_parent: true} The accepted values at `organizations/foo`
   * are `E1`, `E2`. The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
   *
   * Example 3 (inheriting both allowed and denied values):   `organizations/foo` has a `Policy`
   * with values:     {allowed_values: "E1" allowed_values: "E2"}   `projects/bar` has a `Policy`
   * with:     {denied_values: "E1"} The accepted values at `organizations/foo` are `E1`, `E2`. The
   * value accepted at `projects/bar` is `E2`.
   *
   * Example 4 (RestoreDefault):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values:”E2”}   `projects/bar` has a `Policy` with values:
   * {RestoreDefault: {}} The accepted values at `organizations/foo` are `E1`, `E2`. The accepted
   * values at `projects/bar` are either all or none depending on the value of `constraint_default`
   * (if `ALLOW`, all; if `DENY`, none).
   *
   * Example 5 (no policy inherits parent policy):   `organizations/foo` has no `Policy` set.
   * `projects/bar` has no `Policy` set. The accepted values at both levels are either all or none
   * depending on the value of `constraint_default` (if `ALLOW`, all; if `DENY`, none).
   *
   * Example 6 (ListConstraint allowing all):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values: ”E2”}   `projects/bar` has a `Policy` with:     {all:
   * ALLOW} The accepted values at `organizations/foo` are `E1`, E2`. Any value is accepted at
   * `projects/bar`.
   *
   * Example 7 (ListConstraint allowing none):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values: ”E2”}   `projects/bar` has a `Policy` with:     {all:
   * DENY} The accepted values at `organizations/foo` are `E1`, E2`. No value is accepted at
   * `projects/bar`.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getInheritFromParent() {
    return inheritFromParent;
  }

  /**
   * Determines the inheritance behavior for this `Policy`.
   *
   * By default, a `ListPolicy` set at a resource supercedes any `Policy` set anywhere up the
   * resource hierarchy. However, if `inherit_from_parent` is set to `true`, then the values from
   * the effective `Policy` of the parent resource are inherited, meaning the values set in this
   * `Policy` are added to the values inherited up the hierarchy.
   *
   * Setting `Policy` hierarchies that inherit both allowed values and denied values isn't
   * recommended in most circumstances to keep the configuration simple and understandable. However,
   * it is possible to set a `Policy` with `allowed_values` set that inherits a `Policy` with
   * `denied_values` set. In this case, the values that are allowed must be in `allowed_values` and
   * not present in `denied_values`.
   *
   * For example, suppose you have a `Constraint` `constraints/serviceuser.services`, which has a
   * `constraint_type` of `list_constraint`, and with `constraint_default` set to `ALLOW`. Suppose
   * that at the Organization level, a `Policy` is applied that restricts the allowed API
   * activations to {`E1`, `E2`}. Then, if a `Policy` is applied to a project below the Organization
   * that has `inherit_from_parent` set to `false` and field all_values set to DENY, then an attempt
   * to activate any API will be denied.
   *
   * The following examples demonstrate different possible layerings:
   *
   * Example 1 (no inherited values):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values:”E2”}   ``projects/bar`` has `inherit_from_parent` `false`
   * and values:     {allowed_values: "E3" allowed_values: "E4"} The accepted values at
   * `organizations/foo` are `E1`, `E2`. The accepted values at `projects/bar` are `E3`, and `E4`.
   *
   * Example 2 (inherited values):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values:”E2”}   `projects/bar` has a `Policy` with values:
   * {value: “E3” value: ”E4” inherit_from_parent: true} The accepted values at `organizations/foo`
   * are `E1`, `E2`. The accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
   *
   * Example 3 (inheriting both allowed and denied values):   `organizations/foo` has a `Policy`
   * with values:     {allowed_values: "E1" allowed_values: "E2"}   `projects/bar` has a `Policy`
   * with:     {denied_values: "E1"} The accepted values at `organizations/foo` are `E1`, `E2`. The
   * value accepted at `projects/bar` is `E2`.
   *
   * Example 4 (RestoreDefault):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values:”E2”}   `projects/bar` has a `Policy` with values:
   * {RestoreDefault: {}} The accepted values at `organizations/foo` are `E1`, `E2`. The accepted
   * values at `projects/bar` are either all or none depending on the value of `constraint_default`
   * (if `ALLOW`, all; if `DENY`, none).
   *
   * Example 5 (no policy inherits parent policy):   `organizations/foo` has no `Policy` set.
   * `projects/bar` has no `Policy` set. The accepted values at both levels are either all or none
   * depending on the value of `constraint_default` (if `ALLOW`, all; if `DENY`, none).
   *
   * Example 6 (ListConstraint allowing all):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values: ”E2”}   `projects/bar` has a `Policy` with:     {all:
   * ALLOW} The accepted values at `organizations/foo` are `E1`, E2`. Any value is accepted at
   * `projects/bar`.
   *
   * Example 7 (ListConstraint allowing none):   `organizations/foo` has a `Policy` with values:
   * {allowed_values: “E1” allowed_values: ”E2”}   `projects/bar` has a `Policy` with:     {all:
   * DENY} The accepted values at `organizations/foo` are `E1`, E2`. No value is accepted at
   * `projects/bar`.
   * @param inheritFromParent inheritFromParent or {@code null} for none
   */
  public ListPolicy setInheritFromParent(java.lang.Boolean inheritFromParent) {
    this.inheritFromParent = inheritFromParent;
    return this;
  }

  /**
   * Optional. The Google Cloud Console will try to default to a configuration that matches the
   * value specified in this `Policy`. If `suggested_value` is not set, it will inherit the value
   * specified higher in the hierarchy, unless `inherit_from_parent` is `false`.
   * @return value or {@code null} for none
   */
  public java.lang.String getSuggestedValue() {
    return suggestedValue;
  }

  /**
   * Optional. The Google Cloud Console will try to default to a configuration that matches the
   * value specified in this `Policy`. If `suggested_value` is not set, it will inherit the value
   * specified higher in the hierarchy, unless `inherit_from_parent` is `false`.
   * @param suggestedValue suggestedValue or {@code null} for none
   */
  public ListPolicy setSuggestedValue(java.lang.String suggestedValue) {
    this.suggestedValue = suggestedValue;
    return this;
  }

  @Override
  public ListPolicy set(String fieldName, Object value) {
    return (ListPolicy) super.set(fieldName, value);
  }

  @Override
  public ListPolicy clone() {
    return (ListPolicy) super.clone();
  }

}
