/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 04:09:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * Ignores policies set above this resource and restores the `constraint_default` enforcement
 * behavior of the specific `Constraint` at this resource.
 *
 * Suppose that `constraint_default` is set to `ALLOW` for the `Constraint`
 * `constraints/serviceuser.services`. Suppose that organization foo.com sets a `Policy` at their
 * Organization resource node that restricts the allowed service activations to deny all service
 * activations. They could then set a `Policy` with the `policy_type` `restore_default` on several
 * experimental projects, restoring the `constraint_default` enforcement of the `Constraint` for
 * only those projects, allowing those projects to have all services activated.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RestoreDefault extends com.google.api.client.json.GenericJson {

  @Override
  public RestoreDefault set(String fieldName, Object value) {
    return (RestoreDefault) super.set(fieldName, value);
  }

  @Override
  public RestoreDefault clone() {
    return (RestoreDefault) super.clone();
  }

}
