/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 04:09:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.cloudresourcemanager.model;

/**
 * The request sent to the `SearchOrganizations` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Resource Manager API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SearchOrganizationsRequest extends com.google.api.client.json.GenericJson {

  /**
   * An optional query string used to filter the Organizations to return in the response. Filter
   * rules are case-insensitive.
   *
   * Organizations may be filtered by `owner.directoryCustomerId` or by `domain`, where the domain
   * is a Google for Work domain, for example:
   *
   * |Filter|Description| |------|-----------| |owner.directorycustomerid:123456789|Organizations
   * with `owner.directory_customer_id` equal to `123456789`.| |domain:google.com|Organizations
   * corresponding to the domain `google.com`.|
   *
   * This field is optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filter;

  /**
   * The maximum number of Organizations to return in the response. This field is optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer pageSize;

  /**
   * A pagination token returned from a previous call to `SearchOrganizations` that indicates from
   * where listing should continue. This field is optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pageToken;

  /**
   * An optional query string used to filter the Organizations to return in the response. Filter
   * rules are case-insensitive.
   *
   * Organizations may be filtered by `owner.directoryCustomerId` or by `domain`, where the domain
   * is a Google for Work domain, for example:
   *
   * |Filter|Description| |------|-----------| |owner.directorycustomerid:123456789|Organizations
   * with `owner.directory_customer_id` equal to `123456789`.| |domain:google.com|Organizations
   * corresponding to the domain `google.com`.|
   *
   * This field is optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilter() {
    return filter;
  }

  /**
   * An optional query string used to filter the Organizations to return in the response. Filter
   * rules are case-insensitive.
   *
   * Organizations may be filtered by `owner.directoryCustomerId` or by `domain`, where the domain
   * is a Google for Work domain, for example:
   *
   * |Filter|Description| |------|-----------| |owner.directorycustomerid:123456789|Organizations
   * with `owner.directory_customer_id` equal to `123456789`.| |domain:google.com|Organizations
   * corresponding to the domain `google.com`.|
   *
   * This field is optional.
   * @param filter filter or {@code null} for none
   */
  public SearchOrganizationsRequest setFilter(java.lang.String filter) {
    this.filter = filter;
    return this;
  }

  /**
   * The maximum number of Organizations to return in the response. This field is optional.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPageSize() {
    return pageSize;
  }

  /**
   * The maximum number of Organizations to return in the response. This field is optional.
   * @param pageSize pageSize or {@code null} for none
   */
  public SearchOrganizationsRequest setPageSize(java.lang.Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * A pagination token returned from a previous call to `SearchOrganizations` that indicates from
   * where listing should continue. This field is optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getPageToken() {
    return pageToken;
  }

  /**
   * A pagination token returned from a previous call to `SearchOrganizations` that indicates from
   * where listing should continue. This field is optional.
   * @param pageToken pageToken or {@code null} for none
   */
  public SearchOrganizationsRequest setPageToken(java.lang.String pageToken) {
    this.pageToken = pageToken;
    return this;
  }

  @Override
  public SearchOrganizationsRequest set(String fieldName, Object value) {
    return (SearchOrganizationsRequest) super.set(fieldName, value);
  }

  @Override
  public SearchOrganizationsRequest clone() {
    return (SearchOrganizationsRequest) super.clone();
  }

}
