/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudresourcemanager;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudresourcemanager.CloudResourceManagerRequest;
import com.google.api.services.cloudresourcemanager.CloudResourceManagerRequestInitializer;
import com.google.api.services.cloudresourcemanager.model.ClearOrgPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.Empty;
import com.google.api.services.cloudresourcemanager.model.GetAncestryRequest;
import com.google.api.services.cloudresourcemanager.model.GetAncestryResponse;
import com.google.api.services.cloudresourcemanager.model.GetEffectiveOrgPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.GetOrgPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.Lien;
import com.google.api.services.cloudresourcemanager.model.ListAvailableOrgPolicyConstraintsRequest;
import com.google.api.services.cloudresourcemanager.model.ListAvailableOrgPolicyConstraintsResponse;
import com.google.api.services.cloudresourcemanager.model.ListLiensResponse;
import com.google.api.services.cloudresourcemanager.model.ListOrgPoliciesRequest;
import com.google.api.services.cloudresourcemanager.model.ListOrgPoliciesResponse;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import com.google.api.services.cloudresourcemanager.model.Operation;
import com.google.api.services.cloudresourcemanager.model.OrgPolicy;
import com.google.api.services.cloudresourcemanager.model.Organization;
import com.google.api.services.cloudresourcemanager.model.Policy;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.cloudresourcemanager.model.SearchOrganizationsRequest;
import com.google.api.services.cloudresourcemanager.model.SearchOrganizationsResponse;
import com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.SetOrgPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse;
import com.google.api.services.cloudresourcemanager.model.UndeleteProjectRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudResourceManager
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudresourcemanager.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudresourcemanager.googleapis.com/";

    public CloudResourceManager(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    CloudResourceManager(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Folders folders() {
        return new Folders();
    }

    public Liens liens() {
        return new Liens();
    }

    public Operations operations() {
        return new Operations();
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Google Cloud Resource Manager API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://cloudresourcemanager.googleapis.com/", CloudResourceManager.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudResourceManager.DEFAULT_BATCH_PATH);
        }

        public CloudResourceManager build() {
            return new CloudResourceManager(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setCloudResourceManagerRequestInitializer(CloudResourceManagerRequestInitializer cloudResourceManagerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudResourceManagerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public ClearOrgPolicy clearOrgPolicy(String string, ClearOrgPolicyRequest clearOrgPolicyRequest) throws IOException {
            ClearOrgPolicy clearOrgPolicy = new ClearOrgPolicy(string, clearOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)clearOrgPolicy);
            return clearOrgPolicy;
        }

        public Create create(Project project) throws IOException {
            Create create = new Create(project);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetAncestry getAncestry(String string, GetAncestryRequest getAncestryRequest) throws IOException {
            GetAncestry getAncestry = new GetAncestry(string, getAncestryRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getAncestry);
            return getAncestry;
        }

        public GetEffectiveOrgPolicy getEffectiveOrgPolicy(String string, GetEffectiveOrgPolicyRequest getEffectiveOrgPolicyRequest) throws IOException {
            GetEffectiveOrgPolicy getEffectiveOrgPolicy = new GetEffectiveOrgPolicy(string, getEffectiveOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getEffectiveOrgPolicy);
            return getEffectiveOrgPolicy;
        }

        public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
            GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
            return getIamPolicy;
        }

        public GetOrgPolicy getOrgPolicy(String string, GetOrgPolicyRequest getOrgPolicyRequest) throws IOException {
            GetOrgPolicy getOrgPolicy = new GetOrgPolicy(string, getOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getOrgPolicy);
            return getOrgPolicy;
        }

        public List list() throws IOException {
            List list = new List();
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListAvailableOrgPolicyConstraints listAvailableOrgPolicyConstraints(String string, ListAvailableOrgPolicyConstraintsRequest listAvailableOrgPolicyConstraintsRequest) throws IOException {
            ListAvailableOrgPolicyConstraints listAvailableOrgPolicyConstraints = new ListAvailableOrgPolicyConstraints(string, listAvailableOrgPolicyConstraintsRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)listAvailableOrgPolicyConstraints);
            return listAvailableOrgPolicyConstraints;
        }

        public ListOrgPolicies listOrgPolicies(String string, ListOrgPoliciesRequest listOrgPoliciesRequest) throws IOException {
            ListOrgPolicies listOrgPolicies = new ListOrgPolicies(string, listOrgPoliciesRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)listOrgPolicies);
            return listOrgPolicies;
        }

        public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
            SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
            return setIamPolicy;
        }

        public SetOrgPolicy setOrgPolicy(String string, SetOrgPolicyRequest setOrgPolicyRequest) throws IOException {
            SetOrgPolicy setOrgPolicy = new SetOrgPolicy(string, setOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)setOrgPolicy);
            return setOrgPolicy;
        }

        public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
            TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
            return testIamPermissions;
        }

        public Undelete undelete(String string, UndeleteProjectRequest undeleteProjectRequest) throws IOException {
            Undelete undelete = new Undelete(string, undeleteProjectRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)undelete);
            return undelete;
        }

        public Update update(String string, Project project) throws IOException {
            Update update = new Update(string, project);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1/projects/{projectId}";
            @Key
            private String projectId;

            protected Update(String string, Project project) {
                super(CloudResourceManager.this, "PUT", REST_PATH, (Object)project, Project.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Update set$Xgafv(String string) {
                return (Update)super.set$Xgafv(string);
            }

            public Update setAccessToken(String string) {
                return (Update)super.setAccessToken(string);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setBearerToken(String string) {
                return (Update)super.setBearerToken(string);
            }

            public Update setCallback(String string) {
                return (Update)super.setCallback(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPp(Boolean bl) {
                return (Update)super.setPp(bl);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUploadType(String string) {
                return (Update)super.setUploadType(string);
            }

            public Update setUploadProtocol(String string) {
                return (Update)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Undelete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/projects/{projectId}:undelete";
            @Key
            private String projectId;

            protected Undelete(String string, UndeleteProjectRequest undeleteProjectRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)undeleteProjectRequest, Empty.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Undelete set$Xgafv(String string) {
                return (Undelete)super.set$Xgafv(string);
            }

            public Undelete setAccessToken(String string) {
                return (Undelete)super.setAccessToken(string);
            }

            public Undelete setAlt(String string) {
                return (Undelete)super.setAlt(string);
            }

            public Undelete setBearerToken(String string) {
                return (Undelete)super.setBearerToken(string);
            }

            public Undelete setCallback(String string) {
                return (Undelete)super.setCallback(string);
            }

            public Undelete setFields(String string) {
                return (Undelete)super.setFields(string);
            }

            public Undelete setKey(String string) {
                return (Undelete)super.setKey(string);
            }

            public Undelete setOauthToken(String string) {
                return (Undelete)super.setOauthToken(string);
            }

            public Undelete setPp(Boolean bl) {
                return (Undelete)super.setPp(bl);
            }

            public Undelete setPrettyPrint(Boolean bl) {
                return (Undelete)super.setPrettyPrint(bl);
            }

            public Undelete setQuotaUser(String string) {
                return (Undelete)super.setQuotaUser(string);
            }

            public Undelete setUploadType(String string) {
                return (Undelete)super.setUploadType(string);
            }

            public Undelete setUploadProtocol(String string) {
                return (Undelete)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Undelete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Undelete set(String string, Object object) {
                return (Undelete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TestIamPermissions
        extends CloudResourceManagerRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1/projects/{resource}:testIamPermissions";
            @Key
            private String resource;

            protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
            }

            public TestIamPermissions set$Xgafv(String string) {
                return (TestIamPermissions)super.set$Xgafv(string);
            }

            public TestIamPermissions setAccessToken(String string) {
                return (TestIamPermissions)super.setAccessToken(string);
            }

            public TestIamPermissions setAlt(String string) {
                return (TestIamPermissions)super.setAlt(string);
            }

            public TestIamPermissions setBearerToken(String string) {
                return (TestIamPermissions)super.setBearerToken(string);
            }

            public TestIamPermissions setCallback(String string) {
                return (TestIamPermissions)super.setCallback(string);
            }

            public TestIamPermissions setFields(String string) {
                return (TestIamPermissions)super.setFields(string);
            }

            public TestIamPermissions setKey(String string) {
                return (TestIamPermissions)super.setKey(string);
            }

            public TestIamPermissions setOauthToken(String string) {
                return (TestIamPermissions)super.setOauthToken(string);
            }

            public TestIamPermissions setPp(Boolean bl) {
                return (TestIamPermissions)super.setPp(bl);
            }

            public TestIamPermissions setPrettyPrint(Boolean bl) {
                return (TestIamPermissions)super.setPrettyPrint(bl);
            }

            public TestIamPermissions setQuotaUser(String string) {
                return (TestIamPermissions)super.setQuotaUser(string);
            }

            public TestIamPermissions setUploadType(String string) {
                return (TestIamPermissions)super.setUploadType(string);
            }

            public TestIamPermissions setUploadProtocol(String string) {
                return (TestIamPermissions)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public TestIamPermissions set(String string, Object object) {
                return (TestIamPermissions)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:setOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetOrgPolicy(String string, SetOrgPolicyRequest setOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)setOrgPolicyRequest, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public SetOrgPolicy set$Xgafv(String string) {
                return (SetOrgPolicy)super.set$Xgafv(string);
            }

            public SetOrgPolicy setAccessToken(String string) {
                return (SetOrgPolicy)super.setAccessToken(string);
            }

            public SetOrgPolicy setAlt(String string) {
                return (SetOrgPolicy)super.setAlt(string);
            }

            public SetOrgPolicy setBearerToken(String string) {
                return (SetOrgPolicy)super.setBearerToken(string);
            }

            public SetOrgPolicy setCallback(String string) {
                return (SetOrgPolicy)super.setCallback(string);
            }

            public SetOrgPolicy setFields(String string) {
                return (SetOrgPolicy)super.setFields(string);
            }

            public SetOrgPolicy setKey(String string) {
                return (SetOrgPolicy)super.setKey(string);
            }

            public SetOrgPolicy setOauthToken(String string) {
                return (SetOrgPolicy)super.setOauthToken(string);
            }

            public SetOrgPolicy setPp(Boolean bl) {
                return (SetOrgPolicy)super.setPp(bl);
            }

            public SetOrgPolicy setPrettyPrint(Boolean bl) {
                return (SetOrgPolicy)super.setPrettyPrint(bl);
            }

            public SetOrgPolicy setQuotaUser(String string) {
                return (SetOrgPolicy)super.setQuotaUser(string);
            }

            public SetOrgPolicy setUploadType(String string) {
                return (SetOrgPolicy)super.setUploadType(string);
            }

            public SetOrgPolicy setUploadProtocol(String string) {
                return (SetOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public SetOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public SetOrgPolicy set(String string, Object object) {
                return (SetOrgPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1/projects/{resource}:setIamPolicy";
            @Key
            private String resource;

            protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
            }

            public SetIamPolicy set$Xgafv(String string) {
                return (SetIamPolicy)super.set$Xgafv(string);
            }

            public SetIamPolicy setAccessToken(String string) {
                return (SetIamPolicy)super.setAccessToken(string);
            }

            public SetIamPolicy setAlt(String string) {
                return (SetIamPolicy)super.setAlt(string);
            }

            public SetIamPolicy setBearerToken(String string) {
                return (SetIamPolicy)super.setBearerToken(string);
            }

            public SetIamPolicy setCallback(String string) {
                return (SetIamPolicy)super.setCallback(string);
            }

            public SetIamPolicy setFields(String string) {
                return (SetIamPolicy)super.setFields(string);
            }

            public SetIamPolicy setKey(String string) {
                return (SetIamPolicy)super.setKey(string);
            }

            public SetIamPolicy setOauthToken(String string) {
                return (SetIamPolicy)super.setOauthToken(string);
            }

            public SetIamPolicy setPp(Boolean bl) {
                return (SetIamPolicy)super.setPp(bl);
            }

            public SetIamPolicy setPrettyPrint(Boolean bl) {
                return (SetIamPolicy)super.setPrettyPrint(bl);
            }

            public SetIamPolicy setQuotaUser(String string) {
                return (SetIamPolicy)super.setQuotaUser(string);
            }

            public SetIamPolicy setUploadType(String string) {
                return (SetIamPolicy)super.setUploadType(string);
            }

            public SetIamPolicy setUploadProtocol(String string) {
                return (SetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public SetIamPolicy set(String string, Object object) {
                return (SetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListOrgPolicies
        extends CloudResourceManagerRequest<ListOrgPoliciesResponse> {
            private static final String REST_PATH = "v1/{+resource}:listOrgPolicies";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListOrgPolicies(String string, ListOrgPoliciesRequest listOrgPoliciesRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)listOrgPoliciesRequest, ListOrgPoliciesResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public ListOrgPolicies set$Xgafv(String string) {
                return (ListOrgPolicies)super.set$Xgafv(string);
            }

            public ListOrgPolicies setAccessToken(String string) {
                return (ListOrgPolicies)super.setAccessToken(string);
            }

            public ListOrgPolicies setAlt(String string) {
                return (ListOrgPolicies)super.setAlt(string);
            }

            public ListOrgPolicies setBearerToken(String string) {
                return (ListOrgPolicies)super.setBearerToken(string);
            }

            public ListOrgPolicies setCallback(String string) {
                return (ListOrgPolicies)super.setCallback(string);
            }

            public ListOrgPolicies setFields(String string) {
                return (ListOrgPolicies)super.setFields(string);
            }

            public ListOrgPolicies setKey(String string) {
                return (ListOrgPolicies)super.setKey(string);
            }

            public ListOrgPolicies setOauthToken(String string) {
                return (ListOrgPolicies)super.setOauthToken(string);
            }

            public ListOrgPolicies setPp(Boolean bl) {
                return (ListOrgPolicies)super.setPp(bl);
            }

            public ListOrgPolicies setPrettyPrint(Boolean bl) {
                return (ListOrgPolicies)super.setPrettyPrint(bl);
            }

            public ListOrgPolicies setQuotaUser(String string) {
                return (ListOrgPolicies)super.setQuotaUser(string);
            }

            public ListOrgPolicies setUploadType(String string) {
                return (ListOrgPolicies)super.setUploadType(string);
            }

            public ListOrgPolicies setUploadProtocol(String string) {
                return (ListOrgPolicies)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public ListOrgPolicies setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public ListOrgPolicies set(String string, Object object) {
                return (ListOrgPolicies)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListAvailableOrgPolicyConstraints
        extends CloudResourceManagerRequest<ListAvailableOrgPolicyConstraintsResponse> {
            private static final String REST_PATH = "v1/{+resource}:listAvailableOrgPolicyConstraints";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListAvailableOrgPolicyConstraints(String string, ListAvailableOrgPolicyConstraintsRequest listAvailableOrgPolicyConstraintsRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)listAvailableOrgPolicyConstraintsRequest, ListAvailableOrgPolicyConstraintsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public ListAvailableOrgPolicyConstraints set$Xgafv(String string) {
                return (ListAvailableOrgPolicyConstraints)super.set$Xgafv(string);
            }

            public ListAvailableOrgPolicyConstraints setAccessToken(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setAccessToken(string);
            }

            public ListAvailableOrgPolicyConstraints setAlt(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setAlt(string);
            }

            public ListAvailableOrgPolicyConstraints setBearerToken(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setBearerToken(string);
            }

            public ListAvailableOrgPolicyConstraints setCallback(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setCallback(string);
            }

            public ListAvailableOrgPolicyConstraints setFields(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setFields(string);
            }

            public ListAvailableOrgPolicyConstraints setKey(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setKey(string);
            }

            public ListAvailableOrgPolicyConstraints setOauthToken(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setOauthToken(string);
            }

            public ListAvailableOrgPolicyConstraints setPp(Boolean bl) {
                return (ListAvailableOrgPolicyConstraints)super.setPp(bl);
            }

            public ListAvailableOrgPolicyConstraints setPrettyPrint(Boolean bl) {
                return (ListAvailableOrgPolicyConstraints)super.setPrettyPrint(bl);
            }

            public ListAvailableOrgPolicyConstraints setQuotaUser(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setQuotaUser(string);
            }

            public ListAvailableOrgPolicyConstraints setUploadType(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadType(string);
            }

            public ListAvailableOrgPolicyConstraints setUploadProtocol(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public ListAvailableOrgPolicyConstraints setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public ListAvailableOrgPolicyConstraints set(String string, Object object) {
                return (ListAvailableOrgPolicyConstraints)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CloudResourceManagerRequest<ListProjectsResponse> {
            private static final String REST_PATH = "v1/projects";
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;
            @Key
            private String filter;

            protected List() {
                super(CloudResourceManager.this, "GET", REST_PATH, null, ListProjectsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetOrgPolicy(String string, GetOrgPolicyRequest getOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getOrgPolicyRequest, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public GetOrgPolicy set$Xgafv(String string) {
                return (GetOrgPolicy)super.set$Xgafv(string);
            }

            public GetOrgPolicy setAccessToken(String string) {
                return (GetOrgPolicy)super.setAccessToken(string);
            }

            public GetOrgPolicy setAlt(String string) {
                return (GetOrgPolicy)super.setAlt(string);
            }

            public GetOrgPolicy setBearerToken(String string) {
                return (GetOrgPolicy)super.setBearerToken(string);
            }

            public GetOrgPolicy setCallback(String string) {
                return (GetOrgPolicy)super.setCallback(string);
            }

            public GetOrgPolicy setFields(String string) {
                return (GetOrgPolicy)super.setFields(string);
            }

            public GetOrgPolicy setKey(String string) {
                return (GetOrgPolicy)super.setKey(string);
            }

            public GetOrgPolicy setOauthToken(String string) {
                return (GetOrgPolicy)super.setOauthToken(string);
            }

            public GetOrgPolicy setPp(Boolean bl) {
                return (GetOrgPolicy)super.setPp(bl);
            }

            public GetOrgPolicy setPrettyPrint(Boolean bl) {
                return (GetOrgPolicy)super.setPrettyPrint(bl);
            }

            public GetOrgPolicy setQuotaUser(String string) {
                return (GetOrgPolicy)super.setQuotaUser(string);
            }

            public GetOrgPolicy setUploadType(String string) {
                return (GetOrgPolicy)super.setUploadType(string);
            }

            public GetOrgPolicy setUploadProtocol(String string) {
                return (GetOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public GetOrgPolicy set(String string, Object object) {
                return (GetOrgPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1/projects/{resource}:getIamPolicy";
            @Key
            private String resource;

            protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
            }

            public GetIamPolicy set$Xgafv(String string) {
                return (GetIamPolicy)super.set$Xgafv(string);
            }

            public GetIamPolicy setAccessToken(String string) {
                return (GetIamPolicy)super.setAccessToken(string);
            }

            public GetIamPolicy setAlt(String string) {
                return (GetIamPolicy)super.setAlt(string);
            }

            public GetIamPolicy setBearerToken(String string) {
                return (GetIamPolicy)super.setBearerToken(string);
            }

            public GetIamPolicy setCallback(String string) {
                return (GetIamPolicy)super.setCallback(string);
            }

            public GetIamPolicy setFields(String string) {
                return (GetIamPolicy)super.setFields(string);
            }

            public GetIamPolicy setKey(String string) {
                return (GetIamPolicy)super.setKey(string);
            }

            public GetIamPolicy setOauthToken(String string) {
                return (GetIamPolicy)super.setOauthToken(string);
            }

            public GetIamPolicy setPp(Boolean bl) {
                return (GetIamPolicy)super.setPp(bl);
            }

            public GetIamPolicy setPrettyPrint(Boolean bl) {
                return (GetIamPolicy)super.setPrettyPrint(bl);
            }

            public GetIamPolicy setQuotaUser(String string) {
                return (GetIamPolicy)super.setQuotaUser(string);
            }

            public GetIamPolicy setUploadType(String string) {
                return (GetIamPolicy)super.setUploadType(string);
            }

            public GetIamPolicy setUploadProtocol(String string) {
                return (GetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public GetIamPolicy set(String string, Object object) {
                return (GetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetEffectiveOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getEffectiveOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetEffectiveOrgPolicy(String string, GetEffectiveOrgPolicyRequest getEffectiveOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getEffectiveOrgPolicyRequest, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public GetEffectiveOrgPolicy set$Xgafv(String string) {
                return (GetEffectiveOrgPolicy)super.set$Xgafv(string);
            }

            public GetEffectiveOrgPolicy setAccessToken(String string) {
                return (GetEffectiveOrgPolicy)super.setAccessToken(string);
            }

            public GetEffectiveOrgPolicy setAlt(String string) {
                return (GetEffectiveOrgPolicy)super.setAlt(string);
            }

            public GetEffectiveOrgPolicy setBearerToken(String string) {
                return (GetEffectiveOrgPolicy)super.setBearerToken(string);
            }

            public GetEffectiveOrgPolicy setCallback(String string) {
                return (GetEffectiveOrgPolicy)super.setCallback(string);
            }

            public GetEffectiveOrgPolicy setFields(String string) {
                return (GetEffectiveOrgPolicy)super.setFields(string);
            }

            public GetEffectiveOrgPolicy setKey(String string) {
                return (GetEffectiveOrgPolicy)super.setKey(string);
            }

            public GetEffectiveOrgPolicy setOauthToken(String string) {
                return (GetEffectiveOrgPolicy)super.setOauthToken(string);
            }

            public GetEffectiveOrgPolicy setPp(Boolean bl) {
                return (GetEffectiveOrgPolicy)super.setPp(bl);
            }

            public GetEffectiveOrgPolicy setPrettyPrint(Boolean bl) {
                return (GetEffectiveOrgPolicy)super.setPrettyPrint(bl);
            }

            public GetEffectiveOrgPolicy setQuotaUser(String string) {
                return (GetEffectiveOrgPolicy)super.setQuotaUser(string);
            }

            public GetEffectiveOrgPolicy setUploadType(String string) {
                return (GetEffectiveOrgPolicy)super.setUploadType(string);
            }

            public GetEffectiveOrgPolicy setUploadProtocol(String string) {
                return (GetEffectiveOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetEffectiveOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public GetEffectiveOrgPolicy set(String string, Object object) {
                return (GetEffectiveOrgPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetAncestry
        extends CloudResourceManagerRequest<GetAncestryResponse> {
            private static final String REST_PATH = "v1/projects/{projectId}:getAncestry";
            @Key
            private String projectId;

            protected GetAncestry(String string, GetAncestryRequest getAncestryRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getAncestryRequest, GetAncestryResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public GetAncestry set$Xgafv(String string) {
                return (GetAncestry)super.set$Xgafv(string);
            }

            public GetAncestry setAccessToken(String string) {
                return (GetAncestry)super.setAccessToken(string);
            }

            public GetAncestry setAlt(String string) {
                return (GetAncestry)super.setAlt(string);
            }

            public GetAncestry setBearerToken(String string) {
                return (GetAncestry)super.setBearerToken(string);
            }

            public GetAncestry setCallback(String string) {
                return (GetAncestry)super.setCallback(string);
            }

            public GetAncestry setFields(String string) {
                return (GetAncestry)super.setFields(string);
            }

            public GetAncestry setKey(String string) {
                return (GetAncestry)super.setKey(string);
            }

            public GetAncestry setOauthToken(String string) {
                return (GetAncestry)super.setOauthToken(string);
            }

            public GetAncestry setPp(Boolean bl) {
                return (GetAncestry)super.setPp(bl);
            }

            public GetAncestry setPrettyPrint(Boolean bl) {
                return (GetAncestry)super.setPrettyPrint(bl);
            }

            public GetAncestry setQuotaUser(String string) {
                return (GetAncestry)super.setQuotaUser(string);
            }

            public GetAncestry setUploadType(String string) {
                return (GetAncestry)super.setUploadType(string);
            }

            public GetAncestry setUploadProtocol(String string) {
                return (GetAncestry)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetAncestry setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public GetAncestry set(String string, Object object) {
                return (GetAncestry)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1/projects/{projectId}";
            @Key
            private String projectId;

            protected Get(String string) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Project.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/projects/{projectId}";
            @Key
            private String projectId;

            protected Delete(String string) {
                super(CloudResourceManager.this, "DELETE", REST_PATH, null, Empty.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setBearerToken(String string) {
                return (Delete)super.setBearerToken(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPp(Boolean bl) {
                return (Delete)super.setPp(bl);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends CloudResourceManagerRequest<Operation> {
            private static final String REST_PATH = "v1/projects";

            protected Create(Project project) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)project, Operation.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setBearerToken(String string) {
                return (Create)super.setBearerToken(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPp(Boolean bl) {
                return (Create)super.setPp(bl);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ClearOrgPolicy
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/{+resource}:clearOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ClearOrgPolicy(String string, ClearOrgPolicyRequest clearOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)clearOrgPolicyRequest, Empty.class);
                this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
            }

            public ClearOrgPolicy set$Xgafv(String string) {
                return (ClearOrgPolicy)super.set$Xgafv(string);
            }

            public ClearOrgPolicy setAccessToken(String string) {
                return (ClearOrgPolicy)super.setAccessToken(string);
            }

            public ClearOrgPolicy setAlt(String string) {
                return (ClearOrgPolicy)super.setAlt(string);
            }

            public ClearOrgPolicy setBearerToken(String string) {
                return (ClearOrgPolicy)super.setBearerToken(string);
            }

            public ClearOrgPolicy setCallback(String string) {
                return (ClearOrgPolicy)super.setCallback(string);
            }

            public ClearOrgPolicy setFields(String string) {
                return (ClearOrgPolicy)super.setFields(string);
            }

            public ClearOrgPolicy setKey(String string) {
                return (ClearOrgPolicy)super.setKey(string);
            }

            public ClearOrgPolicy setOauthToken(String string) {
                return (ClearOrgPolicy)super.setOauthToken(string);
            }

            public ClearOrgPolicy setPp(Boolean bl) {
                return (ClearOrgPolicy)super.setPp(bl);
            }

            public ClearOrgPolicy setPrettyPrint(Boolean bl) {
                return (ClearOrgPolicy)super.setPrettyPrint(bl);
            }

            public ClearOrgPolicy setQuotaUser(String string) {
                return (ClearOrgPolicy)super.setQuotaUser(string);
            }

            public ClearOrgPolicy setUploadType(String string) {
                return (ClearOrgPolicy)super.setUploadType(string);
            }

            public ClearOrgPolicy setUploadProtocol(String string) {
                return (ClearOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public ClearOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public ClearOrgPolicy set(String string, Object object) {
                return (ClearOrgPolicy)super.set(string, object);
            }
        }
    }

    public class Organizations {
        public ClearOrgPolicy clearOrgPolicy(String string, ClearOrgPolicyRequest clearOrgPolicyRequest) throws IOException {
            ClearOrgPolicy clearOrgPolicy = new ClearOrgPolicy(string, clearOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)clearOrgPolicy);
            return clearOrgPolicy;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetEffectiveOrgPolicy getEffectiveOrgPolicy(String string, GetEffectiveOrgPolicyRequest getEffectiveOrgPolicyRequest) throws IOException {
            GetEffectiveOrgPolicy getEffectiveOrgPolicy = new GetEffectiveOrgPolicy(string, getEffectiveOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getEffectiveOrgPolicy);
            return getEffectiveOrgPolicy;
        }

        public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
            GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
            return getIamPolicy;
        }

        public GetOrgPolicy getOrgPolicy(String string, GetOrgPolicyRequest getOrgPolicyRequest) throws IOException {
            GetOrgPolicy getOrgPolicy = new GetOrgPolicy(string, getOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getOrgPolicy);
            return getOrgPolicy;
        }

        public ListAvailableOrgPolicyConstraints listAvailableOrgPolicyConstraints(String string, ListAvailableOrgPolicyConstraintsRequest listAvailableOrgPolicyConstraintsRequest) throws IOException {
            ListAvailableOrgPolicyConstraints listAvailableOrgPolicyConstraints = new ListAvailableOrgPolicyConstraints(string, listAvailableOrgPolicyConstraintsRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)listAvailableOrgPolicyConstraints);
            return listAvailableOrgPolicyConstraints;
        }

        public ListOrgPolicies listOrgPolicies(String string, ListOrgPoliciesRequest listOrgPoliciesRequest) throws IOException {
            ListOrgPolicies listOrgPolicies = new ListOrgPolicies(string, listOrgPoliciesRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)listOrgPolicies);
            return listOrgPolicies;
        }

        public Search search(SearchOrganizationsRequest searchOrganizationsRequest) throws IOException {
            Search search = new Search(searchOrganizationsRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)search);
            return search;
        }

        public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
            SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
            return setIamPolicy;
        }

        public SetOrgPolicy setOrgPolicy(String string, SetOrgPolicyRequest setOrgPolicyRequest) throws IOException {
            SetOrgPolicy setOrgPolicy = new SetOrgPolicy(string, setOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)setOrgPolicy);
            return setOrgPolicy;
        }

        public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
            TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
            return testIamPermissions;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TestIamPermissions
        extends CloudResourceManagerRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public TestIamPermissions set$Xgafv(String string) {
                return (TestIamPermissions)super.set$Xgafv(string);
            }

            public TestIamPermissions setAccessToken(String string) {
                return (TestIamPermissions)super.setAccessToken(string);
            }

            public TestIamPermissions setAlt(String string) {
                return (TestIamPermissions)super.setAlt(string);
            }

            public TestIamPermissions setBearerToken(String string) {
                return (TestIamPermissions)super.setBearerToken(string);
            }

            public TestIamPermissions setCallback(String string) {
                return (TestIamPermissions)super.setCallback(string);
            }

            public TestIamPermissions setFields(String string) {
                return (TestIamPermissions)super.setFields(string);
            }

            public TestIamPermissions setKey(String string) {
                return (TestIamPermissions)super.setKey(string);
            }

            public TestIamPermissions setOauthToken(String string) {
                return (TestIamPermissions)super.setOauthToken(string);
            }

            public TestIamPermissions setPp(Boolean bl) {
                return (TestIamPermissions)super.setPp(bl);
            }

            public TestIamPermissions setPrettyPrint(Boolean bl) {
                return (TestIamPermissions)super.setPrettyPrint(bl);
            }

            public TestIamPermissions setQuotaUser(String string) {
                return (TestIamPermissions)super.setQuotaUser(string);
            }

            public TestIamPermissions setUploadType(String string) {
                return (TestIamPermissions)super.setUploadType(string);
            }

            public TestIamPermissions setUploadProtocol(String string) {
                return (TestIamPermissions)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public TestIamPermissions set(String string, Object object) {
                return (TestIamPermissions)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:setOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetOrgPolicy(String string, SetOrgPolicyRequest setOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)setOrgPolicyRequest, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public SetOrgPolicy set$Xgafv(String string) {
                return (SetOrgPolicy)super.set$Xgafv(string);
            }

            public SetOrgPolicy setAccessToken(String string) {
                return (SetOrgPolicy)super.setAccessToken(string);
            }

            public SetOrgPolicy setAlt(String string) {
                return (SetOrgPolicy)super.setAlt(string);
            }

            public SetOrgPolicy setBearerToken(String string) {
                return (SetOrgPolicy)super.setBearerToken(string);
            }

            public SetOrgPolicy setCallback(String string) {
                return (SetOrgPolicy)super.setCallback(string);
            }

            public SetOrgPolicy setFields(String string) {
                return (SetOrgPolicy)super.setFields(string);
            }

            public SetOrgPolicy setKey(String string) {
                return (SetOrgPolicy)super.setKey(string);
            }

            public SetOrgPolicy setOauthToken(String string) {
                return (SetOrgPolicy)super.setOauthToken(string);
            }

            public SetOrgPolicy setPp(Boolean bl) {
                return (SetOrgPolicy)super.setPp(bl);
            }

            public SetOrgPolicy setPrettyPrint(Boolean bl) {
                return (SetOrgPolicy)super.setPrettyPrint(bl);
            }

            public SetOrgPolicy setQuotaUser(String string) {
                return (SetOrgPolicy)super.setQuotaUser(string);
            }

            public SetOrgPolicy setUploadType(String string) {
                return (SetOrgPolicy)super.setUploadType(string);
            }

            public SetOrgPolicy setUploadProtocol(String string) {
                return (SetOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public SetOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public SetOrgPolicy set(String string, Object object) {
                return (SetOrgPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public SetIamPolicy set$Xgafv(String string) {
                return (SetIamPolicy)super.set$Xgafv(string);
            }

            public SetIamPolicy setAccessToken(String string) {
                return (SetIamPolicy)super.setAccessToken(string);
            }

            public SetIamPolicy setAlt(String string) {
                return (SetIamPolicy)super.setAlt(string);
            }

            public SetIamPolicy setBearerToken(String string) {
                return (SetIamPolicy)super.setBearerToken(string);
            }

            public SetIamPolicy setCallback(String string) {
                return (SetIamPolicy)super.setCallback(string);
            }

            public SetIamPolicy setFields(String string) {
                return (SetIamPolicy)super.setFields(string);
            }

            public SetIamPolicy setKey(String string) {
                return (SetIamPolicy)super.setKey(string);
            }

            public SetIamPolicy setOauthToken(String string) {
                return (SetIamPolicy)super.setOauthToken(string);
            }

            public SetIamPolicy setPp(Boolean bl) {
                return (SetIamPolicy)super.setPp(bl);
            }

            public SetIamPolicy setPrettyPrint(Boolean bl) {
                return (SetIamPolicy)super.setPrettyPrint(bl);
            }

            public SetIamPolicy setQuotaUser(String string) {
                return (SetIamPolicy)super.setQuotaUser(string);
            }

            public SetIamPolicy setUploadType(String string) {
                return (SetIamPolicy)super.setUploadType(string);
            }

            public SetIamPolicy setUploadProtocol(String string) {
                return (SetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public SetIamPolicy set(String string, Object object) {
                return (SetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Search
        extends CloudResourceManagerRequest<SearchOrganizationsResponse> {
            private static final String REST_PATH = "v1/organizations:search";

            protected Search(SearchOrganizationsRequest searchOrganizationsRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)searchOrganizationsRequest, SearchOrganizationsResponse.class);
            }

            public Search set$Xgafv(String string) {
                return (Search)super.set$Xgafv(string);
            }

            public Search setAccessToken(String string) {
                return (Search)super.setAccessToken(string);
            }

            public Search setAlt(String string) {
                return (Search)super.setAlt(string);
            }

            public Search setBearerToken(String string) {
                return (Search)super.setBearerToken(string);
            }

            public Search setCallback(String string) {
                return (Search)super.setCallback(string);
            }

            public Search setFields(String string) {
                return (Search)super.setFields(string);
            }

            public Search setKey(String string) {
                return (Search)super.setKey(string);
            }

            public Search setOauthToken(String string) {
                return (Search)super.setOauthToken(string);
            }

            public Search setPp(Boolean bl) {
                return (Search)super.setPp(bl);
            }

            public Search setPrettyPrint(Boolean bl) {
                return (Search)super.setPrettyPrint(bl);
            }

            public Search setQuotaUser(String string) {
                return (Search)super.setQuotaUser(string);
            }

            public Search setUploadType(String string) {
                return (Search)super.setUploadType(string);
            }

            public Search setUploadProtocol(String string) {
                return (Search)super.setUploadProtocol(string);
            }

            @Override
            public Search set(String string, Object object) {
                return (Search)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListOrgPolicies
        extends CloudResourceManagerRequest<ListOrgPoliciesResponse> {
            private static final String REST_PATH = "v1/{+resource}:listOrgPolicies";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListOrgPolicies(String string, ListOrgPoliciesRequest listOrgPoliciesRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)listOrgPoliciesRequest, ListOrgPoliciesResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public ListOrgPolicies set$Xgafv(String string) {
                return (ListOrgPolicies)super.set$Xgafv(string);
            }

            public ListOrgPolicies setAccessToken(String string) {
                return (ListOrgPolicies)super.setAccessToken(string);
            }

            public ListOrgPolicies setAlt(String string) {
                return (ListOrgPolicies)super.setAlt(string);
            }

            public ListOrgPolicies setBearerToken(String string) {
                return (ListOrgPolicies)super.setBearerToken(string);
            }

            public ListOrgPolicies setCallback(String string) {
                return (ListOrgPolicies)super.setCallback(string);
            }

            public ListOrgPolicies setFields(String string) {
                return (ListOrgPolicies)super.setFields(string);
            }

            public ListOrgPolicies setKey(String string) {
                return (ListOrgPolicies)super.setKey(string);
            }

            public ListOrgPolicies setOauthToken(String string) {
                return (ListOrgPolicies)super.setOauthToken(string);
            }

            public ListOrgPolicies setPp(Boolean bl) {
                return (ListOrgPolicies)super.setPp(bl);
            }

            public ListOrgPolicies setPrettyPrint(Boolean bl) {
                return (ListOrgPolicies)super.setPrettyPrint(bl);
            }

            public ListOrgPolicies setQuotaUser(String string) {
                return (ListOrgPolicies)super.setQuotaUser(string);
            }

            public ListOrgPolicies setUploadType(String string) {
                return (ListOrgPolicies)super.setUploadType(string);
            }

            public ListOrgPolicies setUploadProtocol(String string) {
                return (ListOrgPolicies)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public ListOrgPolicies setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public ListOrgPolicies set(String string, Object object) {
                return (ListOrgPolicies)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListAvailableOrgPolicyConstraints
        extends CloudResourceManagerRequest<ListAvailableOrgPolicyConstraintsResponse> {
            private static final String REST_PATH = "v1/{+resource}:listAvailableOrgPolicyConstraints";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListAvailableOrgPolicyConstraints(String string, ListAvailableOrgPolicyConstraintsRequest listAvailableOrgPolicyConstraintsRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)listAvailableOrgPolicyConstraintsRequest, ListAvailableOrgPolicyConstraintsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public ListAvailableOrgPolicyConstraints set$Xgafv(String string) {
                return (ListAvailableOrgPolicyConstraints)super.set$Xgafv(string);
            }

            public ListAvailableOrgPolicyConstraints setAccessToken(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setAccessToken(string);
            }

            public ListAvailableOrgPolicyConstraints setAlt(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setAlt(string);
            }

            public ListAvailableOrgPolicyConstraints setBearerToken(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setBearerToken(string);
            }

            public ListAvailableOrgPolicyConstraints setCallback(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setCallback(string);
            }

            public ListAvailableOrgPolicyConstraints setFields(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setFields(string);
            }

            public ListAvailableOrgPolicyConstraints setKey(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setKey(string);
            }

            public ListAvailableOrgPolicyConstraints setOauthToken(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setOauthToken(string);
            }

            public ListAvailableOrgPolicyConstraints setPp(Boolean bl) {
                return (ListAvailableOrgPolicyConstraints)super.setPp(bl);
            }

            public ListAvailableOrgPolicyConstraints setPrettyPrint(Boolean bl) {
                return (ListAvailableOrgPolicyConstraints)super.setPrettyPrint(bl);
            }

            public ListAvailableOrgPolicyConstraints setQuotaUser(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setQuotaUser(string);
            }

            public ListAvailableOrgPolicyConstraints setUploadType(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadType(string);
            }

            public ListAvailableOrgPolicyConstraints setUploadProtocol(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public ListAvailableOrgPolicyConstraints setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public ListAvailableOrgPolicyConstraints set(String string, Object object) {
                return (ListAvailableOrgPolicyConstraints)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetOrgPolicy(String string, GetOrgPolicyRequest getOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getOrgPolicyRequest, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public GetOrgPolicy set$Xgafv(String string) {
                return (GetOrgPolicy)super.set$Xgafv(string);
            }

            public GetOrgPolicy setAccessToken(String string) {
                return (GetOrgPolicy)super.setAccessToken(string);
            }

            public GetOrgPolicy setAlt(String string) {
                return (GetOrgPolicy)super.setAlt(string);
            }

            public GetOrgPolicy setBearerToken(String string) {
                return (GetOrgPolicy)super.setBearerToken(string);
            }

            public GetOrgPolicy setCallback(String string) {
                return (GetOrgPolicy)super.setCallback(string);
            }

            public GetOrgPolicy setFields(String string) {
                return (GetOrgPolicy)super.setFields(string);
            }

            public GetOrgPolicy setKey(String string) {
                return (GetOrgPolicy)super.setKey(string);
            }

            public GetOrgPolicy setOauthToken(String string) {
                return (GetOrgPolicy)super.setOauthToken(string);
            }

            public GetOrgPolicy setPp(Boolean bl) {
                return (GetOrgPolicy)super.setPp(bl);
            }

            public GetOrgPolicy setPrettyPrint(Boolean bl) {
                return (GetOrgPolicy)super.setPrettyPrint(bl);
            }

            public GetOrgPolicy setQuotaUser(String string) {
                return (GetOrgPolicy)super.setQuotaUser(string);
            }

            public GetOrgPolicy setUploadType(String string) {
                return (GetOrgPolicy)super.setUploadType(string);
            }

            public GetOrgPolicy setUploadProtocol(String string) {
                return (GetOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public GetOrgPolicy set(String string, Object object) {
                return (GetOrgPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public GetIamPolicy set$Xgafv(String string) {
                return (GetIamPolicy)super.set$Xgafv(string);
            }

            public GetIamPolicy setAccessToken(String string) {
                return (GetIamPolicy)super.setAccessToken(string);
            }

            public GetIamPolicy setAlt(String string) {
                return (GetIamPolicy)super.setAlt(string);
            }

            public GetIamPolicy setBearerToken(String string) {
                return (GetIamPolicy)super.setBearerToken(string);
            }

            public GetIamPolicy setCallback(String string) {
                return (GetIamPolicy)super.setCallback(string);
            }

            public GetIamPolicy setFields(String string) {
                return (GetIamPolicy)super.setFields(string);
            }

            public GetIamPolicy setKey(String string) {
                return (GetIamPolicy)super.setKey(string);
            }

            public GetIamPolicy setOauthToken(String string) {
                return (GetIamPolicy)super.setOauthToken(string);
            }

            public GetIamPolicy setPp(Boolean bl) {
                return (GetIamPolicy)super.setPp(bl);
            }

            public GetIamPolicy setPrettyPrint(Boolean bl) {
                return (GetIamPolicy)super.setPrettyPrint(bl);
            }

            public GetIamPolicy setQuotaUser(String string) {
                return (GetIamPolicy)super.setQuotaUser(string);
            }

            public GetIamPolicy setUploadType(String string) {
                return (GetIamPolicy)super.setUploadType(string);
            }

            public GetIamPolicy setUploadProtocol(String string) {
                return (GetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public GetIamPolicy set(String string, Object object) {
                return (GetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetEffectiveOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getEffectiveOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetEffectiveOrgPolicy(String string, GetEffectiveOrgPolicyRequest getEffectiveOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getEffectiveOrgPolicyRequest, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public GetEffectiveOrgPolicy set$Xgafv(String string) {
                return (GetEffectiveOrgPolicy)super.set$Xgafv(string);
            }

            public GetEffectiveOrgPolicy setAccessToken(String string) {
                return (GetEffectiveOrgPolicy)super.setAccessToken(string);
            }

            public GetEffectiveOrgPolicy setAlt(String string) {
                return (GetEffectiveOrgPolicy)super.setAlt(string);
            }

            public GetEffectiveOrgPolicy setBearerToken(String string) {
                return (GetEffectiveOrgPolicy)super.setBearerToken(string);
            }

            public GetEffectiveOrgPolicy setCallback(String string) {
                return (GetEffectiveOrgPolicy)super.setCallback(string);
            }

            public GetEffectiveOrgPolicy setFields(String string) {
                return (GetEffectiveOrgPolicy)super.setFields(string);
            }

            public GetEffectiveOrgPolicy setKey(String string) {
                return (GetEffectiveOrgPolicy)super.setKey(string);
            }

            public GetEffectiveOrgPolicy setOauthToken(String string) {
                return (GetEffectiveOrgPolicy)super.setOauthToken(string);
            }

            public GetEffectiveOrgPolicy setPp(Boolean bl) {
                return (GetEffectiveOrgPolicy)super.setPp(bl);
            }

            public GetEffectiveOrgPolicy setPrettyPrint(Boolean bl) {
                return (GetEffectiveOrgPolicy)super.setPrettyPrint(bl);
            }

            public GetEffectiveOrgPolicy setQuotaUser(String string) {
                return (GetEffectiveOrgPolicy)super.setQuotaUser(string);
            }

            public GetEffectiveOrgPolicy setUploadType(String string) {
                return (GetEffectiveOrgPolicy)super.setUploadType(string);
            }

            public GetEffectiveOrgPolicy setUploadProtocol(String string) {
                return (GetEffectiveOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetEffectiveOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public GetEffectiveOrgPolicy set(String string, Object object) {
                return (GetEffectiveOrgPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CloudResourceManagerRequest<Organization> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Organization.class);
                this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ClearOrgPolicy
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/{+resource}:clearOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ClearOrgPolicy(String string, ClearOrgPolicyRequest clearOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)clearOrgPolicyRequest, Empty.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public ClearOrgPolicy set$Xgafv(String string) {
                return (ClearOrgPolicy)super.set$Xgafv(string);
            }

            public ClearOrgPolicy setAccessToken(String string) {
                return (ClearOrgPolicy)super.setAccessToken(string);
            }

            public ClearOrgPolicy setAlt(String string) {
                return (ClearOrgPolicy)super.setAlt(string);
            }

            public ClearOrgPolicy setBearerToken(String string) {
                return (ClearOrgPolicy)super.setBearerToken(string);
            }

            public ClearOrgPolicy setCallback(String string) {
                return (ClearOrgPolicy)super.setCallback(string);
            }

            public ClearOrgPolicy setFields(String string) {
                return (ClearOrgPolicy)super.setFields(string);
            }

            public ClearOrgPolicy setKey(String string) {
                return (ClearOrgPolicy)super.setKey(string);
            }

            public ClearOrgPolicy setOauthToken(String string) {
                return (ClearOrgPolicy)super.setOauthToken(string);
            }

            public ClearOrgPolicy setPp(Boolean bl) {
                return (ClearOrgPolicy)super.setPp(bl);
            }

            public ClearOrgPolicy setPrettyPrint(Boolean bl) {
                return (ClearOrgPolicy)super.setPrettyPrint(bl);
            }

            public ClearOrgPolicy setQuotaUser(String string) {
                return (ClearOrgPolicy)super.setQuotaUser(string);
            }

            public ClearOrgPolicy setUploadType(String string) {
                return (ClearOrgPolicy)super.setUploadType(string);
            }

            public ClearOrgPolicy setUploadProtocol(String string) {
                return (ClearOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public ClearOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public ClearOrgPolicy set(String string, Object object) {
                return (ClearOrgPolicy)super.set(string, object);
            }
        }
    }

    public class Operations {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends CloudResourceManagerRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Liens {
        public Create create(Lien lien) throws IOException {
            Create create = new Create(lien);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public List list() throws IOException {
            List list = new List();
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends CloudResourceManagerRequest<ListLiensResponse> {
            private static final String REST_PATH = "v1/liens";
            @Key
            private String parent;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List() {
                super(CloudResourceManager.this, "GET", REST_PATH, null, ListLiensResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String string) {
                this.parent = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String string) {
                super(CloudResourceManager.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^liens/.+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^liens/.+$");
                }
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setBearerToken(String string) {
                return (Delete)super.setBearerToken(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPp(Boolean bl) {
                return (Delete)super.setPp(bl);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^liens/.+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends CloudResourceManagerRequest<Lien> {
            private static final String REST_PATH = "v1/liens";

            protected Create(Lien lien) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)lien, Lien.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setBearerToken(String string) {
                return (Create)super.setBearerToken(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPp(Boolean bl) {
                return (Create)super.setPp(bl);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Folders {
        public ClearOrgPolicy clearOrgPolicy(String string, ClearOrgPolicyRequest clearOrgPolicyRequest) throws IOException {
            ClearOrgPolicy clearOrgPolicy = new ClearOrgPolicy(string, clearOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)clearOrgPolicy);
            return clearOrgPolicy;
        }

        public GetEffectiveOrgPolicy getEffectiveOrgPolicy(String string, GetEffectiveOrgPolicyRequest getEffectiveOrgPolicyRequest) throws IOException {
            GetEffectiveOrgPolicy getEffectiveOrgPolicy = new GetEffectiveOrgPolicy(string, getEffectiveOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getEffectiveOrgPolicy);
            return getEffectiveOrgPolicy;
        }

        public GetOrgPolicy getOrgPolicy(String string, GetOrgPolicyRequest getOrgPolicyRequest) throws IOException {
            GetOrgPolicy getOrgPolicy = new GetOrgPolicy(string, getOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)getOrgPolicy);
            return getOrgPolicy;
        }

        public ListAvailableOrgPolicyConstraints listAvailableOrgPolicyConstraints(String string, ListAvailableOrgPolicyConstraintsRequest listAvailableOrgPolicyConstraintsRequest) throws IOException {
            ListAvailableOrgPolicyConstraints listAvailableOrgPolicyConstraints = new ListAvailableOrgPolicyConstraints(string, listAvailableOrgPolicyConstraintsRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)listAvailableOrgPolicyConstraints);
            return listAvailableOrgPolicyConstraints;
        }

        public ListOrgPolicies listOrgPolicies(String string, ListOrgPoliciesRequest listOrgPoliciesRequest) throws IOException {
            ListOrgPolicies listOrgPolicies = new ListOrgPolicies(string, listOrgPoliciesRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)listOrgPolicies);
            return listOrgPolicies;
        }

        public SetOrgPolicy setOrgPolicy(String string, SetOrgPolicyRequest setOrgPolicyRequest) throws IOException {
            SetOrgPolicy setOrgPolicy = new SetOrgPolicy(string, setOrgPolicyRequest);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)setOrgPolicy);
            return setOrgPolicy;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:setOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetOrgPolicy(String string, SetOrgPolicyRequest setOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)setOrgPolicyRequest, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public SetOrgPolicy set$Xgafv(String string) {
                return (SetOrgPolicy)super.set$Xgafv(string);
            }

            public SetOrgPolicy setAccessToken(String string) {
                return (SetOrgPolicy)super.setAccessToken(string);
            }

            public SetOrgPolicy setAlt(String string) {
                return (SetOrgPolicy)super.setAlt(string);
            }

            public SetOrgPolicy setBearerToken(String string) {
                return (SetOrgPolicy)super.setBearerToken(string);
            }

            public SetOrgPolicy setCallback(String string) {
                return (SetOrgPolicy)super.setCallback(string);
            }

            public SetOrgPolicy setFields(String string) {
                return (SetOrgPolicy)super.setFields(string);
            }

            public SetOrgPolicy setKey(String string) {
                return (SetOrgPolicy)super.setKey(string);
            }

            public SetOrgPolicy setOauthToken(String string) {
                return (SetOrgPolicy)super.setOauthToken(string);
            }

            public SetOrgPolicy setPp(Boolean bl) {
                return (SetOrgPolicy)super.setPp(bl);
            }

            public SetOrgPolicy setPrettyPrint(Boolean bl) {
                return (SetOrgPolicy)super.setPrettyPrint(bl);
            }

            public SetOrgPolicy setQuotaUser(String string) {
                return (SetOrgPolicy)super.setQuotaUser(string);
            }

            public SetOrgPolicy setUploadType(String string) {
                return (SetOrgPolicy)super.setUploadType(string);
            }

            public SetOrgPolicy setUploadProtocol(String string) {
                return (SetOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public SetOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public SetOrgPolicy set(String string, Object object) {
                return (SetOrgPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListOrgPolicies
        extends CloudResourceManagerRequest<ListOrgPoliciesResponse> {
            private static final String REST_PATH = "v1/{+resource}:listOrgPolicies";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListOrgPolicies(String string, ListOrgPoliciesRequest listOrgPoliciesRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)listOrgPoliciesRequest, ListOrgPoliciesResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public ListOrgPolicies set$Xgafv(String string) {
                return (ListOrgPolicies)super.set$Xgafv(string);
            }

            public ListOrgPolicies setAccessToken(String string) {
                return (ListOrgPolicies)super.setAccessToken(string);
            }

            public ListOrgPolicies setAlt(String string) {
                return (ListOrgPolicies)super.setAlt(string);
            }

            public ListOrgPolicies setBearerToken(String string) {
                return (ListOrgPolicies)super.setBearerToken(string);
            }

            public ListOrgPolicies setCallback(String string) {
                return (ListOrgPolicies)super.setCallback(string);
            }

            public ListOrgPolicies setFields(String string) {
                return (ListOrgPolicies)super.setFields(string);
            }

            public ListOrgPolicies setKey(String string) {
                return (ListOrgPolicies)super.setKey(string);
            }

            public ListOrgPolicies setOauthToken(String string) {
                return (ListOrgPolicies)super.setOauthToken(string);
            }

            public ListOrgPolicies setPp(Boolean bl) {
                return (ListOrgPolicies)super.setPp(bl);
            }

            public ListOrgPolicies setPrettyPrint(Boolean bl) {
                return (ListOrgPolicies)super.setPrettyPrint(bl);
            }

            public ListOrgPolicies setQuotaUser(String string) {
                return (ListOrgPolicies)super.setQuotaUser(string);
            }

            public ListOrgPolicies setUploadType(String string) {
                return (ListOrgPolicies)super.setUploadType(string);
            }

            public ListOrgPolicies setUploadProtocol(String string) {
                return (ListOrgPolicies)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public ListOrgPolicies setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public ListOrgPolicies set(String string, Object object) {
                return (ListOrgPolicies)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListAvailableOrgPolicyConstraints
        extends CloudResourceManagerRequest<ListAvailableOrgPolicyConstraintsResponse> {
            private static final String REST_PATH = "v1/{+resource}:listAvailableOrgPolicyConstraints";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ListAvailableOrgPolicyConstraints(String string, ListAvailableOrgPolicyConstraintsRequest listAvailableOrgPolicyConstraintsRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)listAvailableOrgPolicyConstraintsRequest, ListAvailableOrgPolicyConstraintsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public ListAvailableOrgPolicyConstraints set$Xgafv(String string) {
                return (ListAvailableOrgPolicyConstraints)super.set$Xgafv(string);
            }

            public ListAvailableOrgPolicyConstraints setAccessToken(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setAccessToken(string);
            }

            public ListAvailableOrgPolicyConstraints setAlt(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setAlt(string);
            }

            public ListAvailableOrgPolicyConstraints setBearerToken(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setBearerToken(string);
            }

            public ListAvailableOrgPolicyConstraints setCallback(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setCallback(string);
            }

            public ListAvailableOrgPolicyConstraints setFields(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setFields(string);
            }

            public ListAvailableOrgPolicyConstraints setKey(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setKey(string);
            }

            public ListAvailableOrgPolicyConstraints setOauthToken(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setOauthToken(string);
            }

            public ListAvailableOrgPolicyConstraints setPp(Boolean bl) {
                return (ListAvailableOrgPolicyConstraints)super.setPp(bl);
            }

            public ListAvailableOrgPolicyConstraints setPrettyPrint(Boolean bl) {
                return (ListAvailableOrgPolicyConstraints)super.setPrettyPrint(bl);
            }

            public ListAvailableOrgPolicyConstraints setQuotaUser(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setQuotaUser(string);
            }

            public ListAvailableOrgPolicyConstraints setUploadType(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadType(string);
            }

            public ListAvailableOrgPolicyConstraints setUploadProtocol(String string) {
                return (ListAvailableOrgPolicyConstraints)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public ListAvailableOrgPolicyConstraints setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public ListAvailableOrgPolicyConstraints set(String string, Object object) {
                return (ListAvailableOrgPolicyConstraints)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetOrgPolicy(String string, GetOrgPolicyRequest getOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getOrgPolicyRequest, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public GetOrgPolicy set$Xgafv(String string) {
                return (GetOrgPolicy)super.set$Xgafv(string);
            }

            public GetOrgPolicy setAccessToken(String string) {
                return (GetOrgPolicy)super.setAccessToken(string);
            }

            public GetOrgPolicy setAlt(String string) {
                return (GetOrgPolicy)super.setAlt(string);
            }

            public GetOrgPolicy setBearerToken(String string) {
                return (GetOrgPolicy)super.setBearerToken(string);
            }

            public GetOrgPolicy setCallback(String string) {
                return (GetOrgPolicy)super.setCallback(string);
            }

            public GetOrgPolicy setFields(String string) {
                return (GetOrgPolicy)super.setFields(string);
            }

            public GetOrgPolicy setKey(String string) {
                return (GetOrgPolicy)super.setKey(string);
            }

            public GetOrgPolicy setOauthToken(String string) {
                return (GetOrgPolicy)super.setOauthToken(string);
            }

            public GetOrgPolicy setPp(Boolean bl) {
                return (GetOrgPolicy)super.setPp(bl);
            }

            public GetOrgPolicy setPrettyPrint(Boolean bl) {
                return (GetOrgPolicy)super.setPrettyPrint(bl);
            }

            public GetOrgPolicy setQuotaUser(String string) {
                return (GetOrgPolicy)super.setQuotaUser(string);
            }

            public GetOrgPolicy setUploadType(String string) {
                return (GetOrgPolicy)super.setUploadType(string);
            }

            public GetOrgPolicy setUploadProtocol(String string) {
                return (GetOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public GetOrgPolicy set(String string, Object object) {
                return (GetOrgPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetEffectiveOrgPolicy
        extends CloudResourceManagerRequest<OrgPolicy> {
            private static final String REST_PATH = "v1/{+resource}:getEffectiveOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetEffectiveOrgPolicy(String string, GetEffectiveOrgPolicyRequest getEffectiveOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)getEffectiveOrgPolicyRequest, OrgPolicy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public GetEffectiveOrgPolicy set$Xgafv(String string) {
                return (GetEffectiveOrgPolicy)super.set$Xgafv(string);
            }

            public GetEffectiveOrgPolicy setAccessToken(String string) {
                return (GetEffectiveOrgPolicy)super.setAccessToken(string);
            }

            public GetEffectiveOrgPolicy setAlt(String string) {
                return (GetEffectiveOrgPolicy)super.setAlt(string);
            }

            public GetEffectiveOrgPolicy setBearerToken(String string) {
                return (GetEffectiveOrgPolicy)super.setBearerToken(string);
            }

            public GetEffectiveOrgPolicy setCallback(String string) {
                return (GetEffectiveOrgPolicy)super.setCallback(string);
            }

            public GetEffectiveOrgPolicy setFields(String string) {
                return (GetEffectiveOrgPolicy)super.setFields(string);
            }

            public GetEffectiveOrgPolicy setKey(String string) {
                return (GetEffectiveOrgPolicy)super.setKey(string);
            }

            public GetEffectiveOrgPolicy setOauthToken(String string) {
                return (GetEffectiveOrgPolicy)super.setOauthToken(string);
            }

            public GetEffectiveOrgPolicy setPp(Boolean bl) {
                return (GetEffectiveOrgPolicy)super.setPp(bl);
            }

            public GetEffectiveOrgPolicy setPrettyPrint(Boolean bl) {
                return (GetEffectiveOrgPolicy)super.setPrettyPrint(bl);
            }

            public GetEffectiveOrgPolicy setQuotaUser(String string) {
                return (GetEffectiveOrgPolicy)super.setQuotaUser(string);
            }

            public GetEffectiveOrgPolicy setUploadType(String string) {
                return (GetEffectiveOrgPolicy)super.setUploadType(string);
            }

            public GetEffectiveOrgPolicy setUploadProtocol(String string) {
                return (GetEffectiveOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetEffectiveOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public GetEffectiveOrgPolicy set(String string, Object object) {
                return (GetEffectiveOrgPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ClearOrgPolicy
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1/{+resource}:clearOrgPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected ClearOrgPolicy(String string, ClearOrgPolicyRequest clearOrgPolicyRequest) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)clearOrgPolicyRequest, Empty.class);
                this.RESOURCE_PATTERN = Pattern.compile("^folders/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
            }

            public ClearOrgPolicy set$Xgafv(String string) {
                return (ClearOrgPolicy)super.set$Xgafv(string);
            }

            public ClearOrgPolicy setAccessToken(String string) {
                return (ClearOrgPolicy)super.setAccessToken(string);
            }

            public ClearOrgPolicy setAlt(String string) {
                return (ClearOrgPolicy)super.setAlt(string);
            }

            public ClearOrgPolicy setBearerToken(String string) {
                return (ClearOrgPolicy)super.setBearerToken(string);
            }

            public ClearOrgPolicy setCallback(String string) {
                return (ClearOrgPolicy)super.setCallback(string);
            }

            public ClearOrgPolicy setFields(String string) {
                return (ClearOrgPolicy)super.setFields(string);
            }

            public ClearOrgPolicy setKey(String string) {
                return (ClearOrgPolicy)super.setKey(string);
            }

            public ClearOrgPolicy setOauthToken(String string) {
                return (ClearOrgPolicy)super.setOauthToken(string);
            }

            public ClearOrgPolicy setPp(Boolean bl) {
                return (ClearOrgPolicy)super.setPp(bl);
            }

            public ClearOrgPolicy setPrettyPrint(Boolean bl) {
                return (ClearOrgPolicy)super.setPrettyPrint(bl);
            }

            public ClearOrgPolicy setQuotaUser(String string) {
                return (ClearOrgPolicy)super.setQuotaUser(string);
            }

            public ClearOrgPolicy setUploadType(String string) {
                return (ClearOrgPolicy)super.setUploadType(string);
            }

            public ClearOrgPolicy setUploadProtocol(String string) {
                return (ClearOrgPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public ClearOrgPolicy setResource(String string) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^folders/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public ClearOrgPolicy set(String string, Object object) {
                return (ClearOrgPolicy)super.set(string, object);
            }
        }
    }
}

