/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-30 at 19:00:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dns;

/**
 * Service definition for Dns (v1).
 *
 * <p>
 * Configures and serves authoritative DNS records.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/cloud-dns" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DnsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Dns extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.23.0 of the Google Cloud DNS API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "dns/v1/projects/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/dns/v1";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Dns(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Dns(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Changes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.Changes.List request = dns.changes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Changes changes() {
    return new Changes();
  }

  /**
   * The "changes" collection of methods.
   */
  public class Changes {

    /**
     * Atomically update the ResourceRecordSet collection.
     *
     * Create a request for the method "changes.create".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
     * @param content the {@link com.google.api.services.dns.model.Change}
     * @return the request
     */
    public Create create(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.Change content) throws java.io.IOException {
      Create result = new Create(project, managedZone, content);
      initialize(result);
      return result;
    }

    public class Create extends DnsRequest<com.google.api.services.dns.model.Change> {

      private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes";

      /**
       * Atomically update the ResourceRecordSet collection.
       *
       * Create a request for the method "changes.create".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       * @param content the {@link com.google.api.services.dns.model.Change}
       * @since 1.13
       */
      protected Create(java.lang.String project, java.lang.String managedZone, com.google.api.services.dns.model.Change content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.Change.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUserIp(java.lang.String userIp) {
        return (Create) super.setUserIp(userIp);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Create setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public Create setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Fetch the representation of an existing Change.
     *
     * Create a request for the method "changes.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
     * @param changeId The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String managedZone, java.lang.String changeId) throws java.io.IOException {
      Get result = new Get(project, managedZone, changeId);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.Change> {

      private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes/{changeId}";

      /**
       * Fetch the representation of an existing Change.
       *
       * Create a request for the method "changes.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       * @param changeId The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String managedZone, java.lang.String changeId) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.Change.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
        this.changeId = com.google.api.client.util.Preconditions.checkNotNull(changeId, "Required parameter changeId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public Get setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
       */
      @com.google.api.client.util.Key
      private java.lang.String changeId;

      /** The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
       */
      public java.lang.String getChangeId() {
        return changeId;
      }

      /**
       * The identifier of the requested change, from a previous ResourceRecordSetsChangeResponse.
       */
      public Get setChangeId(java.lang.String changeId) {
        this.changeId = changeId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Enumerate Changes to a ResourceRecordSet collection.
     *
     * Create a request for the method "changes.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      List result = new List(project, managedZone);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.ChangesListResponse> {

      private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes";

      /**
       * Enumerate Changes to a ResourceRecordSet collection.
       *
       * Create a request for the method "changes.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ChangesListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public List setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server will decide
       * how many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server will decide how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server will decide
       * how many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Sorting criterion. The only supported value is change sequence. */
      @com.google.api.client.util.Key
      private java.lang.String sortBy;

      /** Sorting criterion. The only supported value is change sequence. [default: changeSequence]
       */
      public java.lang.String getSortBy() {
        return sortBy;
      }

      /** Sorting criterion. The only supported value is change sequence. */
      public List setSortBy(java.lang.String sortBy) {
        this.sortBy = sortBy;
        return this;
      }

      /** Sorting order direction: 'ascending' or 'descending'. */
      @com.google.api.client.util.Key
      private java.lang.String sortOrder;

      /** Sorting order direction: 'ascending' or 'descending'.
       */
      public java.lang.String getSortOrder() {
        return sortOrder;
      }

      /** Sorting order direction: 'ascending' or 'descending'. */
      public List setSortOrder(java.lang.String sortOrder) {
        this.sortOrder = sortOrder;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ManagedZones collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.ManagedZones.List request = dns.managedZones().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ManagedZones managedZones() {
    return new ManagedZones();
  }

  /**
   * The "managedZones" collection of methods.
   */
  public class ManagedZones {

    /**
     * Create a new ManagedZone.
     *
     * Create a request for the method "managedZones.create".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param content the {@link com.google.api.services.dns.model.ManagedZone}
     * @return the request
     */
    public Create create(java.lang.String project, com.google.api.services.dns.model.ManagedZone content) throws java.io.IOException {
      Create result = new Create(project, content);
      initialize(result);
      return result;
    }

    public class Create extends DnsRequest<com.google.api.services.dns.model.ManagedZone> {

      private static final String REST_PATH = "{project}/managedZones";

      /**
       * Create a new ManagedZone.
       *
       * Create a request for the method "managedZones.create".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param content the {@link com.google.api.services.dns.model.ManagedZone}
       * @since 1.13
       */
      protected Create(java.lang.String project, com.google.api.services.dns.model.ManagedZone content) {
        super(Dns.this, "POST", REST_PATH, content, com.google.api.services.dns.model.ManagedZone.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUserIp(java.lang.String userIp) {
        return (Create) super.setUserIp(userIp);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Create setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Delete a previously created ManagedZone.
     *
     * Create a request for the method "managedZones.delete".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      Delete result = new Delete(project, managedZone);
      initialize(result);
      return result;
    }

    public class Delete extends DnsRequest<Void> {

      private static final String REST_PATH = "{project}/managedZones/{managedZone}";

      /**
       * Delete a previously created ManagedZone.
       *
       * Create a request for the method "managedZones.delete".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Delete setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public Delete setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Fetch the representation of an existing ManagedZone.
     *
     * Create a request for the method "managedZones.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      Get result = new Get(project, managedZone);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.ManagedZone> {

      private static final String REST_PATH = "{project}/managedZones/{managedZone}";

      /**
       * Fetch the representation of an existing ManagedZone.
       *
       * Create a request for the method "managedZones.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ManagedZone.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public Get setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Enumerate ManagedZones that have been created but not yet deleted.
     *
     * Create a request for the method "managedZones.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.ManagedZonesListResponse> {

      private static final String REST_PATH = "{project}/managedZones";

      /**
       * Enumerate ManagedZones that have been created but not yet deleted.
       *
       * Create a request for the method "managedZones.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ManagedZonesListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Restricts the list to return only zones with this domain name. */
      @com.google.api.client.util.Key
      private java.lang.String dnsName;

      /** Restricts the list to return only zones with this domain name.
       */
      public java.lang.String getDnsName() {
        return dnsName;
      }

      /** Restricts the list to return only zones with this domain name. */
      public List setDnsName(java.lang.String dnsName) {
        this.dnsName = dnsName;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server will decide
       * how many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server will decide how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server will decide
       * how many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.Projects.List request = dns.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Fetch the representation of an existing Project.
     *
     * Create a request for the method "projects.get".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @return the request
     */
    public Get get(java.lang.String project) throws java.io.IOException {
      Get result = new Get(project);
      initialize(result);
      return result;
    }

    public class Get extends DnsRequest<com.google.api.services.dns.model.Project> {

      private static final String REST_PATH = "{project}";

      /**
       * Fetch the representation of an existing Project.
       *
       * Create a request for the method "projects.get".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @since 1.13
       */
      protected Get(java.lang.String project) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.Project.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public Get setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ResourceRecordSets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dns dns = new Dns(...);}
   *   {@code Dns.ResourceRecordSets.List request = dns.resourceRecordSets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ResourceRecordSets resourceRecordSets() {
    return new ResourceRecordSets();
  }

  /**
   * The "resourceRecordSets" collection of methods.
   */
  public class ResourceRecordSets {

    /**
     * Enumerate ResourceRecordSets that have been created but not yet deleted.
     *
     * Create a request for the method "resourceRecordSets.list".
     *
     * This request holds the parameters needed by the dns server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Identifies the project addressed by this request.
     * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String managedZone) throws java.io.IOException {
      List result = new List(project, managedZone);
      initialize(result);
      return result;
    }

    public class List extends DnsRequest<com.google.api.services.dns.model.ResourceRecordSetsListResponse> {

      private static final String REST_PATH = "{project}/managedZones/{managedZone}/rrsets";

      /**
       * Enumerate ResourceRecordSets that have been created but not yet deleted.
       *
       * Create a request for the method "resourceRecordSets.list".
       *
       * This request holds the parameters needed by the the dns server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Identifies the project addressed by this request.
       * @param managedZone Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String managedZone) {
        super(Dns.this, "GET", REST_PATH, null, com.google.api.services.dns.model.ResourceRecordSetsListResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        this.managedZone = com.google.api.client.util.Preconditions.checkNotNull(managedZone, "Required parameter managedZone must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Identifies the project addressed by this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Identifies the project addressed by this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Identifies the project addressed by this request. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      @com.google.api.client.util.Key
      private java.lang.String managedZone;

      /** Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public java.lang.String getManagedZone() {
        return managedZone;
      }

      /**
       * Identifies the managed zone addressed by this request. Can be the managed zone name or id.
       */
      public List setManagedZone(java.lang.String managedZone) {
        this.managedZone = managedZone;
        return this;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server will decide
       * how many results to return.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Optional. Maximum number of results to be returned. If unspecified, the server will decide how many
     results to return.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum number of results to be returned. If unspecified, the server will decide
       * how many results to return.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Restricts the list to return only records with this fully qualified domain name. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Restricts the list to return only records with this fully qualified domain name.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Restricts the list to return only records with this fully qualified domain name. */
      public List setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A tag returned by a previous list request that was truncated. Use this parameter to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A tag returned by a previous list request that was truncated. Use this parameter
       * to continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Restricts the list to return only records of this type. If present, the "name" parameter
       * must also be present.
       */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /** Restricts the list to return only records of this type. If present, the "name" parameter must also
     be present.
       */
      public java.lang.String getType() {
        return type;
      }

      /**
       * Restricts the list to return only records of this type. If present, the "name" parameter
       * must also be present.
       */
      public List setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Dns}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Dns}. */
    @Override
    public Dns build() {
      return new Dns(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DnsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDnsRequestInitializer(
        DnsRequestInitializer dnsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(dnsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
