/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-30 at 19:00:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * The response to a request to enumerate Changes to a ResourceRecordSets collection.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChangesListResponse extends com.google.api.client.json.GenericJson {

  /**
   * The requested changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Change> changes;

  static {
    // hack to force ProGuard to consider Change used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Change.class);
  }

  /**
   * Type of resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The presence of this field indicates that there exist more results following your last page of
   * results in pagination order. To fetch them, make another list request using this value as your
   * pagination token.
   *
   * In this way you can retrieve the complete contents of even very large collections one page at a
   * time. However, if the contents of the collection change between the first and last paginated
   * list request, the set of all elements returned will be an inconsistent view of the collection.
   * There is no way to retrieve a "snapshot" of collections larger than the maximum page size.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The requested changes.
   * @return value or {@code null} for none
   */
  public java.util.List<Change> getChanges() {
    return changes;
  }

  /**
   * The requested changes.
   * @param changes changes or {@code null} for none
   */
  public ChangesListResponse setChanges(java.util.List<Change> changes) {
    this.changes = changes;
    return this;
  }

  /**
   * Type of resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of resource.
   * @param kind kind or {@code null} for none
   */
  public ChangesListResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The presence of this field indicates that there exist more results following your last page of
   * results in pagination order. To fetch them, make another list request using this value as your
   * pagination token.
   *
   * In this way you can retrieve the complete contents of even very large collections one page at a
   * time. However, if the contents of the collection change between the first and last paginated
   * list request, the set of all elements returned will be an inconsistent view of the collection.
   * There is no way to retrieve a "snapshot" of collections larger than the maximum page size.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The presence of this field indicates that there exist more results following your last page of
   * results in pagination order. To fetch them, make another list request using this value as your
   * pagination token.
   *
   * In this way you can retrieve the complete contents of even very large collections one page at a
   * time. However, if the contents of the collection change between the first and last paginated
   * list request, the set of all elements returned will be an inconsistent view of the collection.
   * There is no way to retrieve a "snapshot" of collections larger than the maximum page size.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ChangesListResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ChangesListResponse set(String fieldName, Object value) {
    return (ChangesListResponse) super.set(fieldName, value);
  }

  @Override
  public ChangesListResponse clone() {
    return (ChangesListResponse) super.clone();
  }

}
