/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-30 at 19:00:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * A zone is a subtree of the DNS namespace under one administrative responsibility. A ManagedZone
 * is a resource that represents a DNS zone hosted by the Cloud DNS service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedZone extends com.google.api.client.json.GenericJson {

  /**
   * The time that this resource was created on the server. This is in RFC3339 text format. Output
   * only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTime;

  /**
   * A mutable string of at most 1024 characters associated with this resource for the user's
   * convenience. Has no effect on the managed zone's function.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The DNS name of this managed zone, for instance "example.com.".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dnsName;

  /**
   * Unique identifier for the resource; defined by the server (output only)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dns#managedZone".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * User assigned name for this resource. Must be unique within the project. The name must be 1-63
   * characters long, must begin with a letter, end with a letter or digit, and only contain
   * lowercase letters, digits or dashes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optionally specifies the NameServerSet for this ManagedZone. A NameServerSet is a set of DNS
   * name servers that all host the same ManagedZones. Most users will leave this field unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nameServerSet;

  /**
   * Delegate your managed_zone to these virtual name servers; defined by the server (output only)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> nameServers;

  /**
   * The time that this resource was created on the server. This is in RFC3339 text format. Output
   * only.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTime() {
    return creationTime;
  }

  /**
   * The time that this resource was created on the server. This is in RFC3339 text format. Output
   * only.
   * @param creationTime creationTime or {@code null} for none
   */
  public ManagedZone setCreationTime(java.lang.String creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * A mutable string of at most 1024 characters associated with this resource for the user's
   * convenience. Has no effect on the managed zone's function.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A mutable string of at most 1024 characters associated with this resource for the user's
   * convenience. Has no effect on the managed zone's function.
   * @param description description or {@code null} for none
   */
  public ManagedZone setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The DNS name of this managed zone, for instance "example.com.".
   * @return value or {@code null} for none
   */
  public java.lang.String getDnsName() {
    return dnsName;
  }

  /**
   * The DNS name of this managed zone, for instance "example.com.".
   * @param dnsName dnsName or {@code null} for none
   */
  public ManagedZone setDnsName(java.lang.String dnsName) {
    this.dnsName = dnsName;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only)
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only)
   * @param id id or {@code null} for none
   */
  public ManagedZone setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dns#managedZone".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dns#managedZone".
   * @param kind kind or {@code null} for none
   */
  public ManagedZone setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * User assigned name for this resource. Must be unique within the project. The name must be 1-63
   * characters long, must begin with a letter, end with a letter or digit, and only contain
   * lowercase letters, digits or dashes.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * User assigned name for this resource. Must be unique within the project. The name must be 1-63
   * characters long, must begin with a letter, end with a letter or digit, and only contain
   * lowercase letters, digits or dashes.
   * @param name name or {@code null} for none
   */
  public ManagedZone setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optionally specifies the NameServerSet for this ManagedZone. A NameServerSet is a set of DNS
   * name servers that all host the same ManagedZones. Most users will leave this field unset.
   * @return value or {@code null} for none
   */
  public java.lang.String getNameServerSet() {
    return nameServerSet;
  }

  /**
   * Optionally specifies the NameServerSet for this ManagedZone. A NameServerSet is a set of DNS
   * name servers that all host the same ManagedZones. Most users will leave this field unset.
   * @param nameServerSet nameServerSet or {@code null} for none
   */
  public ManagedZone setNameServerSet(java.lang.String nameServerSet) {
    this.nameServerSet = nameServerSet;
    return this;
  }

  /**
   * Delegate your managed_zone to these virtual name servers; defined by the server (output only)
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getNameServers() {
    return nameServers;
  }

  /**
   * Delegate your managed_zone to these virtual name servers; defined by the server (output only)
   * @param nameServers nameServers or {@code null} for none
   */
  public ManagedZone setNameServers(java.util.List<java.lang.String> nameServers) {
    this.nameServers = nameServers;
    return this;
  }

  @Override
  public ManagedZone set(String fieldName, Object value) {
    return (ManagedZone) super.set(fieldName, value);
  }

  @Override
  public ManagedZone clone() {
    return (ManagedZone) super.clone();
  }

}
