/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dns;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dns.DnsRequest;
import com.google.api.services.dns.DnsRequestInitializer;
import com.google.api.services.dns.model.Change;
import com.google.api.services.dns.model.ChangesListResponse;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.ManagedZonesListResponse;
import com.google.api.services.dns.model.Project;
import com.google.api.services.dns.model.ResourceRecordSetsListResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dns
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "dns/v1/projects/";
    public static final String DEFAULT_BATCH_PATH = "batch/dns/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/dns/v1/projects/";

    public Dns(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Dns(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Changes changes() {
        return new Changes();
    }

    public ManagedZones managedZones() {
        return new ManagedZones();
    }

    public Projects projects() {
        return new Projects();
    }

    public ResourceRecordSets resourceRecordSets() {
        return new ResourceRecordSets();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Google Cloud DNS API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Dns.DEFAULT_ROOT_URL, Dns.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Dns.DEFAULT_BATCH_PATH);
        }

        public Dns build() {
            return new Dns(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDnsRequestInitializer(DnsRequestInitializer dnsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dnsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class ResourceRecordSets {
        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DnsRequest<ResourceRecordSetsListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/rrsets";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private Integer maxResults;
            @Key
            private String name;
            @Key
            private String pageToken;
            @Key
            private String type;

            protected List(String string, String string2) {
                super(Dns.this, "GET", REST_PATH, null, ResourceRecordSetsListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String string) {
                this.name = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String string) {
                this.type = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Projects {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DnsRequest<Project> {
            private static final String REST_PATH = "{project}";
            @Key
            private String project;

            protected Get(String string) {
                super(Dns.this, "GET", REST_PATH, null, Project.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class ManagedZones {
        public Create create(String string, ManagedZone managedZone) throws IOException {
            Create create = new Create(string, managedZone);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DnsRequest<ManagedZonesListResponse> {
            private static final String REST_PATH = "{project}/managedZones";
            @Key
            private String project;
            @Key
            private String dnsName;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Dns.this, "GET", REST_PATH, null, ManagedZonesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getDnsName() {
                return this.dnsName;
            }

            public List setDnsName(String string) {
                this.dnsName = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DnsRequest<ManagedZone> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;

            protected Get(String string, String string2) {
                super(Dns.this, "GET", REST_PATH, null, ManagedZone.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DnsRequest<Void> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}";
            @Key
            private String project;
            @Key
            private String managedZone;

            protected Delete(String string, String string2) {
                super(Dns.this, "DELETE", REST_PATH, null, Void.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Delete setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DnsRequest<ManagedZone> {
            private static final String REST_PATH = "{project}/managedZones";
            @Key
            private String project;

            protected Create(String string, ManagedZone managedZone) {
                super(Dns.this, "POST", REST_PATH, (Object)managedZone, ManagedZone.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Create setProject(String string) {
                this.project = string;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Changes {
        public Create create(String string, String string2, Change change) throws IOException {
            Create create = new Create(string, string2, change);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Dns.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DnsRequest<ChangesListResponse> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortBy;
            @Key
            private String sortOrder;

            protected List(String string, String string2) {
                super(Dns.this, "GET", REST_PATH, null, ChangesListResponse.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public List setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortBy() {
                return this.sortBy;
            }

            public List setSortBy(String string) {
                this.sortBy = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DnsRequest<Change> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes/{changeId}";
            @Key
            private String project;
            @Key
            private String managedZone;
            @Key
            private String changeId;

            protected Get(String string, String string2, String string3) {
                super(Dns.this, "GET", REST_PATH, null, Change.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
                this.changeId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter changeId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Get setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            public String getChangeId() {
                return this.changeId;
            }

            public Get setChangeId(String string) {
                this.changeId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DnsRequest<Change> {
            private static final String REST_PATH = "{project}/managedZones/{managedZone}/changes";
            @Key
            private String project;
            @Key
            private String managedZone;

            protected Create(String string, String string2, Change change) {
                super(Dns.this, "POST", REST_PATH, (Object)change, Change.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.managedZone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter managedZone must be specified.");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Create setProject(String string) {
                this.project = string;
                return this;
            }

            public String getManagedZone() {
                return this.managedZone;
            }

            public Create setManagedZone(String string) {
                this.managedZone = string;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }
}

