/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Representation of label and label fields.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Label extends com.google.api.client.json.GenericJson {

  /**
   * A map of the fields on the label, keyed by the field's ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, LabelField> fields;

  /**
   * The ID of the label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * This is always drive#label
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The revision ID of the label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String revisionId;

  /**
   * A map of the fields on the label, keyed by the field's ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, LabelField> getFields() {
    return fields;
  }

  /**
   * A map of the fields on the label, keyed by the field's ID.
   * @param fields fields or {@code null} for none
   */
  public Label setFields(java.util.Map<String, LabelField> fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The ID of the label.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the label.
   * @param id id or {@code null} for none
   */
  public Label setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * This is always drive#label
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#label
   * @param kind kind or {@code null} for none
   */
  public Label setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The revision ID of the label.
   * @return value or {@code null} for none
   */
  public java.lang.String getRevisionId() {
    return revisionId;
  }

  /**
   * The revision ID of the label.
   * @param revisionId revisionId or {@code null} for none
   */
  public Label setRevisionId(java.lang.String revisionId) {
    this.revisionId = revisionId;
    return this;
  }

  @Override
  public Label set(String fieldName, Object value) {
    return (Label) super.set(fieldName, value);
  }

  @Override
  public Label clone() {
    return (Label) super.clone();
  }

}
