/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A modification to a label's field.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LabelFieldModification extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the field to be modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldId;

  /**
   * This is always drive#labelFieldModification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Replaces the value of a dateString Field with these new values. The string must be in the RFC
   * 3339 full-date format: YYYY-MM-DD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<com.google.api.client.util.DateTime> setDateValues;

  /**
   * Replaces the value of an `integer` field with these new values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> setIntegerValues;

  /**
   * Replaces a `selection` field with these new values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> setSelectionValues;

  /**
   * Sets the value of a `text` field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> setTextValues;

  /**
   * Replaces a `user` field with these new values. The values must be valid email addresses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> setUserValues;

  /**
   * Unsets the values for this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean unsetValues;

  /**
   * The ID of the field to be modified.
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldId() {
    return fieldId;
  }

  /**
   * The ID of the field to be modified.
   * @param fieldId fieldId or {@code null} for none
   */
  public LabelFieldModification setFieldId(java.lang.String fieldId) {
    this.fieldId = fieldId;
    return this;
  }

  /**
   * This is always drive#labelFieldModification.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#labelFieldModification.
   * @param kind kind or {@code null} for none
   */
  public LabelFieldModification setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Replaces the value of a dateString Field with these new values. The string must be in the RFC
   * 3339 full-date format: YYYY-MM-DD.
   * @return value or {@code null} for none
   */
  public java.util.List<com.google.api.client.util.DateTime> getSetDateValues() {
    return setDateValues;
  }

  /**
   * Replaces the value of a dateString Field with these new values. The string must be in the RFC
   * 3339 full-date format: YYYY-MM-DD.
   * @param setDateValues setDateValues or {@code null} for none
   */
  public LabelFieldModification setSetDateValues(java.util.List<com.google.api.client.util.DateTime> setDateValues) {
    this.setDateValues = setDateValues;
    return this;
  }

  /**
   * Replaces the value of an `integer` field with these new values.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getSetIntegerValues() {
    return setIntegerValues;
  }

  /**
   * Replaces the value of an `integer` field with these new values.
   * @param setIntegerValues setIntegerValues or {@code null} for none
   */
  public LabelFieldModification setSetIntegerValues(java.util.List<java.lang.Long> setIntegerValues) {
    this.setIntegerValues = setIntegerValues;
    return this;
  }

  /**
   * Replaces a `selection` field with these new values.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSetSelectionValues() {
    return setSelectionValues;
  }

  /**
   * Replaces a `selection` field with these new values.
   * @param setSelectionValues setSelectionValues or {@code null} for none
   */
  public LabelFieldModification setSetSelectionValues(java.util.List<java.lang.String> setSelectionValues) {
    this.setSelectionValues = setSelectionValues;
    return this;
  }

  /**
   * Sets the value of a `text` field.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSetTextValues() {
    return setTextValues;
  }

  /**
   * Sets the value of a `text` field.
   * @param setTextValues setTextValues or {@code null} for none
   */
  public LabelFieldModification setSetTextValues(java.util.List<java.lang.String> setTextValues) {
    this.setTextValues = setTextValues;
    return this;
  }

  /**
   * Replaces a `user` field with these new values. The values must be valid email addresses.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSetUserValues() {
    return setUserValues;
  }

  /**
   * Replaces a `user` field with these new values. The values must be valid email addresses.
   * @param setUserValues setUserValues or {@code null} for none
   */
  public LabelFieldModification setSetUserValues(java.util.List<java.lang.String> setUserValues) {
    this.setUserValues = setUserValues;
    return this;
  }

  /**
   * Unsets the values for this field.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUnsetValues() {
    return unsetValues;
  }

  /**
   * Unsets the values for this field.
   * @param unsetValues unsetValues or {@code null} for none
   */
  public LabelFieldModification setUnsetValues(java.lang.Boolean unsetValues) {
    this.unsetValues = unsetValues;
    return this;
  }

  @Override
  public LabelFieldModification set(String fieldName, Object value) {
    return (LabelFieldModification) super.set(fieldName, value);
  }

  @Override
  public LabelFieldModification clone() {
    return (LabelFieldModification) super.clone();
  }

}
