/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.serviceusage.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.serviceusage.v1.ServiceUsageRequest;
import com.google.api.services.serviceusage.v1.ServiceUsageRequestInitializer;
import com.google.api.services.serviceusage.v1.model.CancelOperationRequest;
import com.google.api.services.serviceusage.v1.model.DisableServiceRequest;
import com.google.api.services.serviceusage.v1.model.Empty;
import com.google.api.services.serviceusage.v1.model.EnableServiceRequest;
import com.google.api.services.serviceusage.v1.model.ListEnabledServicesResponse;
import com.google.api.services.serviceusage.v1.model.ListOperationsResponse;
import com.google.api.services.serviceusage.v1.model.Operation;
import com.google.api.services.serviceusage.v1.model.SearchServicesResponse;
import com.google.api.services.serviceusage.v1.model.ServiceState;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUsage
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://serviceusage.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://serviceusage.googleapis.com/";

    public ServiceUsage(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    ServiceUsage(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Operations operations() {
        return new Operations();
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Service Usage API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://serviceusage.googleapis.com/", ServiceUsage.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ServiceUsage.DEFAULT_BATCH_PATH);
        }

        public ServiceUsage build() {
            return new ServiceUsage(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setServiceUsageRequestInitializer(ServiceUsageRequestInitializer serviceUsageRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)serviceUsageRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Services {
        public Disable disable(String string, DisableServiceRequest disableServiceRequest) throws IOException {
            Disable disable = new Disable(string, disableServiceRequest);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)disable);
            return disable;
        }

        public Enable enable(String string, EnableServiceRequest enableServiceRequest) throws IOException {
            Enable enable = new Enable(string, enableServiceRequest);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)enable);
            return enable;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public ListEnabled listEnabled(String string) throws IOException {
            ListEnabled listEnabled = new ListEnabled(string);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)listEnabled);
            return listEnabled;
        }

        public Search search() throws IOException {
            Search search = new Search();
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)search);
            return search;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Search
        extends ServiceUsageRequest<SearchServicesResponse> {
            private static final String REST_PATH = "v1/services:search";
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected Search() {
                super(ServiceUsage.this, "GET", REST_PATH, null, SearchServicesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search set$Xgafv(String string) {
                return (Search)super.set$Xgafv(string);
            }

            public Search setAccessToken(String string) {
                return (Search)super.setAccessToken(string);
            }

            public Search setAlt(String string) {
                return (Search)super.setAlt(string);
            }

            public Search setBearerToken(String string) {
                return (Search)super.setBearerToken(string);
            }

            public Search setCallback(String string) {
                return (Search)super.setCallback(string);
            }

            public Search setFields(String string) {
                return (Search)super.setFields(string);
            }

            public Search setKey(String string) {
                return (Search)super.setKey(string);
            }

            public Search setOauthToken(String string) {
                return (Search)super.setOauthToken(string);
            }

            public Search setPp(Boolean bl) {
                return (Search)super.setPp(bl);
            }

            public Search setPrettyPrint(Boolean bl) {
                return (Search)super.setPrettyPrint(bl);
            }

            public Search setQuotaUser(String string) {
                return (Search)super.setQuotaUser(string);
            }

            public Search setUploadType(String string) {
                return (Search)super.setUploadType(string);
            }

            public Search setUploadProtocol(String string) {
                return (Search)super.setUploadProtocol(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public Search setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public Search set(String string, Object object) {
                return (Search)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListEnabled
        extends ServiceUsageRequest<ListEnabledServicesResponse> {
            private static final String REST_PATH = "v1/{+parent}/services:enabled";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected ListEnabled(String string) {
                super(ServiceUsage.this, "GET", REST_PATH, null, ListEnabledServicesResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListEnabled set$Xgafv(String string) {
                return (ListEnabled)super.set$Xgafv(string);
            }

            public ListEnabled setAccessToken(String string) {
                return (ListEnabled)super.setAccessToken(string);
            }

            public ListEnabled setAlt(String string) {
                return (ListEnabled)super.setAlt(string);
            }

            public ListEnabled setBearerToken(String string) {
                return (ListEnabled)super.setBearerToken(string);
            }

            public ListEnabled setCallback(String string) {
                return (ListEnabled)super.setCallback(string);
            }

            public ListEnabled setFields(String string) {
                return (ListEnabled)super.setFields(string);
            }

            public ListEnabled setKey(String string) {
                return (ListEnabled)super.setKey(string);
            }

            public ListEnabled setOauthToken(String string) {
                return (ListEnabled)super.setOauthToken(string);
            }

            public ListEnabled setPp(Boolean bl) {
                return (ListEnabled)super.setPp(bl);
            }

            public ListEnabled setPrettyPrint(Boolean bl) {
                return (ListEnabled)super.setPrettyPrint(bl);
            }

            public ListEnabled setQuotaUser(String string) {
                return (ListEnabled)super.setQuotaUser(string);
            }

            public ListEnabled setUploadType(String string) {
                return (ListEnabled)super.setUploadType(string);
            }

            public ListEnabled setUploadProtocol(String string) {
                return (ListEnabled)super.setUploadProtocol(string);
            }

            public String getParent() {
                return this.parent;
            }

            public ListEnabled setParent(String string) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListEnabled setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public ListEnabled setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public ListEnabled set(String string, Object object) {
                return (ListEnabled)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ServiceUsageRequest<ServiceState> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(ServiceUsage.this, "GET", REST_PATH, null, ServiceState.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Enable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}:enable";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Enable(String string, EnableServiceRequest enableServiceRequest) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)enableServiceRequest, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public Enable set$Xgafv(String string) {
                return (Enable)super.set$Xgafv(string);
            }

            public Enable setAccessToken(String string) {
                return (Enable)super.setAccessToken(string);
            }

            public Enable setAlt(String string) {
                return (Enable)super.setAlt(string);
            }

            public Enable setBearerToken(String string) {
                return (Enable)super.setBearerToken(string);
            }

            public Enable setCallback(String string) {
                return (Enable)super.setCallback(string);
            }

            public Enable setFields(String string) {
                return (Enable)super.setFields(string);
            }

            public Enable setKey(String string) {
                return (Enable)super.setKey(string);
            }

            public Enable setOauthToken(String string) {
                return (Enable)super.setOauthToken(string);
            }

            public Enable setPp(Boolean bl) {
                return (Enable)super.setPp(bl);
            }

            public Enable setPrettyPrint(Boolean bl) {
                return (Enable)super.setPrettyPrint(bl);
            }

            public Enable setQuotaUser(String string) {
                return (Enable)super.setQuotaUser(string);
            }

            public Enable setUploadType(String string) {
                return (Enable)super.setUploadType(string);
            }

            public Enable setUploadProtocol(String string) {
                return (Enable)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Enable setName(String string) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Enable set(String string, Object object) {
                return (Enable)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Disable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}:disable";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Disable(String string, DisableServiceRequest disableServiceRequest) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)disableServiceRequest, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public Disable set$Xgafv(String string) {
                return (Disable)super.set$Xgafv(string);
            }

            public Disable setAccessToken(String string) {
                return (Disable)super.setAccessToken(string);
            }

            public Disable setAlt(String string) {
                return (Disable)super.setAlt(string);
            }

            public Disable setBearerToken(String string) {
                return (Disable)super.setBearerToken(string);
            }

            public Disable setCallback(String string) {
                return (Disable)super.setCallback(string);
            }

            public Disable setFields(String string) {
                return (Disable)super.setFields(string);
            }

            public Disable setKey(String string) {
                return (Disable)super.setKey(string);
            }

            public Disable setOauthToken(String string) {
                return (Disable)super.setOauthToken(string);
            }

            public Disable setPp(Boolean bl) {
                return (Disable)super.setPp(bl);
            }

            public Disable setPrettyPrint(Boolean bl) {
                return (Disable)super.setPrettyPrint(bl);
            }

            public Disable setQuotaUser(String string) {
                return (Disable)super.setQuotaUser(string);
            }

            public Disable setUploadType(String string) {
                return (Disable)super.setUploadType(string);
            }

            public Disable setUploadProtocol(String string) {
                return (Disable)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Disable setName(String string) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Disable set(String string, Object object) {
                return (Disable)super.set(string, object);
            }
        }
    }

    public class Operations {
        public Cancel cancel(String string, CancelOperationRequest cancelOperationRequest) throws IOException {
            Cancel cancel = new Cancel(string, cancelOperationRequest);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)cancel);
            return cancel;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ServiceUsageRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/operations";
            @Key
            private String name;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;
            @Key
            private String filter;

            protected List() {
                super(ServiceUsage.this, "GET", REST_PATH, null, ListOperationsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String string) {
                this.name = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(ServiceUsage.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ServiceUsageRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String string) {
                super(ServiceUsage.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setBearerToken(String string) {
                return (Delete)super.setBearerToken(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPp(Boolean bl) {
                return (Delete)super.setPp(bl);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String string) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Cancel
        extends ServiceUsageRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String string, CancelOperationRequest cancelOperationRequest) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)cancelOperationRequest, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
            }

            public Cancel set$Xgafv(String string) {
                return (Cancel)super.set$Xgafv(string);
            }

            public Cancel setAccessToken(String string) {
                return (Cancel)super.setAccessToken(string);
            }

            public Cancel setAlt(String string) {
                return (Cancel)super.setAlt(string);
            }

            public Cancel setBearerToken(String string) {
                return (Cancel)super.setBearerToken(string);
            }

            public Cancel setCallback(String string) {
                return (Cancel)super.setCallback(string);
            }

            public Cancel setFields(String string) {
                return (Cancel)super.setFields(string);
            }

            public Cancel setKey(String string) {
                return (Cancel)super.setKey(string);
            }

            public Cancel setOauthToken(String string) {
                return (Cancel)super.setOauthToken(string);
            }

            public Cancel setPp(Boolean bl) {
                return (Cancel)super.setPp(bl);
            }

            public Cancel setPrettyPrint(Boolean bl) {
                return (Cancel)super.setPrettyPrint(bl);
            }

            public Cancel setQuotaUser(String string) {
                return (Cancel)super.setQuotaUser(string);
            }

            public Cancel setUploadType(String string) {
                return (Cancel)super.setUploadType(string);
            }

            public Cancel setUploadProtocol(String string) {
                return (Cancel)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String string) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Cancel set(String string, Object object) {
                return (Cancel)super.set(string, object);
            }
        }
    }
}

