/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-10-09 at 17:29:24 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * An access-control entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ObjectAccessControl extends com.google.api.client.json.GenericJson {

  /**
   * The name of the bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucket;

  /**
   * The domain associated with the entity, if any.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String domain;

  /**
   * The email address associated with the entity, if any.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * The entity holding the permission, in one of the following forms: - user-userId  - user-email
   * - group-groupId  - group-email  - domain-domain  - project-team-projectId  - allUsers  -
   * allAuthenticatedUsers Examples:  - The user liz@example.com would be user-liz@example.com.  -
   * The group example@googlegroups.com would be group-example@googlegroups.com.  - To refer to all
   * members of the Google Apps for Business domain example.com, the entity would be domain-
   * example.com.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String entity;

  /**
   * The ID for the entity, if any.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String entityId;

  /**
   * HTTP 1.1 Entity tag for the access-control entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The content generation of the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long generation;

  /**
   * The ID of the access-control entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The kind of item this is. For object access control entries, this is always
   * storage#objectAccessControl.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("object")
  private java.lang.String object__;

  /**
   * The project team associated with the entity, if any.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProjectTeam projectTeam;

  /**
   * The access permission for the entity. Can be READER or OWNER.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * The link to this access-control entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The name of the bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucket() {
    return bucket;
  }

  /**
   * The name of the bucket.
   * @param bucket bucket or {@code null} for none
   */
  public ObjectAccessControl setBucket(java.lang.String bucket) {
    this.bucket = bucket;
    return this;
  }

  /**
   * The domain associated with the entity, if any.
   * @return value or {@code null} for none
   */
  public java.lang.String getDomain() {
    return domain;
  }

  /**
   * The domain associated with the entity, if any.
   * @param domain domain or {@code null} for none
   */
  public ObjectAccessControl setDomain(java.lang.String domain) {
    this.domain = domain;
    return this;
  }

  /**
   * The email address associated with the entity, if any.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The email address associated with the entity, if any.
   * @param email email or {@code null} for none
   */
  public ObjectAccessControl setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * The entity holding the permission, in one of the following forms: - user-userId  - user-email
   * - group-groupId  - group-email  - domain-domain  - project-team-projectId  - allUsers  -
   * allAuthenticatedUsers Examples:  - The user liz@example.com would be user-liz@example.com.  -
   * The group example@googlegroups.com would be group-example@googlegroups.com.  - To refer to all
   * members of the Google Apps for Business domain example.com, the entity would be domain-
   * example.com.
   * @return value or {@code null} for none
   */
  public java.lang.String getEntity() {
    return entity;
  }

  /**
   * The entity holding the permission, in one of the following forms: - user-userId  - user-email
   * - group-groupId  - group-email  - domain-domain  - project-team-projectId  - allUsers  -
   * allAuthenticatedUsers Examples:  - The user liz@example.com would be user-liz@example.com.  -
   * The group example@googlegroups.com would be group-example@googlegroups.com.  - To refer to all
   * members of the Google Apps for Business domain example.com, the entity would be domain-
   * example.com.
   * @param entity entity or {@code null} for none
   */
  public ObjectAccessControl setEntity(java.lang.String entity) {
    this.entity = entity;
    return this;
  }

  /**
   * The ID for the entity, if any.
   * @return value or {@code null} for none
   */
  public java.lang.String getEntityId() {
    return entityId;
  }

  /**
   * The ID for the entity, if any.
   * @param entityId entityId or {@code null} for none
   */
  public ObjectAccessControl setEntityId(java.lang.String entityId) {
    this.entityId = entityId;
    return this;
  }

  /**
   * HTTP 1.1 Entity tag for the access-control entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * HTTP 1.1 Entity tag for the access-control entry.
   * @param etag etag or {@code null} for none
   */
  public ObjectAccessControl setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The content generation of the object.
   * @return value or {@code null} for none
   */
  public java.lang.Long getGeneration() {
    return generation;
  }

  /**
   * The content generation of the object.
   * @param generation generation or {@code null} for none
   */
  public ObjectAccessControl setGeneration(java.lang.Long generation) {
    this.generation = generation;
    return this;
  }

  /**
   * The ID of the access-control entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the access-control entry.
   * @param id id or {@code null} for none
   */
  public ObjectAccessControl setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of item this is. For object access control entries, this is always
   * storage#objectAccessControl.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For object access control entries, this is always
   * storage#objectAccessControl.
   * @param kind kind or {@code null} for none
   */
  public ObjectAccessControl setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of the object.
   * @return value or {@code null} for none
   */
  public java.lang.String getObject() {
    return object__;
  }

  /**
   * The name of the object.
   * @param object__ object__ or {@code null} for none
   */
  public ObjectAccessControl setObject(java.lang.String object__) {
    this.object__ = object__;
    return this;
  }

  /**
   * The project team associated with the entity, if any.
   * @return value or {@code null} for none
   */
  public ProjectTeam getProjectTeam() {
    return projectTeam;
  }

  /**
   * The project team associated with the entity, if any.
   * @param projectTeam projectTeam or {@code null} for none
   */
  public ObjectAccessControl setProjectTeam(ProjectTeam projectTeam) {
    this.projectTeam = projectTeam;
    return this;
  }

  /**
   * The access permission for the entity. Can be READER or OWNER.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * The access permission for the entity. Can be READER or OWNER.
   * @param role role or {@code null} for none
   */
  public ObjectAccessControl setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * The link to this access-control entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The link to this access-control entry.
   * @param selfLink selfLink or {@code null} for none
   */
  public ObjectAccessControl setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public ObjectAccessControl set(String fieldName, Object value) {
    return (ObjectAccessControl) super.set(fieldName, value);
  }

  @Override
  public ObjectAccessControl clone() {
    return (ObjectAccessControl) super.clone();
  }

  /**
   * The project team associated with the entity, if any.
   */
  public static final class ProjectTeam extends com.google.api.client.json.GenericJson {

    /**
     * The project number.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String projectNumber;

    /**
     * The team. Can be owners, editors, or viewers.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String team;

    /**
     * The project number.
     * @return value or {@code null} for none
     */
    public java.lang.String getProjectNumber() {
      return projectNumber;
    }

    /**
     * The project number.
     * @param projectNumber projectNumber or {@code null} for none
     */
    public ProjectTeam setProjectNumber(java.lang.String projectNumber) {
      this.projectNumber = projectNumber;
      return this;
    }

    /**
     * The team. Can be owners, editors, or viewers.
     * @return value or {@code null} for none
     */
    public java.lang.String getTeam() {
      return team;
    }

    /**
     * The team. Can be owners, editors, or viewers.
     * @param team team or {@code null} for none
     */
    public ProjectTeam setTeam(java.lang.String team) {
      this.team = team;
      return this;
    }

    @Override
    public ProjectTeam set(String fieldName, Object value) {
      return (ProjectTeam) super.set(fieldName, value);
    }

    @Override
    public ProjectTeam clone() {
      return (ProjectTeam) super.clone();
    }

  }

}
