/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-10-09 at 17:29:24 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * A rewrite response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RewriteResponse extends com.google.api.client.json.GenericJson {

  /**
   * true if the copy is finished; otherwise, false if the copy is in progress. This property is
   * always present in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean done;

  /**
   * The kind of item this is.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The total size of the object being copied in bytes. This property is always present in the
   * response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger objectSize;

  /**
   * A resource containing the metadata for the copied-to object. This property is present in the
   * response only when copying completes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StorageObject resource;

  /**
   * A token to use in subsequent requests to continue copying data. This token is present in the
   * response only when there is more data to copy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rewriteToken;

  /**
   * The total bytes written so far, which can be used to provide a waiting user with a progress
   * indicator. This property is always present in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger totalBytesRewritten;

  /**
   * true if the copy is finished; otherwise, false if the copy is in progress. This property is
   * always present in the response.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDone() {
    return done;
  }

  /**
   * true if the copy is finished; otherwise, false if the copy is in progress. This property is
   * always present in the response.
   * @param done done or {@code null} for none
   */
  public RewriteResponse setDone(java.lang.Boolean done) {
    this.done = done;
    return this;
  }

  /**
   * The kind of item this is.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is.
   * @param kind kind or {@code null} for none
   */
  public RewriteResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The total size of the object being copied in bytes. This property is always present in the
   * response.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getObjectSize() {
    return objectSize;
  }

  /**
   * The total size of the object being copied in bytes. This property is always present in the
   * response.
   * @param objectSize objectSize or {@code null} for none
   */
  public RewriteResponse setObjectSize(java.math.BigInteger objectSize) {
    this.objectSize = objectSize;
    return this;
  }

  /**
   * A resource containing the metadata for the copied-to object. This property is present in the
   * response only when copying completes.
   * @return value or {@code null} for none
   */
  public StorageObject getResource() {
    return resource;
  }

  /**
   * A resource containing the metadata for the copied-to object. This property is present in the
   * response only when copying completes.
   * @param resource resource or {@code null} for none
   */
  public RewriteResponse setResource(StorageObject resource) {
    this.resource = resource;
    return this;
  }

  /**
   * A token to use in subsequent requests to continue copying data. This token is present in the
   * response only when there is more data to copy.
   * @return value or {@code null} for none
   */
  public java.lang.String getRewriteToken() {
    return rewriteToken;
  }

  /**
   * A token to use in subsequent requests to continue copying data. This token is present in the
   * response only when there is more data to copy.
   * @param rewriteToken rewriteToken or {@code null} for none
   */
  public RewriteResponse setRewriteToken(java.lang.String rewriteToken) {
    this.rewriteToken = rewriteToken;
    return this;
  }

  /**
   * The total bytes written so far, which can be used to provide a waiting user with a progress
   * indicator. This property is always present in the response.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getTotalBytesRewritten() {
    return totalBytesRewritten;
  }

  /**
   * The total bytes written so far, which can be used to provide a waiting user with a progress
   * indicator. This property is always present in the response.
   * @param totalBytesRewritten totalBytesRewritten or {@code null} for none
   */
  public RewriteResponse setTotalBytesRewritten(java.math.BigInteger totalBytesRewritten) {
    this.totalBytesRewritten = totalBytesRewritten;
    return this;
  }

  @Override
  public RewriteResponse set(String fieldName, Object value) {
    return (RewriteResponse) super.set(fieldName, value);
  }

  @Override
  public RewriteResponse clone() {
    return (RewriteResponse) super.clone();
  }

}
