/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-10-09 at 17:29:24 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * An object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StorageObject extends com.google.api.client.json.GenericJson {

  /**
   * Access controls on the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ObjectAccessControl> acl;

  /**
   * The name of the bucket containing this object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucket;

  /**
   * Cache-Control directive for the object data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cacheControl;

  /**
   * Number of underlying components that make up this object. Components are accumulated by compose
   * operations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer componentCount;

  /**
   * Content-Disposition of the object data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentDisposition;

  /**
   * Content-Encoding of the object data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentEncoding;

  /**
   * Content-Language of the object data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentLanguage;

  /**
   * Content-Type of the object data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentType;

  /**
   * CRC32c checksum, as described in RFC 4960, Appendix B; encoded using base64 in big-endian byte
   * order. For more information about using the CRC32c checksum, see Hashes and ETags: Best
   * Practices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String crc32c;

  /**
   * HTTP 1.1 Entity tag for the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The content generation of this object. Used for object versioning.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long generation;

  /**
   * The ID of the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The kind of item this is. For objects, this is always storage#object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * MD5 hash of the data; encoded using base64. For more information about using the MD5 hash, see
   * Hashes and ETags: Best Practices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String md5Hash;

  /**
   * Media download link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mediaLink;

  /**
   * User-provided metadata, in key/value pairs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> metadata;

  /**
   * The version of the metadata for this object at this generation. Used for preconditions and for
   * detecting changes in metadata. A metageneration number is only meaningful in the context of a
   * particular generation of a particular object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long metageneration;

  /**
   * The name of this object. Required if not specified by URL parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The owner of the object. This will always be the uploader of the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Owner owner;

  /**
   * The link to this object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Content-Length of the data in bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger size;

  /**
   * Storage class of the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storageClass;

  /**
   * The creation time of the object in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime timeCreated;

  /**
   * The deletion time of the object in RFC 3339 format. Will be returned if and only if this
   * version of the object has been deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime timeDeleted;

  /**
   * The modification time of the object metadata in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Access controls on the object.
   * @return value or {@code null} for none
   */
  public java.util.List<ObjectAccessControl> getAcl() {
    return acl;
  }

  /**
   * Access controls on the object.
   * @param acl acl or {@code null} for none
   */
  public StorageObject setAcl(java.util.List<ObjectAccessControl> acl) {
    this.acl = acl;
    return this;
  }

  /**
   * The name of the bucket containing this object.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucket() {
    return bucket;
  }

  /**
   * The name of the bucket containing this object.
   * @param bucket bucket or {@code null} for none
   */
  public StorageObject setBucket(java.lang.String bucket) {
    this.bucket = bucket;
    return this;
  }

  /**
   * Cache-Control directive for the object data.
   * @return value or {@code null} for none
   */
  public java.lang.String getCacheControl() {
    return cacheControl;
  }

  /**
   * Cache-Control directive for the object data.
   * @param cacheControl cacheControl or {@code null} for none
   */
  public StorageObject setCacheControl(java.lang.String cacheControl) {
    this.cacheControl = cacheControl;
    return this;
  }

  /**
   * Number of underlying components that make up this object. Components are accumulated by compose
   * operations.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getComponentCount() {
    return componentCount;
  }

  /**
   * Number of underlying components that make up this object. Components are accumulated by compose
   * operations.
   * @param componentCount componentCount or {@code null} for none
   */
  public StorageObject setComponentCount(java.lang.Integer componentCount) {
    this.componentCount = componentCount;
    return this;
  }

  /**
   * Content-Disposition of the object data.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentDisposition() {
    return contentDisposition;
  }

  /**
   * Content-Disposition of the object data.
   * @param contentDisposition contentDisposition or {@code null} for none
   */
  public StorageObject setContentDisposition(java.lang.String contentDisposition) {
    this.contentDisposition = contentDisposition;
    return this;
  }

  /**
   * Content-Encoding of the object data.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentEncoding() {
    return contentEncoding;
  }

  /**
   * Content-Encoding of the object data.
   * @param contentEncoding contentEncoding or {@code null} for none
   */
  public StorageObject setContentEncoding(java.lang.String contentEncoding) {
    this.contentEncoding = contentEncoding;
    return this;
  }

  /**
   * Content-Language of the object data.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentLanguage() {
    return contentLanguage;
  }

  /**
   * Content-Language of the object data.
   * @param contentLanguage contentLanguage or {@code null} for none
   */
  public StorageObject setContentLanguage(java.lang.String contentLanguage) {
    this.contentLanguage = contentLanguage;
    return this;
  }

  /**
   * Content-Type of the object data.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentType() {
    return contentType;
  }

  /**
   * Content-Type of the object data.
   * @param contentType contentType or {@code null} for none
   */
  public StorageObject setContentType(java.lang.String contentType) {
    this.contentType = contentType;
    return this;
  }

  /**
   * CRC32c checksum, as described in RFC 4960, Appendix B; encoded using base64 in big-endian byte
   * order. For more information about using the CRC32c checksum, see Hashes and ETags: Best
   * Practices.
   * @return value or {@code null} for none
   */
  public java.lang.String getCrc32c() {
    return crc32c;
  }

  /**
   * CRC32c checksum, as described in RFC 4960, Appendix B; encoded using base64 in big-endian byte
   * order. For more information about using the CRC32c checksum, see Hashes and ETags: Best
   * Practices.
   * @param crc32c crc32c or {@code null} for none
   */
  public StorageObject setCrc32c(java.lang.String crc32c) {
    this.crc32c = crc32c;
    return this;
  }

  /**
   * HTTP 1.1 Entity tag for the object.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * HTTP 1.1 Entity tag for the object.
   * @param etag etag or {@code null} for none
   */
  public StorageObject setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The content generation of this object. Used for object versioning.
   * @return value or {@code null} for none
   */
  public java.lang.Long getGeneration() {
    return generation;
  }

  /**
   * The content generation of this object. Used for object versioning.
   * @param generation generation or {@code null} for none
   */
  public StorageObject setGeneration(java.lang.Long generation) {
    this.generation = generation;
    return this;
  }

  /**
   * The ID of the object.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the object.
   * @param id id or {@code null} for none
   */
  public StorageObject setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of item this is. For objects, this is always storage#object.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For objects, this is always storage#object.
   * @param kind kind or {@code null} for none
   */
  public StorageObject setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * MD5 hash of the data; encoded using base64. For more information about using the MD5 hash, see
   * Hashes and ETags: Best Practices.
   * @return value or {@code null} for none
   */
  public java.lang.String getMd5Hash() {
    return md5Hash;
  }

  /**
   * MD5 hash of the data; encoded using base64. For more information about using the MD5 hash, see
   * Hashes and ETags: Best Practices.
   * @param md5Hash md5Hash or {@code null} for none
   */
  public StorageObject setMd5Hash(java.lang.String md5Hash) {
    this.md5Hash = md5Hash;
    return this;
  }

  /**
   * Media download link.
   * @return value or {@code null} for none
   */
  public java.lang.String getMediaLink() {
    return mediaLink;
  }

  /**
   * Media download link.
   * @param mediaLink mediaLink or {@code null} for none
   */
  public StorageObject setMediaLink(java.lang.String mediaLink) {
    this.mediaLink = mediaLink;
    return this;
  }

  /**
   * User-provided metadata, in key/value pairs.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getMetadata() {
    return metadata;
  }

  /**
   * User-provided metadata, in key/value pairs.
   * @param metadata metadata or {@code null} for none
   */
  public StorageObject setMetadata(java.util.Map<String, java.lang.String> metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The version of the metadata for this object at this generation. Used for preconditions and for
   * detecting changes in metadata. A metageneration number is only meaningful in the context of a
   * particular generation of a particular object.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMetageneration() {
    return metageneration;
  }

  /**
   * The version of the metadata for this object at this generation. Used for preconditions and for
   * detecting changes in metadata. A metageneration number is only meaningful in the context of a
   * particular generation of a particular object.
   * @param metageneration metageneration or {@code null} for none
   */
  public StorageObject setMetageneration(java.lang.Long metageneration) {
    this.metageneration = metageneration;
    return this;
  }

  /**
   * The name of this object. Required if not specified by URL parameter.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this object. Required if not specified by URL parameter.
   * @param name name or {@code null} for none
   */
  public StorageObject setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The owner of the object. This will always be the uploader of the object.
   * @return value or {@code null} for none
   */
  public Owner getOwner() {
    return owner;
  }

  /**
   * The owner of the object. This will always be the uploader of the object.
   * @param owner owner or {@code null} for none
   */
  public StorageObject setOwner(Owner owner) {
    this.owner = owner;
    return this;
  }

  /**
   * The link to this object.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The link to this object.
   * @param selfLink selfLink or {@code null} for none
   */
  public StorageObject setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Content-Length of the data in bytes.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getSize() {
    return size;
  }

  /**
   * Content-Length of the data in bytes.
   * @param size size or {@code null} for none
   */
  public StorageObject setSize(java.math.BigInteger size) {
    this.size = size;
    return this;
  }

  /**
   * Storage class of the object.
   * @return value or {@code null} for none
   */
  public java.lang.String getStorageClass() {
    return storageClass;
  }

  /**
   * Storage class of the object.
   * @param storageClass storageClass or {@code null} for none
   */
  public StorageObject setStorageClass(java.lang.String storageClass) {
    this.storageClass = storageClass;
    return this;
  }

  /**
   * The creation time of the object in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeCreated() {
    return timeCreated;
  }

  /**
   * The creation time of the object in RFC 3339 format.
   * @param timeCreated timeCreated or {@code null} for none
   */
  public StorageObject setTimeCreated(com.google.api.client.util.DateTime timeCreated) {
    this.timeCreated = timeCreated;
    return this;
  }

  /**
   * The deletion time of the object in RFC 3339 format. Will be returned if and only if this
   * version of the object has been deleted.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeDeleted() {
    return timeDeleted;
  }

  /**
   * The deletion time of the object in RFC 3339 format. Will be returned if and only if this
   * version of the object has been deleted.
   * @param timeDeleted timeDeleted or {@code null} for none
   */
  public StorageObject setTimeDeleted(com.google.api.client.util.DateTime timeDeleted) {
    this.timeDeleted = timeDeleted;
    return this;
  }

  /**
   * The modification time of the object metadata in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * The modification time of the object metadata in RFC 3339 format.
   * @param updated updated or {@code null} for none
   */
  public StorageObject setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  @Override
  public StorageObject set(String fieldName, Object value) {
    return (StorageObject) super.set(fieldName, value);
  }

  @Override
  public StorageObject clone() {
    return (StorageObject) super.clone();
  }

  /**
   * The owner of the object. This will always be the uploader of the object.
   */
  public static final class Owner extends com.google.api.client.json.GenericJson {

    /**
     * The entity, in the form user-userId.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String entity;

    /**
     * The ID for the entity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String entityId;

    /**
     * The entity, in the form user-userId.
     * @return value or {@code null} for none
     */
    public java.lang.String getEntity() {
      return entity;
    }

    /**
     * The entity, in the form user-userId.
     * @param entity entity or {@code null} for none
     */
    public Owner setEntity(java.lang.String entity) {
      this.entity = entity;
      return this;
    }

    /**
     * The ID for the entity.
     * @return value or {@code null} for none
     */
    public java.lang.String getEntityId() {
      return entityId;
    }

    /**
     * The ID for the entity.
     * @param entityId entityId or {@code null} for none
     */
    public Owner setEntityId(java.lang.String entityId) {
      this.entityId = entityId;
      return this;
    }

    @Override
    public Owner set(String fieldName, Object value) {
      return (Owner) super.set(fieldName, value);
    }

    @Override
    public Owner clone() {
      return (Owner) super.clone();
    }

  }

}
