/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.internal.ImmutableCopy;
import com.google.appengine.api.search.FacetResultValue;
import com.google.appengine.api.search.Util;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class FacetResult
implements Serializable {
    private static final boolean ONLY_JRE_CLASSES_IN_APIS = Boolean.getBoolean("com.google.appengine.only.jre.classes.in.apis");
    private static final long serialVersionUID = 1222792844480713320L;
    private static final int MAX_VALUE_TO_STRING = 10;
    private final List<FacetResultValue> values;
    private final String name;

    private FacetResult(Builder builder) {
        this.values = ONLY_JRE_CLASSES_IN_APIS ? ImmutableCopy.list(builder.values) : ImmutableList.copyOf(builder.values);
        this.name = builder.name;
        this.checkValid();
    }

    public List<FacetResultValue> getValues() {
        return this.values;
    }

    public String getName() {
        return this.name;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void checkValid() {
        Preconditions.checkNotNull(this.name, "name cannot be null.");
        Preconditions.checkArgument(!this.name.isEmpty(), "name cannot be empty.");
    }

    static Builder newBuilder(SearchServicePb.FacetResult facetResult) {
        Builder frBuilder = FacetResult.newBuilder();
        frBuilder.setName(facetResult.getName());
        for (SearchServicePb.FacetResultValue value : facetResult.getValueList()) {
            frBuilder.addValue(FacetResultValue.withProtoMessage(value));
        }
        return frBuilder;
    }

    public String toString() {
        return new Util.ToStringHelper("FacetResult").addField("name", this.getName()).addIterableField("values", this.getValues(), 10).finish();
    }

    public static final class Builder {
        private final List<FacetResultValue> values = new ArrayList<FacetResultValue>();
        private String name;

        private Builder() {
        }

        public Builder setName(String name) {
            Preconditions.checkNotNull(name, "name cannot be null");
            Preconditions.checkArgument(!name.isEmpty(), "name cannot be empty.");
            this.name = name;
            return this;
        }

        public Builder addValue(FacetResultValue value) {
            Preconditions.checkNotNull(value, "value cannot be null");
            this.values.add(value);
            return this;
        }

        public FacetResult build() {
            return new FacetResult(this);
        }
    }
}

