/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.datastore.EntityV4;
import javax.annotation.Nullable;

public class EntityV4Normalizer {
    private final EntityTranslator translator;
    private final EntityTranslator.Format internalFormat;
    private final EntityV4.PartitionId defaultPartitionId;
    private final Function<EntityV4.Key, EntityV4.Key> keyTransform = new Function<EntityV4.Key, EntityV4.Key>(){

        @Override
        public EntityV4.Key apply(EntityV4.Key input) {
            return EntityV4Normalizer.this.normalizeKey(input);
        }
    };

    public EntityV4Normalizer(EntityTranslator translator, EntityTranslator.Format internalFormat, String defaultDatasetId) {
        this(translator, internalFormat, EntityV4.PartitionId.newBuilder().setDatasetId(defaultDatasetId).build());
    }

    private EntityV4Normalizer(EntityTranslator translator, EntityTranslator.Format internalFormat, EntityV4.PartitionId defaultPartitionId) {
        this.translator = translator;
        this.internalFormat = internalFormat;
        this.defaultPartitionId = defaultPartitionId;
    }

    public EntityV4Normalizer overrideDefaultPartitionId(EntityV4.PartitionId newDefaultPartitionId) {
        if (newDefaultPartitionId.equals(this.defaultPartitionId)) {
            return this;
        }
        return new EntityV4Normalizer(this.translator, this.internalFormat, newDefaultPartitionId);
    }

    public EntityV4.PartitionId normalizePartitionId(@Nullable EntityV4.PartitionId partitionId) {
        if (partitionId == null) {
            return this.defaultPartitionId;
        }
        if (partitionId.hasDatasetId()) {
            return partitionId;
        }
        if (partitionId.equals(EntityV4.PartitionId.getDefaultInstance())) {
            return this.defaultPartitionId;
        }
        EntityV4.PartitionId.Builder normalizedPartitionIdBuidler = partitionId.toBuilder();
        normalizedPartitionIdBuidler.setDatasetId(this.defaultPartitionId.getDatasetId());
        return normalizedPartitionIdBuidler.build();
    }

    public final EntityV4.Key normalizeKey(EntityV4.Key key) {
        if (this.isNormalKey(key)) {
            return key;
        }
        return this.normalizeKey(key.toBuilder()).build();
    }

    protected EntityV4.Key.Builder normalizeKey(EntityV4.Key.Builder key) {
        key.setPartitionId(this.normalizePartitionId(key.getPartitionId()));
        return key;
    }

    protected boolean isNormalKey(EntityV4.KeyOrBuilder key) {
        return key.hasPartitionId() && key.getPartitionId().hasDatasetId();
    }

    private boolean isNormalValue(EntityV4.ValueOrBuilder value, int remainingRecursionAllowed) {
        if (value.hasKeyValue() ? !this.isNormalKey(value.getKeyValue()) : value.hasEntityValue() && !this.isNormalEntity(value.getEntityValue(), remainingRecursionAllowed)) {
            return false;
        }
        for (EntityV4.ValueOrBuilder valueOrBuilder : value.getListValueList()) {
            if (this.isNormalValue(valueOrBuilder, remainingRecursionAllowed)) continue;
            return false;
        }
        return true;
    }

    private boolean isNormalEntity(EntityV4.EntityOrBuilder entity, int remainingRecursionAllowed) {
        if (remainingRecursionAllowed <= 0) {
            return false;
        }
        --remainingRecursionAllowed;
        if (entity.hasKey() && !this.isNormalKey(entity.getKey())) {
            return false;
        }
        for (EntityV4.PropertyOrBuilder propertyOrBuilder : entity.getPropertyOrBuilderList()) {
            if (!propertyOrBuilder.hasValue() || this.isNormalValue(propertyOrBuilder.getValueOrBuilder(), remainingRecursionAllowed)) continue;
            return false;
        }
        return true;
    }

    public final EntityV4.Value normalizeValue(EntityV4.Value value) {
        if (value.hasKeyValue()) {
            EntityV4.Key key = value.getKeyValue();
            EntityV4.Key normalizedKey = this.normalizeKey(key);
            if (normalizedKey != key) {
                EntityV4.Value.Builder valueBuilder = value.toBuilder();
                valueBuilder.setKeyValue(normalizedKey);
                return valueBuilder.build();
            }
        } else if (value.hasEntityValue()) {
            EntityV4.Entity normalizedSubEntity;
            EntityV4.Entity subEntity = value.getEntityValue();
            EntityV4.Entity entity = normalizedSubEntity = this.isNormalEntity(subEntity, 2) ? subEntity : this.normalizeEntity(subEntity.toBuilder()).build();
            if (normalizedSubEntity != subEntity) {
                EntityV4.Value.Builder valueBuilder = value.toBuilder();
                valueBuilder.setEntityValue(normalizedSubEntity);
                return valueBuilder.build();
            }
        } else if (value.getListValueCount() > 0) {
            EntityV4.Value.Builder valueBuilder = null;
            for (int index = 0; index < value.getListValueCount(); ++index) {
                EntityV4.Value normalizedSubValue;
                EntityV4.Value subValue = value.getListValue(index);
                if (subValue == (normalizedSubValue = this.normalizeValue(subValue))) continue;
                if (valueBuilder == null) {
                    valueBuilder = value.toBuilder();
                }
                valueBuilder.setListValue(index, normalizedSubValue);
            }
            if (valueBuilder != null) {
                return valueBuilder.build();
            }
        }
        return value;
    }

    private EntityV4.Entity.Builder normalizeEntity(EntityV4.Entity.Builder entityBuilder) {
        if (entityBuilder.hasKey()) {
            entityBuilder.setKey(this.normalizeKey(entityBuilder.getKey()));
        }
        for (int propertyIndex = 0; propertyIndex < entityBuilder.getPropertyCount(); ++propertyIndex) {
            EntityV4.Value normalizedValue;
            EntityV4.PropertyOrBuilder property = entityBuilder.getPropertyOrBuilder(propertyIndex);
            if (!property.hasValue() || (normalizedValue = this.normalizeValue(property.getValue())) == property.getValue()) continue;
            entityBuilder.getPropertyBuilder(propertyIndex).setValue(normalizedValue);
        }
        return entityBuilder;
    }

    public final EntityV4.Entity normalizeEntity(EntityV4.Entity entity, EntityTranslator.Format format) {
        EntityV4.Entity.Builder builder = null;
        if (!this.internalFormat.isCompatibleWith(entity)) {
            builder = entity.toBuilder();
            this.internalFormat.convertIfFormat(builder, format);
        }
        if (!this.isNormalEntity(builder != null ? builder : entity, 2)) {
            if (builder == null) {
                builder = entity.toBuilder();
            }
            this.normalizeEntity(builder);
        }
        return builder != null ? builder.build() : entity;
    }

    public Function<EntityV4.Key, EntityV4.Key> getKeyTransform() {
        return this.keyTransform;
    }
}

