/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CreateObjectOptions {
    public static final Map<String, byte[]> EMPTY_METADATA = ImmutableMap.of();
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final CreateObjectOptions DEFAULT = new CreateObjectOptions(true);
    private final boolean overwriteExisting;
    private final String contentType;
    private final Map<String, byte[]> metadata;
    private final boolean requireMetadataMatchForEmptyObjects;

    public CreateObjectOptions(boolean overwriteExisting) {
        this(overwriteExisting, DEFAULT_CONTENT_TYPE, EMPTY_METADATA, false);
    }

    public CreateObjectOptions(boolean overwriteExisting, Map<String, byte[]> metadata) {
        this(overwriteExisting, DEFAULT_CONTENT_TYPE, metadata, true);
    }

    public CreateObjectOptions(boolean overwriteExisting, String contentType, Map<String, byte[]> metadata) {
        this(overwriteExisting, contentType, metadata, true);
    }

    public CreateObjectOptions(boolean overwriteExisting, String contentType, Map<String, byte[]> metadata, boolean requireMetadataMatchForEmptyObjects) {
        Preconditions.checkArgument((!metadata.containsKey("Content-Type") ? 1 : 0) != 0, (Object)"The Content-Type metadata must be provided explicitly via the 'contentType' parameter");
        this.overwriteExisting = overwriteExisting;
        this.contentType = contentType;
        this.metadata = metadata;
        this.requireMetadataMatchForEmptyObjects = requireMetadataMatchForEmptyObjects;
    }

    public boolean overwriteExisting() {
        return this.overwriteExisting;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, byte[]> getMetadata() {
        return this.metadata;
    }

    public boolean getRequireMetadataMatchForEmptyObjects() {
        return this.requireMetadataMatchForEmptyObjects;
    }
}

