/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.PathElement;
import com.google.cloud.datastore.Serializable;
import com.google.cloud.datastore.Validator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1beta3.Key;
import com.google.datastore.v1beta3.PartitionId;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class BaseKey
extends Serializable<Key> {
    private static final long serialVersionUID = -4671243265877410635L;
    private final transient String projectId;
    private final transient String namespace;
    private final transient ImmutableList<PathElement> path;

    BaseKey(String projectId, String namespace, ImmutableList<PathElement> path) {
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty");
        this.projectId = projectId;
        this.namespace = namespace;
        this.path = path;
    }

    public String projectId() {
        return this.projectId;
    }

    public String namespace() {
        return this.namespace;
    }

    public List<PathElement> ancestors() {
        return this.path().subList(0, this.path().size() - 1);
    }

    List<PathElement> path() {
        return this.path;
    }

    PathElement leaf() {
        return this.path().get(this.path().size() - 1);
    }

    public String kind() {
        return this.leaf().kind();
    }

    abstract BaseKey parent();

    public int hashCode() {
        return Objects.hash(this.projectId(), this.namespace(), this.path());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BaseKey)) {
            return false;
        }
        BaseKey other = (BaseKey)obj;
        return Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.path(), other.path());
    }

    @Override
    Key toPb() {
        Key.Builder keyPb = Key.newBuilder();
        PartitionId.Builder partitionIdPb = PartitionId.newBuilder();
        partitionIdPb.setProjectId(this.projectId);
        partitionIdPb.setNamespaceId(this.namespace);
        keyPb.setPartitionId(partitionIdPb.build());
        for (PathElement pathEntry : this.path) {
            keyPb.addPath(pathEntry.toPb());
        }
        return keyPb.build();
    }

    protected static abstract class Builder<B extends Builder<B>> {
        String projectId = "";
        String namespace = "";
        String kind;
        final List<PathElement> ancestors;
        private static final int MAX_PATH = 100;

        Builder(String projectId) {
            this.projectId = Validator.validateDatabase(projectId);
            this.ancestors = new LinkedList<PathElement>();
        }

        Builder(String projectId, String kind) {
            this(projectId);
            this.kind = Validator.validateKind(kind);
        }

        Builder(BaseKey copyFrom) {
            this.projectId = copyFrom.projectId();
            this.namespace = copyFrom.namespace();
            this.ancestors = new LinkedList<PathElement>(copyFrom.ancestors());
            this.kind = copyFrom.kind();
        }

        B self() {
            return (B)this;
        }

        public B ancestors(PathElement ancestor) {
            Preconditions.checkState((this.ancestors.size() < 100 ? 1 : 0) != 0, (Object)"path can have at most 100 elements");
            this.ancestors.add(ancestor);
            return this.self();
        }

        public B ancestors(PathElement ancestor, PathElement ... other) {
            return this.ancestors((Iterable<PathElement>)ImmutableList.builder().add((Object)ancestor).add((Object[])other).build());
        }

        public B ancestors(Iterable<PathElement> ancestors) {
            ImmutableList list = ImmutableList.copyOf(ancestors);
            Preconditions.checkState((this.ancestors.size() + list.size() < 100 ? 1 : 0) != 0, (Object)"path can have at most 100 elements");
            this.ancestors.addAll((Collection<PathElement>)list);
            return this.self();
        }

        public B kind(String kind) {
            this.kind = Validator.validateKind(kind);
            return this.self();
        }

        public B projectId(String projectId) {
            this.projectId = Validator.validateDatabase(projectId);
            return this.self();
        }

        public B namespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this.self();
        }

        protected abstract BaseKey build();
    }
}

