/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiClock;
import com.google.api.core.InternalApi;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.BaseService;
import com.google.cloud.PageImpl;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobException;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.Option;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

final class BigQueryImpl
extends BaseService<BigQueryOptions>
implements BigQuery {
    private final BigQueryRpc bigQueryRpc;

    BigQueryImpl(BigQueryOptions options) {
        super((ServiceOptions)options);
        this.bigQueryRpc = options.getBigQueryRpcV2();
    }

    @Override
    public Dataset create(DatasetInfo datasetInfo, BigQuery.DatasetOption ... options) {
        final com.google.api.services.bigquery.model.Dataset datasetPb = datasetInfo.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Dataset.fromPb(this, (com.google.api.services.bigquery.model.Dataset)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Dataset>(){

                @Override
                public com.google.api.services.bigquery.model.Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.create(datasetPb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Table create(TableInfo tableInfo, BigQuery.TableOption ... options) {
        final com.google.api.services.bigquery.model.Table tablePb = tableInfo.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Table.fromPb(this, (com.google.api.services.bigquery.model.Table)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Table>(){

                @Override
                public com.google.api.services.bigquery.model.Table call() {
                    return BigQueryImpl.this.bigQueryRpc.create(tablePb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Job create(JobInfo jobInfo, BigQuery.JobOption ... options) {
        Supplier<JobId> idProvider = new Supplier<JobId>(){

            public JobId get() {
                return JobId.of();
            }
        };
        return this.create(jobInfo, idProvider, options);
    }

    @InternalApi(value="visible for testing")
    Job create(JobInfo jobInfo, Supplier<JobId> idProvider, BigQuery.JobOption ... options) {
        boolean idRandom = false;
        if (jobInfo.getJobId() == null) {
            jobInfo = jobInfo.toBuilder().setJobId((JobId)idProvider.get()).build();
            idRandom = true;
        }
        final com.google.api.services.bigquery.model.Job jobPb = jobInfo.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            try {
                return Job.fromPb(this, (com.google.api.services.bigquery.model.Job)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Job>(){

                    @Override
                    public com.google.api.services.bigquery.model.Job call() {
                        return BigQueryImpl.this.bigQueryRpc.create(jobPb, optionsMap);
                    }
                }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
            }
            catch (RetryHelper.RetryHelperException e) {
                throw BigQueryException.translateAndThrow(e);
            }
        }
        catch (BigQueryException e) {
            BigQueryException createException = e;
            if (!idRandom) {
                throw createException;
            }
            try {
                return this.getJob(jobInfo.getJobId(), new BigQuery.JobOption[0]);
            }
            catch (BigQueryException e2) {
                throw createException;
            }
        }
    }

    @Override
    public Dataset getDataset(String datasetId, BigQuery.DatasetOption ... options) {
        return this.getDataset(DatasetId.of(datasetId), options);
    }

    @Override
    public Dataset getDataset(DatasetId datasetId, BigQuery.DatasetOption ... options) {
        final DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            com.google.api.services.bigquery.model.Dataset answer = (com.google.api.services.bigquery.model.Dataset)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Dataset>(){

                @Override
                public com.google.api.services.bigquery.model.Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.getDataset(completeDatasetId.getProject(), completeDatasetId.getDataset(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            return answer == null ? null : Dataset.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Dataset> listDatasets(BigQuery.DatasetListOption ... options) {
        return this.listDatasets(((BigQueryOptions)this.getOptions()).getProjectId(), options);
    }

    @Override
    public Page<Dataset> listDatasets(String projectId, BigQuery.DatasetListOption ... options) {
        return BigQueryImpl.listDatasets(projectId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    private static Page<Dataset> listDatasets(final String projectId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Dataset>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Dataset>> call() {
                    return serviceOptions.getBigQueryRpcV2().listDatasets(projectId, optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            return new PageImpl((PageImpl.NextPageFetcher)new DatasetPageFetcher(projectId, serviceOptions, cursor, optionsMap), cursor, Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Dataset, Dataset>(){

                public Dataset apply(com.google.api.services.bigquery.model.Dataset dataset) {
                    return Dataset.fromPb((BigQuery)serviceOptions.getService(), dataset);
                }
            }));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String datasetId, BigQuery.DatasetDeleteOption ... options) {
        return this.delete(DatasetId.of(datasetId), options);
    }

    @Override
    public boolean delete(DatasetId datasetId, BigQuery.DatasetDeleteOption ... options) {
        final DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteDataset(completeDatasetId.getProject(), completeDatasetId.getDataset(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String datasetId, String tableId) {
        return this.delete(TableId.of(datasetId, tableId));
    }

    @Override
    public boolean delete(TableId tableId) {
        final TableId completeTableId = tableId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteTable(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable());
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Dataset update(DatasetInfo datasetInfo, BigQuery.DatasetOption ... options) {
        final com.google.api.services.bigquery.model.Dataset datasetPb = datasetInfo.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Dataset.fromPb(this, (com.google.api.services.bigquery.model.Dataset)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Dataset>(){

                @Override
                public com.google.api.services.bigquery.model.Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.patch(datasetPb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Table update(TableInfo tableInfo, BigQuery.TableOption ... options) {
        final com.google.api.services.bigquery.model.Table tablePb = tableInfo.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            return Table.fromPb(this, (com.google.api.services.bigquery.model.Table)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Table>(){

                @Override
                public com.google.api.services.bigquery.model.Table call() {
                    return BigQueryImpl.this.bigQueryRpc.patch(tablePb, optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Table getTable(String datasetId, String tableId, BigQuery.TableOption ... options) {
        return this.getTable(TableId.of(datasetId, tableId), options);
    }

    @Override
    public Table getTable(TableId tableId, BigQuery.TableOption ... options) {
        final TableId completeTableId = tableId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        try {
            com.google.api.services.bigquery.model.Table answer = (com.google.api.services.bigquery.model.Table)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Table>(){

                @Override
                public com.google.api.services.bigquery.model.Table call() {
                    return BigQueryImpl.this.bigQueryRpc.getTable(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            return answer == null ? null : Table.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Table> listTables(String datasetId, BigQuery.TableListOption ... options) {
        return BigQueryImpl.listTables(DatasetId.of(((BigQueryOptions)this.getOptions()).getProjectId(), datasetId), (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    @Override
    public Page<Table> listTables(DatasetId datasetId, BigQuery.TableListOption ... options) {
        DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        return BigQueryImpl.listTables(completeDatasetId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    private static Page<Table> listTables(final DatasetId datasetId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Table>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Table>> call() {
                    return serviceOptions.getBigQueryRpcV2().listTables(datasetId.getProject(), datasetId.getDataset(), optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = (String)result.x();
            Iterable tables = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Table, Table>(){

                public Table apply(com.google.api.services.bigquery.model.Table table) {
                    return Table.fromPb((BigQuery)serviceOptions.getService(), table);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new TablePageFetcher(datasetId, serviceOptions, cursor, optionsMap), cursor, tables);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public InsertAllResponse insertAll(InsertAllRequest request) {
        TableDataInsertAllResponse responsePb;
        final TableId tableId = request.getTable().setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        final TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest();
        requestPb.setIgnoreUnknownValues(request.ignoreUnknownValues());
        requestPb.setSkipInvalidRows(request.skipInvalidRows());
        requestPb.setTemplateSuffix(request.getTemplateSuffix());
        final boolean[] allInsertIdsSet = new boolean[]{true};
        List rowsPb = Lists.transform(request.getRows(), (Function)new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                allInsertIdsSet[0] = allInsertIdsSet[0] & rowToInsert.getId() != null;
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.getId()).setJson(rowToInsert.getContent());
            }
        });
        requestPb.setRows(rowsPb);
        if (allInsertIdsSet[0]) {
            try {
                responsePb = (TableDataInsertAllResponse)RetryHelper.runWithRetries((Callable)new Callable<TableDataInsertAllResponse>(){

                    @Override
                    public TableDataInsertAllResponse call() throws Exception {
                        return BigQueryImpl.this.bigQueryRpc.insertAll(tableId.getProject(), tableId.getDataset(), tableId.getTable(), requestPb);
                    }
                }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            }
            catch (RetryHelper.RetryHelperException e) {
                throw BigQueryException.translateAndThrow(e);
            }
        } else {
            responsePb = this.bigQueryRpc.insertAll(tableId.getProject(), tableId.getDataset(), tableId.getTable(), requestPb);
        }
        return InsertAllResponse.fromPb(responsePb);
    }

    @Override
    public TableResult listTableData(String datasetId, String tableId, BigQuery.TableDataListOption ... options) {
        return this.listTableData(TableId.of(datasetId, tableId), options);
    }

    @Override
    public TableResult listTableData(TableId tableId, BigQuery.TableDataListOption ... options) {
        return this.listTableData(tableId, (Schema)null, options);
    }

    @Override
    public TableResult listTableData(String datasetId, String tableId, Schema schema, BigQuery.TableDataListOption ... options) {
        return this.listTableData(TableId.of(datasetId, tableId), schema, options);
    }

    @Override
    public TableResult listTableData(TableId tableId, Schema schema, BigQuery.TableDataListOption ... options) {
        Tuple<? extends Page<FieldValueList>, Long> data = BigQueryImpl.listTableData(tableId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
        return new TableResult(schema, (Long)data.y(), (Page<FieldValueList>)((Page)data.x()));
    }

    private static Tuple<? extends Page<FieldValueList>, Long> listTableData(TableId tableId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            final TableId completeTableId = tableId.setProjectId(serviceOptions.getProjectId());
            TableDataList result = (TableDataList)RetryHelper.runWithRetries((Callable)new Callable<TableDataList>(){

                @Override
                public TableDataList call() {
                    return serviceOptions.getBigQueryRpcV2().listTableData(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable(), optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            String cursor = result.getPageToken();
            return Tuple.of((Object)new PageImpl((PageImpl.NextPageFetcher)new TableDataPageFetcher(tableId, serviceOptions, cursor, optionsMap), cursor, BigQueryImpl.transformTableData(result.getRows())), (Object)result.getTotalRows());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static Iterable<FieldValueList> transformTableData(Iterable<TableRow> tableDataPb) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)(tableDataPb != null ? tableDataPb : ImmutableList.of()), (Function)new Function<TableRow, FieldValueList>(){

            public FieldValueList apply(TableRow rowPb) {
                return FieldValueList.fromPb(rowPb.getF(), null);
            }
        }));
    }

    @Override
    public Job getJob(String jobId, BigQuery.JobOption ... options) {
        return this.getJob(JobId.of(jobId), options);
    }

    @Override
    public Job getJob(JobId jobId, BigQuery.JobOption ... options) {
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        final JobId completeJobId = jobId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        try {
            com.google.api.services.bigquery.model.Job answer = (com.google.api.services.bigquery.model.Job)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Job>(){

                @Override
                public com.google.api.services.bigquery.model.Job call() {
                    return BigQueryImpl.this.bigQueryRpc.getJob(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation(), optionsMap);
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
            return answer == null ? null : Job.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Job> listJobs(BigQuery.JobListOption ... options) {
        return BigQueryImpl.listJobs((BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
    }

    private static Page<Job> listJobs(final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        Tuple result = (Tuple)RetryHelper.runWithRetries((Callable)new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Job>>>(){

            @Override
            public Tuple<String, Iterable<com.google.api.services.bigquery.model.Job>> call() {
                return serviceOptions.getBigQueryRpcV2().listJobs(serviceOptions.getProjectId(), optionsMap);
            }
        }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
        String cursor = (String)result.x();
        Iterable jobs = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Job, Job>(){

            public Job apply(com.google.api.services.bigquery.model.Job job) {
                return Job.fromPb((BigQuery)serviceOptions.getService(), job);
            }
        });
        return new PageImpl((PageImpl.NextPageFetcher)new JobPageFetcher(serviceOptions, cursor, optionsMap), cursor, jobs);
    }

    @Override
    public boolean cancel(String jobId) {
        return this.cancel(JobId.of(jobId));
    }

    @Override
    public boolean cancel(JobId jobId) {
        final JobId completeJobId = jobId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.cancel(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation());
                }
            }, (RetrySettings)((BigQueryOptions)this.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((BigQueryOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public TableResult query(QueryJobConfiguration configuration, BigQuery.JobOption ... options) throws InterruptedException, JobException {
        Job.checkNotDryRun(configuration, "query");
        return this.create(JobInfo.of(configuration), options).getQueryResults(new BigQuery.QueryResultsOption[0]);
    }

    @Override
    public TableResult query(QueryJobConfiguration configuration, JobId jobId, BigQuery.JobOption ... options) throws InterruptedException, JobException {
        Job.checkNotDryRun(configuration, "query");
        return this.create(JobInfo.of(jobId, configuration), options).getQueryResults(new BigQuery.QueryResultsOption[0]);
    }

    @Override
    public QueryResponse getQueryResults(JobId jobId, BigQuery.QueryResultsOption ... options) {
        Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        return BigQueryImpl.getQueryResults(jobId, (BigQueryOptions)this.getOptions(), optionsMap);
    }

    private static QueryResponse getQueryResults(JobId jobId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        final JobId completeJobId = jobId.setProjectId(serviceOptions.getProjectId());
        try {
            GetQueryResultsResponse results = (GetQueryResultsResponse)RetryHelper.runWithRetries((Callable)new Callable<GetQueryResultsResponse>(){

                @Override
                public GetQueryResultsResponse call() {
                    return serviceOptions.getBigQueryRpcV2().getQueryResults(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation(), optionsMap);
                }
            }, (RetrySettings)serviceOptions.getRetrySettings(), (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)serviceOptions.getClock());
            TableSchema schemaPb = results.getSchema();
            ImmutableList.Builder errors = ImmutableList.builder();
            if (results.getErrors() != null) {
                for (ErrorProto error : results.getErrors()) {
                    errors.add((Object)BigQueryError.fromPb(error));
                }
            }
            return QueryResponse.newBuilder().setCompleted(results.getJobComplete()).setSchema(schemaPb == null ? null : Schema.fromPb(schemaPb)).setTotalRows(results.getTotalRows() == null ? 0L : results.getTotalRows().longValue()).setErrors((ImmutableList<BigQueryError>)errors.build()).build();
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public TableDataWriteChannel writer(WriteChannelConfiguration writeChannelConfiguration) {
        return this.writer(JobId.of(), writeChannelConfiguration);
    }

    @Override
    public TableDataWriteChannel writer(JobId jobId, WriteChannelConfiguration writeChannelConfiguration) {
        return new TableDataWriteChannel((BigQueryOptions)this.getOptions(), jobId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()), writeChannelConfiguration.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()));
    }

    @VisibleForTesting
    static Map<BigQueryRpc.Option, ?> optionMap(Option ... options) {
        EnumMap optionMap = Maps.newEnumMap(BigQueryRpc.Option.class);
        for (Option option : options) {
            Object prev = optionMap.put(option.getRpcOption(), option.getValue());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object)option);
        }
        return optionMap;
    }

    private static class TableDataPageFetcher
    implements PageImpl.NextPageFetcher<FieldValueList> {
        private static final long serialVersionUID = -8501991114794410114L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final TableId table;

        TableDataPageFetcher(TableId table, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.table = table;
        }

        public Page<FieldValueList> getNextPage() {
            return (Page)BigQueryImpl.listTableData(this.table, this.serviceOptions, this.requestOptions).x();
        }
    }

    private static class JobPageFetcher
    implements PageImpl.NextPageFetcher<Job> {
        private static final long serialVersionUID = 8536533282558245472L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;

        JobPageFetcher(BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Job> getNextPage() {
            return BigQueryImpl.listJobs(this.serviceOptions, this.requestOptions);
        }
    }

    private static class TablePageFetcher
    implements PageImpl.NextPageFetcher<Table> {
        private static final long serialVersionUID = 8611248840504201187L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final DatasetId datasetId;

        TablePageFetcher(DatasetId datasetId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.datasetId = datasetId;
        }

        public Page<Table> getNextPage() {
            return BigQueryImpl.listTables(this.datasetId, this.serviceOptions, this.requestOptions);
        }
    }

    private static class DatasetPageFetcher
    implements PageImpl.NextPageFetcher<Dataset> {
        private static final long serialVersionUID = -3057564042439021278L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final String projectId;

        DatasetPageFetcher(String projectId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.projectId = projectId;
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Dataset> getNextPage() {
            return BigQueryImpl.listDatasets(this.projectId, this.serviceOptions, this.requestOptions);
        }
    }
}

