/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.FinalizableSoftReference;
import com.google.common.base.FinalizableWeakReference;
import com.google.common.base.Preconditions;
import com.google.common.base.ReferenceType;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractRemovableIterator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferenceMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private final ReferenceStrategy keyStrategy;
    private final ReferenceStrategy valueStrategy;
    private transient ConcurrentMap<Object, Object> delegate;
    private transient EntrySet entrySet;
    private static final long serialVersionUID = 0L;

    public ReferenceMap(ReferenceType keyReferenceType, ReferenceType valueReferenceType) {
        this(keyReferenceType, valueReferenceType, new ConcurrentHashMap<Object, Object>());
    }

    public ReferenceMap(ReferenceType keyReferenceType, ReferenceType valueReferenceType, ConcurrentMap<Object, Object> backingMap) {
        Preconditions.checkArgument(keyReferenceType != ReferenceType.PHANTOM, "Phantom references are not supported.");
        Preconditions.checkArgument(valueReferenceType != ReferenceType.PHANTOM, "Phantom references are not supported.");
        Preconditions.checkArgument(backingMap.isEmpty(), "The backing map must be empty.");
        this.keyStrategy = ReferenceStrategy.forType(keyReferenceType);
        this.valueStrategy = ReferenceStrategy.forType(valueReferenceType);
        this.delegate = backingMap;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Object keyDummy = this.keyStrategy.getDummyFor(key);
        return this.delegate.containsKey(keyDummy);
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value);
        for (Object valueReference : this.delegate.values()) {
            if (!value.equals(this.dereferenceValue(valueReference))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Object keyDummy = this.keyStrategy.getDummyFor(key);
        Object valueReference = this.delegate.get(keyDummy);
        return this.dereferenceValue(valueReference);
    }

    @Override
    public V put(K key, V value) {
        Object keyReference = this.referenceKey(key);
        Object valueReference = this.referenceValue(keyReference, value);
        return this.dereferenceValue(this.delegate.put(keyReference, valueReference));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V existingValue;
        Object existingValueReference;
        Object keyReference = this.referenceKey(key);
        Object valueReference = this.referenceValue(keyReference, value);
        while (ReferenceMap.isPartiallyReclaimed(existingValueReference = this.delegate.putIfAbsent(keyReference, valueReference), existingValue = this.dereferenceValue(existingValueReference))) {
        }
        return existingValue;
    }

    @Override
    public V replace(K key, V value) {
        V existingValue;
        Object keyReference = this.referenceKey(key);
        Object valueReference = this.referenceValue(keyReference, value);
        while (true) {
            Object existingValueReference;
            if (ReferenceMap.isPartiallyReclaimed(existingValueReference = this.delegate.get(keyReference), existingValue = this.dereferenceValue(existingValueReference))) {
                continue;
            }
            if (existingValueReference == null) {
                return null;
            }
            if (this.delegate.replace(keyReference, existingValueReference, valueReference)) break;
        }
        return existingValue;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object keyReference = this.referenceKey(key);
        Object oldValueDummy = this.valueStrategy.getDummyFor(oldValue);
        Object newValueReference = this.referenceValue(keyReference, newValue);
        return this.delegate.replace(keyReference, oldValueDummy, newValueReference);
    }

    private static boolean isPartiallyReclaimed(Object valueReference, Object value) {
        return valueReference != null && value == null;
    }

    @Override
    public V remove(Object key) {
        Object keyDummy = this.keyStrategy.getDummyFor(key);
        Object valueReference = this.delegate.remove(keyDummy);
        return this.dereferenceValue(valueReference);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object keyDummy = this.keyStrategy.getDummyFor(key);
        Object valueDummy = this.valueStrategy.getDummyFor(value);
        return this.delegate.remove(keyDummy, valueDummy);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size());
        for (Map.Entry<K, V> entry : this.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeObject(null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object key;
        in.defaultReadObject();
        int approximateSize = in.readInt();
        this.delegate = new ConcurrentHashMap<Object, Object>(Maps.capacity(approximateSize));
        while ((key = in.readObject()) != null) {
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    private static boolean referenceEquals(Reference<?> reference, Object object) {
        if (object == reference) {
            return true;
        }
        if (object instanceof InternalReference) {
            Object referent = ((InternalReference)object).get();
            return referent != null && referent == reference.get();
        }
        return ((DummyReference)object).unwrap() == reference.get();
    }

    private Object referenceKey(K key) {
        return this.keyStrategy.referenceKey(this, Preconditions.checkNotNull(key));
    }

    private Object referenceValue(Object keyReference, V value) {
        return this.valueStrategy.referenceValue(this, keyReference, Preconditions.checkNotNull(value));
    }

    private V dereferenceValue(Object object) {
        if (object == null) {
            return null;
        }
        return (V)this.valueStrategy.dereferenceValue(object);
    }

    private static class DummyReference {
        final Object wrapped;

        DummyReference(Object wrapped) {
            this.wrapped = wrapped;
        }

        Object unwrap() {
            return this.wrapped;
        }

        public int hashCode() {
            return System.identityHashCode(this.wrapped);
        }

        public boolean equals(Object object) {
            return object.equals(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakValueReference
    extends FinalizableWeakReference<Object>
    implements InternalReference {
        final Object keyReference;

        WeakValueReference(Object keyReference, Object value) {
            super(value);
            this.keyReference = keyReference;
        }

        @Override
        public void finalizeReferent() {
            ReferenceMap.this.delegate.remove(this.keyReference, this);
        }

        public int hashCode() {
            throw new AssertionError((Object)"don't hash me");
        }

        public boolean equals(Object obj) {
            return ReferenceMap.referenceEquals(this, obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakKeyReference
    extends FinalizableWeakReference<Object>
    implements InternalReference {
        final int hashCode;

        WeakKeyReference(Object key) {
            super(key);
            this.hashCode = System.identityHashCode(key);
        }

        @Override
        public void finalizeReferent() {
            ReferenceMap.this.delegate.remove(this);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            return ReferenceMap.referenceEquals(this, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SoftValueReference
    extends FinalizableSoftReference<Object>
    implements InternalReference {
        final Object keyReference;

        SoftValueReference(Object keyReference, Object value) {
            super(value);
            this.keyReference = keyReference;
        }

        @Override
        public void finalizeReferent() {
            ReferenceMap.this.delegate.remove(this.keyReference, this);
        }

        public int hashCode() {
            throw new AssertionError((Object)"don't hash me");
        }

        public boolean equals(Object obj) {
            return ReferenceMap.referenceEquals(this, obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SoftKeyReference
    extends FinalizableSoftReference<Object>
    implements InternalReference {
        final int hashCode;

        SoftKeyReference(Object key) {
            super(key);
            this.hashCode = System.identityHashCode(key);
        }

        @Override
        public void finalizeReferent() {
            ReferenceMap.this.delegate.remove(this);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            return ReferenceMap.referenceEquals(this, object);
        }
    }

    private static interface InternalReference {
        public void finalizeReferent();

        public Object get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReferenceStrategy {
        DIRECT{

            @Override
            Object referenceKey(ReferenceMap<?, ?> map, Object key) {
                return key;
            }

            @Override
            Object referenceValue(ReferenceMap<?, ?> map, Object keyReference, Object value) {
                return value;
            }

            @Override
            Object dereferenceKey(Object reference) {
                return reference;
            }

            @Override
            Object dereferenceValue(Object object) {
                return object;
            }

            @Override
            Object getDummyFor(Object object) {
                return Preconditions.checkNotNull(object);
            }
        }
        ,
        WRAP_IN_SOFT{

            @Override
            Object referenceKey(ReferenceMap<?, ?> map, Object key) {
                ReferenceMap<?, ?> referenceMap = map;
                referenceMap.getClass();
                return referenceMap.new SoftKeyReference(key);
            }

            @Override
            Object referenceValue(ReferenceMap<?, ?> map, Object keyReference, Object value) {
                ReferenceMap<?, ?> referenceMap = map;
                referenceMap.getClass();
                return referenceMap.new SoftValueReference(keyReference, value);
            }
        }
        ,
        WRAP_IN_WEAK{

            @Override
            Object referenceKey(ReferenceMap<?, ?> map, Object key) {
                ReferenceMap<?, ?> referenceMap = map;
                referenceMap.getClass();
                return referenceMap.new WeakKeyReference(key);
            }

            @Override
            Object referenceValue(ReferenceMap<?, ?> map, Object keyReference, Object value) {
                ReferenceMap<?, ?> referenceMap = map;
                referenceMap.getClass();
                return referenceMap.new WeakValueReference(keyReference, value);
            }
        };


        abstract Object referenceKey(ReferenceMap<?, ?> var1, Object var2);

        abstract Object referenceValue(ReferenceMap<?, ?> var1, Object var2, Object var3);

        Object dereferenceKey(Object reference) {
            return ((Reference)reference).get();
        }

        Object dereferenceValue(Object object) {
            InternalReference reference = (InternalReference)object;
            Object value = reference.get();
            if (value == null) {
                reference.finalizeReferent();
            }
            return value;
        }

        Object getDummyFor(Object object) {
            return new DummyReference(Preconditions.checkNotNull(object));
        }

        static ReferenceStrategy forType(ReferenceType type) {
            switch (Preconditions.checkNotNull(type)) {
                case STRONG: {
                    return DIRECT;
                }
                case SOFT: {
                    return WRAP_IN_SOFT;
                }
                case WEAK: {
                    return WRAP_IN_WEAK;
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends AbstractRemovableIterator<Map.Entry<K, V>> {
        Iterator<Map.Entry<Object, Object>> delegateEntries;

        private EntryIterator() {
            this.delegateEntries = ReferenceMap.this.delegate.entrySet().iterator();
        }

        @Override
        protected Map.Entry<K, V> computeNext() {
            while (this.delegateEntries.hasNext()) {
                Object value;
                Map.Entry<Object, Object> entry = this.delegateEntries.next();
                Object reference = entry.getKey();
                final Object key = ReferenceMap.this.keyStrategy.dereferenceKey(reference);
                if (key == null || (value = ReferenceMap.this.dereferenceValue(entry.getValue())) == null) continue;
                return new AbstractMapEntry<K, V>(){
                    V currentValue;
                    {
                        this.currentValue = value;
                    }

                    @Override
                    public K getKey() {
                        return key;
                    }

                    @Override
                    public V getValue() {
                        return this.currentValue;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public V setValue(V newValue) {
                        ReferenceMap.this.put(key, newValue);
                        try {
                            Object v = this.currentValue;
                            return v;
                        }
                        finally {
                            this.currentValue = newValue;
                        }
                    }
                };
            }
            return (Map.Entry)this.endOfData();
        }

        @Override
        public void remove(Map.Entry<K, V> entry) {
            ReferenceMap.this.remove(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return ReferenceMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ReferenceMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            Preconditions.checkNotNull(object);
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object key = entry.getKey();
            Object value = entry.getValue();
            return key != null && value != null && value.equals(ReferenceMap.this.get(key));
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Preconditions.checkNotNull(array);
            return this.snapshot().toArray(array);
        }

        private List<Map.Entry<K, V>> snapshot() {
            ArrayList list = Lists.newArrayListWithExpectedSize(this.size());
            for (Map.Entry entry : this) {
                list.add(entry);
            }
            return list;
        }

        @Override
        public boolean remove(Object object) {
            Preconditions.checkNotNull(object);
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return ReferenceMap.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public void clear() {
            ReferenceMap.this.clear();
        }
    }
}

